<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" value="<?php echo e(csrf_token()); ?>"/>
    <title><?php echo e(env('APP_NAME')); ?></title>
    <link href="<?php echo e(asset('css/app.css')); ?>" type="text/css" rel="stylesheet"/>
    <!-- Icons -->
  <link href="<?php echo e(asset('argon')); ?>/vendor/nucleo/css/nucleo.css" rel="stylesheet">
        <link href="<?php echo e(asset('argon')); ?>/vendor/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet">
        <!-- Argon CSS -->
        <link type="text/css" href="<?php echo e(asset('argon')); ?>/css/argon.min.css" rel="stylesheet">
        <link type="text/css" href="<?php echo e(asset('argon')); ?>/css/font_lao.css" rel="stylesheet">
       <!--  <link type="text/css" href="http://cdn.datatables.net/1.10.25/css/jquery.dataTables.min.css" rel="stylesheet"> -->
       <!-- <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet"> -->
        
        
</head>
<body>

<?php if(Auth::check()): ?>
    <?php
    $user_auth_data = [
        'isLoggedin' => true,
        'user' =>  Auth::user()
    ];
    ?>
<?php else: ?>
    <?php
    $user_auth_data = [
        'isLoggedin' => false
    ];
    ?>
<?php endif; ?>
<script>
    window.Laravel = JSON.parse(atob('<?php echo e(base64_encode(json_encode($user_auth_data))); ?>'));
</script>

<div id="app"></div> 


<script src="<?php echo e(asset('js/manifest.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('js/vendor.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('js/app.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('argon')); ?>/vendor/js-cookie/js.cookie.js" ></script>
<script src="<?php echo e(asset('argon')); ?>/vendor/chart.js/dist/Chart.min.js" ></script>
<script src="<?php echo e(asset('argon')); ?>/vendor/chart.js/dist/Chart.extension.js" ></script>
<script src="<?php echo e(asset('argon')); ?>/vendor/jquery.scrollbar/jquery.scrollbar.min.js" ></script>
<script src="<?php echo e(asset('argon')); ?>/js/argon.min.js" ></script>
<script src="<?php echo e(asset('argon')); ?>/js/datatable.js" ></script>
</body>
</html><?php /**PATH /Users/sone/My Data/Developer/Laravel8+vue3/my_app_vue/resources/views/app.blade.php ENDPATH**/ ?>