<?php

use App\Http\Controllers\API\PrintController;
use App\Http\Controllers\API\BookController;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\CustomerController;
use App\Http\Controllers\API\BillsController;
use App\Http\Controllers\API\BillsListController;
use App\Http\Controllers\API\QuotationController;
use App\Http\Controllers\API\QuotationListController;
use App\Http\Controllers\API\BillSettingController;
use App\Http\Controllers\API\CustomerOfficeController;
use App\Http\Controllers\API\RepaireController;
use App\Http\Controllers\API\ListRepaireItemController;
use App\Http\Controllers\API\UploadImgController;
use App\Http\Controllers\ACC\AccCategoryController;
use App\Http\Controllers\ACC\AccSubCatController;
use App\Http\Controllers\ACC\AccController;
use App\Http\Controllers\ACC\AccTLController;
use App\Http\Controllers\ACC\AccTRNController;
use App\Http\Controllers\STORE\SessionProductController;
use App\Http\Controllers\STORE\BrandController;
use App\Http\Controllers\STORE\UnitController;
use App\Http\Controllers\STORE\ProductController;
use App\Http\Controllers\STORE\StoreController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\ACC\TempTRNController;
use App\Http\Controllers\API\ServiceController;
use App\Http\Controllers\PreOrder\PreOrderController;
use App\Http\Controllers\PreOrder\PreOrderItemController;
use App\Http\Controllers\PreOrder\SupplierController;
use App\Http\Controllers\ACC\ReportController;
use App\Http\Controllers\API\SettingController;

use App\Http\Controllers\API\RolesController;
use App\Http\Controllers\API\RolesPermissionsController;

use App\Http\Controllers\API\GenPDFController;
use Illuminate\Support\Facades\Route;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Hash;

Route::get('users/checkauth', [UserController::class, 'checkauth']);

Route::post('login', [UserController::class, 'login']);
//Route::post('register', [UserController::class, 'register']);
Route::post('logout', [UserController::class, 'logout'])->middleware('auth:sanctum');

Route::group(['prefix' => 'books', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [BookController::class, 'index']);
    Route::post('add', [BookController::class, 'add']);
    Route::get('edit/{id}', [BookController::class, 'edit']);
    Route::post('update/{id}', [BookController::class, 'update']);
    Route::delete('delete/{id}', [BookController::class, 'delete']);
});

Route::group(['prefix' => 'users', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [UserController::class, 'index']);
    Route::post('add', [UserController::class, 'add']);
    Route::get('edit/{id}', [UserController::class, 'edit']);
    Route::post('update/{id}', [UserController::class, 'update']);
    Route::delete('delete/{id}', [UserController::class, 'delete']);
});

Route::group(['prefix' => 'customer', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [CustomerController::class, 'index']);
    Route::get('getall', [CustomerController::class, 'GetAllCustomer']);
    Route::get('billlist', [CustomerController::class, 'ListToBill']);
    Route::post('addall', [CustomerController::class, 'addall']);
    Route::post('add', [CustomerController::class, 'add']);
    Route::get('edit/{id}', [CustomerController::class, 'edit']);
    Route::post('update/{id}', [CustomerController::class, 'update']);
    Route::delete('delete/{id}', [CustomerController::class, 'delete']);
});

Route::group(['prefix' => 'customeroffice', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [CustomerOfficeController::class, 'index']);
    Route::post('add', [CustomerOfficeController::class, 'add']);
    Route::get('edit/{id}', [CustomerOfficeController::class, 'edit']);
    Route::post('update/{id}', [CustomerOfficeController::class, 'update']);
    Route::delete('delete/{id}', [CustomerOfficeController::class, 'delete']);
});


Route::group(['prefix' => 'bills', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [BillsController::class, 'index']);
    Route::post('addbills', [BillsController::class, 'addbills']);
    Route::post('addbillRe', [BillsController::class, 'addbillRe']);
    Route::post('addbillpos', [BillsController::class, 'addbillpos']);
    Route::post('import_quo_to_bill/{id}', [BillsController::class, 'import_quotation_to_bill']);
    Route::get('edit/{id}', [BillsController::class, 'edit']);
    Route::post('update/{id}', [BillsController::class, 'update']);
    Route::delete('delete/{id}', [BillsController::class, 'delete']);
});

Route::group(['prefix' => 'billslist', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [BillsListController::class, 'index']);
    Route::post('add', [BillsListController::class, 'add']);
    Route::get('edit/{id}', [BillsListController::class, 'edit']);
    Route::post('update/{id}', [BillsListController::class, 'update']);
    Route::delete('delete/{id}', [BillsListController::class, 'delete']);
});


Route::group(['prefix' => 'quotation', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [QuotationController::class, 'index']);
    Route::post('add', [QuotationController::class, 'add']);
    Route::post('addQuo', [QuotationController::class, 'addQuo']);
    Route::get('edit/{id}', [QuotationController::class, 'edit']);
    Route::post('update/{id}', [QuotationController::class, 'update']);
    Route::delete('delete/{id}', [QuotationController::class, 'delete']);
});

Route::group(['prefix' => 'quotationlist', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [QuotationListController::class, 'index']);
    Route::post('add', [QuotationListController::class, 'add']);
    Route::get('edit/{id}', [QuotationListController::class, 'edit']);
    Route::post('update/{id}', [QuotationListController::class, 'update']);
    Route::delete('delete/{id}', [QuotationListController::class, 'delete']);
});

Route::group(['prefix' => 'billsetting', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [BillSettingController::class, 'index']);
    Route::post('add', [BillSettingController::class, 'add']);
    Route::get('edit/{id}', [BillSettingController::class, 'edit']);
    Route::post('update/{id}', [BillSettingController::class, 'update']);
    Route::delete('delete/{id}', [BillSettingController::class, 'delete']);
});

Route::group(['prefix' => 'repaire', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [RepaireController::class, 'index']);
    Route::post('add', [RepaireController::class, 'add']);
    Route::get('edit/{id}', [RepaireController::class, 'edit']);
    Route::post('update/{id}', [RepaireController::class, 'update']);
    Route::delete('delete/{id}', [RepaireController::class, 'delete']);
    Route::post('deleteImage/{id}', [RepaireController::class, 'deleteImage']);
});

Route::group(['prefix' => 'listrepaireitem', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [ListRepaireItemController::class, 'index']);
    Route::post('add', [ListRepaireItemController::class, 'add']);
    Route::get('edit/{id}', [ListRepaireItemController::class, 'edit']);
    Route::post('update/{id}', [ListRepaireItemController::class, 'update']);
    Route::delete('delete/{id}', [ListRepaireItemController::class, 'delete']);
});

Route::group(['prefix' => 'img', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [UploadImgController::class, 'index']);
    Route::post('upload', [UploadImgController::class, 'fileStore']);
    Route::post('upload_img_product', [UploadImgController::class, 'img_product']);
    Route::post('del_img_product', [UploadImgController::class, 'del_img_product']);
    Route::post('del_img_avatars', [UploadImgController::class, 'del_img_avatars']);
    Route::post('upload_img_repaire', [UploadImgController::class, 'imgrepaire']);
    Route::post('update/{id}', [UploadImgController::class, 'update']);
    Route::delete('delete/{id}', [UploadImgController::class, 'delete']);
});

Route::group(['prefix' => 'acc_category', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [AccCategoryController::class, 'index']);
    Route::post('add', [AccCategoryController::class, 'add']);
    Route::get('edit/{id}', [AccCategoryController::class, 'edit']);
    Route::post('update/{id}', [AccCategoryController::class, 'update']);
    Route::delete('delete/{id}', [AccCategoryController::class, 'delete']);
});

Route::group(['prefix' => 'acc_sub', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [AccSubCatController::class, 'index']);
    Route::post('add', [AccSubCatController::class, 'add']);
    Route::get('edit/{id}', [AccSubCatController::class, 'edit']);
    Route::post('update/{id}', [AccSubCatController::class, 'update']);
    Route::delete('delete/{id}', [AccSubCatController::class, 'delete']);
});

Route::group(['prefix' => 'acc', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [AccController::class, 'index']);
    Route::post('add', [AccController::class, 'add']);
    Route::get('edit/{id}', [AccController::class, 'edit']);
    Route::post('update/{id}', [AccController::class, 'update']);
    Route::delete('delete/{id}', [AccController::class, 'delete']);
});

Route::group(['prefix' => 'acctl', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [AccTLController::class, 'index']);
    Route::post('add', [AccTLController::class, 'add']);
    Route::get('edit/{id}', [AccTLController::class, 'edit']);
    Route::post('update/{id}', [AccTLController::class, 'update']);
    Route::delete('delete/{id}', [AccTLController::class, 'delete']);
});

Route::group(['prefix' => 'acctrn', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [AccTRNController::class, 'index']);
    Route::post('add', [AccTRNController::class, 'add']);
    Route::get('edit/{id}', [AccTRNController::class, 'edit']);
    Route::post('update/{id}', [AccTRNController::class, 'update']);
    Route::delete('delete/{id}', [AccTRNController::class, 'delete']);
});
 
Route::group(['prefix' => 'store/setting', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [SessionProductController::class, 'index']);
    Route::post('add', [SessionProductController::class, 'add']);
    Route::get('edit/{id}', [SessionProductController::class, 'edit']);
    Route::post('update/{id}', [SessionProductController::class, 'update']);
    Route::delete('delete/{id}', [SessionProductController::class, 'delete']);
});

Route::group(['prefix' => 'store/brand', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [BrandController::class, 'index']);
    Route::post('add', [BrandController::class, 'add']);
    Route::get('edit/{id}', [BrandController::class, 'edit']);
    Route::post('update/{id}', [BrandController::class, 'update']);
    Route::delete('delete/{id}', [BrandController::class, 'delete']);
});

Route::group(['prefix' => 'store/unit', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [UnitController::class, 'index']);
    Route::post('add', [UnitController::class, 'add']);
    Route::get('edit/{id}', [UnitController::class, 'edit']);
    Route::post('update/{id}', [UnitController::class, 'update']);
    Route::delete('delete/{id}', [UnitController::class, 'delete']);
});

Route::group(['prefix' => 'store/product', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [ProductController::class, 'index']);
    Route::get('/import', [ProductController::class, 'getimport']);
    Route::post('add', [ProductController::class, 'add']);
    Route::get('edit/{id}', [ProductController::class, 'edit']);
    Route::get('sbarcode/{id}', [ProductController::class, 'sbarcode']);
    Route::get('sproduct/{id}', [ProductController::class, 'sproduct']);
    Route::post('update/{id}', [ProductController::class, 'update']);
    Route::delete('delete/{id}', [ProductController::class, 'delete']);
});
Route::group(['prefix' => 'store/import', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [StoreController::class, 'index']);
    Route::post('add', [StoreController::class, 'add']);
    Route::get('edit/{id}', [StoreController::class, 'edit']);
    Route::post('update/{id}', [StoreController::class, 'update']);
    Route::delete('delete/{id}', [StoreController::class, 'delete']);
});

Route::group(['prefix' => 'dashboard', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [DashboardController::class, 'index']); 
    Route::get('/service_bar', [DashboardController::class, 'get_service_bar']);
    Route::get('/re_exp_grap', [DashboardController::class, 'get_revenue_expanses2']);
    Route::post('/dash_cap', [DashboardController::class, 'dash_cap']);
    Route::get('/re_nosess', [DashboardController::class, 'get_repaire_notsucc']);
    Route::get('/carddash', [DashboardController::class, 'carddash']);
    Route::post('add', [DashboardController::class, 'add']);
    Route::get('edit/{id}', [DashboardController::class, 'edit']);
    Route::post('update/{id}', [DashboardController::class, 'update']);
    Route::delete('delete/{id}', [DashboardController::class, 'delete']);
});


Route::group(['prefix' => 'setting/roles', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [RolesController::class, 'index']);
    Route::post('add', [RolesController::class, 'add']);
    Route::post('sort', [RolesController::class, 'sort']);
    Route::get('edit/{id}', [RolesController::class, 'edit']);
    Route::get('listroles', [RolesController::class, 'listroles']);
    Route::get('abilities', [RolesController::class, 'abilities']);
    Route::post('update/{id}', [RolesController::class, 'update']);
    Route::post('setpermissions/', [RolesController::class, 'setpermissions']);
    Route::delete('delete/{id}', [RolesController::class, 'delete']);
});

Route::group(['prefix' => 'setting/roles_permissions', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [RolesPermissionsController::class, 'index']);
    Route::post('add', [RolesPermissionsController::class, 'add']);
    Route::get('edit/{id}', [RolesPermissionsController::class, 'edit']);
    Route::post('update/{id}', [RolesPermissionsController::class, 'update']);
    Route::delete('delete/{id}', [RolesPermissionsController::class, 'delete']);
}); 

Route::group(['prefix' => 'setting/general', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/users_log', [SettingController::class, 'users_log']);
    Route::post('add', [SettingController::class, 'add']);
    Route::get('edit/{id}', [SettingController::class, 'edit']);
    Route::post('update/{id}', [SettingController::class, 'update']);
    Route::delete('delete/{id}', [SettingController::class, 'delete']);
}); 

Route::group(['prefix' => 'service', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [ServiceController::class, 'index']);
    Route::post('add', [ServiceController::class, 'add']);
    Route::get('edit/{id}', [ServiceController::class, 'edit']);
    Route::post('update/{id}', [ServiceController::class, 'update']);
    Route::post('del_sv', [ServiceController::class, 'delete']);
}); 

Route::group(['prefix' => 'preorder', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [PreOrderController::class, 'index']);
    Route::post('add', [PreOrderController::class, 'add']);
    Route::post('import_to_bill', [PreOrderController::class, 'import_to_bill']);
    Route::get('edit/{id}', [PreOrderController::class, 'edit']);
    Route::post('update/{id}', [PreOrderController::class, 'update']);
    Route::delete('delete/{id}', [PreOrderController::class, 'delete']);
}); 

Route::group(['prefix' => 'preorder_item', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [PreOrderItemController::class, 'index']);
    Route::post('add', [PreOrderItemController::class, 'add']);
    Route::post('add_import', [PreOrderItemController::class, 'add_import']);
    Route::get('edit/{id}', [PreOrderItemController::class, 'edit']);
    Route::post('update/{id}', [PreOrderItemController::class, 'update']);
    Route::delete('delete/{id}', [PreOrderItemController::class, 'delete']);
}); 

Route::group(['prefix' => 'supplier', 'middleware' => 'auth:sanctum'], function () {
    Route::get('/', [SupplierController::class, 'index']);
    Route::post('add', [SupplierController::class, 'add']);
    Route::get('edit/{id}', [SupplierController::class, 'edit']);
    Route::post('update/{id}', [SupplierController::class, 'update']);
    Route::delete('delete/{id}', [SupplierController::class, 'delete']);
}); 

Route::group(['prefix' => 'create_report'], function () {
    Route::get('/', [ReportController::class, 'index']);
    Route::post('reportacc', [ReportController::class, 'ReportAcc']);
    Route::post('reportfinancial', [ReportController::class, 'ReportFinancial']);
    Route::post('reportfinancial_subsin', [ReportController::class, 'ReportFinancial_subsin']);
    Route::post('reportfinancial_neesin', [ReportController::class, 'ReportFinancial_neesin']);
    Route::post('report_store', [ReportController::class, 'ReportStore']);
    Route::get('report_store_export', [ReportController::class, 'ReportStoreExport']);
    Route::get('edit/{id}', [ReportController::class, 'edit']);
    Route::post('update/{id}', [ReportController::class, 'update']);
    Route::delete('delete/{id}', [ReportController::class, 'delete']);
}); 

Route::group(['prefix' => 'importtrn', 'middleware' => 'auth:sanctum'], function () {
    Route::post('/import', [TempTRNController::class, 'importtrndata']);
});


//Route::group(['prefix' => 'genpdf', 'middleware' => 'auth:sanctum'], function () {
    Route::get('genpdf', [GenPDFController::class, 'index']); 
    Route::get('printlabel/{id}', [PrintController::class, 'printlabel']);
    Route::get('printbill/{id}', [GenPDFController::class, 'printbill']);
    Route::get('printbill80/{id}', [GenPDFController::class, 'printbillmini']);
    Route::get('printquotation/{id}', [GenPDFController::class, 'printquotation']);
    Route::get('genpdf/create', [GenPDFController::class, 'create'])->name('genpdf');
    Route::get('rece/{id}', [RepaireController::class, 'rece']); 
    Route::get('customer_view/{id}', [RepaireController::class, 'customer_view']); 
    Route::get('print_product/list_Price', [PrintController::class, 'printlistpro']);
//});

/// Mobile API

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/sanctum/token', function (Request $request) {
    $request->validate([
        'email' => 'required|email',
        'password' => 'required',
        'device_name' => 'required',
    ]);
 
    $user = User::where('email', $request->email)->first();
 
    if (! $user || ! Hash::check($request->password, $user->password)) {
        throw ValidationException::withMessages([
            'email' => ['The provided credentials are incorrect.'],
        ]);
    }
 
    return $user->createToken($request->device_name)->plainTextToken;
});

Route::middleware('auth:sanctum')->get('/user/revoke', function (Request $request) {
    $user = $request->user();
    $user->tokens()->delete();
    return 'tokens are delete!';
});