<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link type="text/css" href="{{ asset('argon') }}/css/font_lao.css" rel="stylesheet">
    <script src="{{ asset('js') }}/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('js') }}/JsBarcode.all.min.js"></script>

    <style>
    .box {
        width: 880px;
        margin-right:0px;
    }

    div {
        vertical-align: top;
    }

    body,
    table,
    tr,
    td {
        background-color: #FFFFFF;
        color: #000000;
    }

    .table2 {

        border: 1px solid #000000;
        border-collapse: collapse;
        width: 100%;
        margin-bottom: 1rem;
        color: #000000;
    }
    table{
        position: relative;
    }


    .col-md-4{
        width: 33.33%;
    }
    .mt-4,
    .my-4 {
        margin-top: 1.5rem !important;
    }

    .p-5 {
        padding: 2rem !important;
    }

    div {
        vertical-align: top;
    }

    .row {
        display: flex;
        margin-right: -15px;
        margin-left: -15px;
        flex-wrap: wrap;
    }

    .text-red {
        color: red;
    }

    .text-left {
        text-align: left !important;
    }

    .text-right {
        text-align: right !important;
    }
    .text-botton {
      
        bottom: 180px;
    }

    .text-center {
        text-align: center !important;
    }



    .pt-4,
    .py-4 {
        padding-top: 1rem !important;
    }

    .col-md-12 {
        max-width: 100%;
        flex: 0 0 100%;
    }
    .b1{
        height: 140px;
        padding: 8px;
    }
    h1,h2,h3,h4,h5,h6{
        margin: 0;
    }
    .mt-2{
        margin-top:18px;
    }

 .table-fill{
  background: white;
  border: 2px solid #000;
  border-radius:3px;
  border-collapse: collapse;

}
.table-list{
    border-bottom: 1px dashed #000;
}
.tr{
    border-bottom: 1px dashed #000;
}
    </style>
</head>

<body>

    <div class="p-5">
        <div class="box">


            <div class="row">
                    <div class="col-md-12 text-center">
                         <h2>ໃບຮັບເຄື່ອງ ນຳລູກຄ້າ (ສຳລັບລູກຄ້າ)</h2>
                    </div>



                <table width="97%" class="table-fill">
                    <thead class="table-fill">
                        <th width="33%" class="table-fill">ອຸປະກອນ</th>
                        <th width="43%" class="table-fill">ລາຍການສ້ອມແປງເບື້ອງຕົ້ນ / ຂໍ້ມູນລູກຄ້າ</th>
                        <th width="23%" class="table-fill">ຕິດຕາມ</th>
                    </thead>
                    <tbody class="table-fill">
                        <tr class="table-fill" >
                        @foreach($repaire as $re)
                            <td valign="top" >
                            <div class="b1">
                                <h4>ປະເພດອຸປະກອນ:</h4>
                                <img src="{{ asset('images/repaire/'.$re->images) }}"  height="120" >
                            </div>
                            <div class="b1" >
                                <h4>ລາຍລະອຽດອຸປະກອນ:</h4>
                                {!!$re->detail!!}
                            </div>
                            <div class="b1" >
                               <h4>ອາການເປ່ເພ:</h4>
                               {!!$re->cause_detail!!}
                            </div>
                            @endforeach
                        </td>
                            <td class="b1 table-fill" valign="top" >
                            

                            @if(count($listrepaire)>0)
                                <table width="100%">

                                    @php($alltotal = 0)
                                    @php($total = 0)
                                    @php($num = 1)
                                    @foreach($listrepaire as $list)
                                    <tr >
                                        <td class="tr">{{$num++}}./ {{$list->name }} ({{$list->count }} x {{number_format($list->credit, 0, ',', '.')}})</td>
                                        <td class="tr text-right" width="80" >{{number_format($list->count*$list->credit, 0, ',', '.')}}</td>
                                                                                                    @php($total += $list->count*$list->credit)
                                    </tr>
                                    @endforeach
                                    <tr>
                                        <td class="tr text-right" ><b>ລວມທັງໝົດ:</b></td>
                                        <td class="tr text-right"  width="80" >{{number_format($total, 0, ',', '.')}}</td>
                                    </tr>

                                </table>
                                @endif
                                <div>
                                   <b> ໝາຍເຫດ: </b> ລາຄາສ້ອມແປງ ອາດມີການປ່ຽນແປງ ຫຼັງຈາກກວດເຊັກອຸປະກອນຕົວຈິງ, ເມື່ອສ້ອມແປງສຳເລັດແລ້ວ ທີມງານຈະແຈ້ງໃຫ້ລູກຄ້າ ເພື່ອເຂົ້າມາຮັບເຄື່ອງ ແລະຊຳລ່ະຄ່າບໍລິການ ພາຍໃນ 2 ອາທິດ.
                                </div>
                                
                            </div>
                                <div class="mt-2">
                                @foreach($repaire as $re)
                                    <b>ລູກຄ້າ:</b> {{$re->customer_name}}<br>
                                    <b>ທີ່ຢູ່:</b> {{$re->customer_address}} <br>
                                    <b>ເບີໂທ:</b> {{$re->customer_tel}} <br>
                                @endforeach
                                </div>
                            
                            <td class="b1" valign="top" class="table-fill">
                                <div class="text-right">
                                    ເລກທີ່: {{$reid}} <br>
                                     ວັນທີ່: {{$date}}<br>
                                     ເວລາ: {{$time}}
                                </div>
                           <hr> 
                            <div class="code">

                            {!! QrCode::size(130)->generate(Request::root().'/api/customer_view/'.$reid) !!}
                            <svg id="barcode" co="{{$reid}}"></svg>


                            </div>


                                <div class="text-botton">
                                   <b> ພະນັກງານຮັບເຄື່ອງ: </b> </br>
                                   {{$re->sex}} {{$re->name}} {{$re->last_name}}<br>
                                   (ເບີໂທ: {{$re->tel}})
                                 
                                    
                                </div>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <th colspan="3" class="text-center">ຮ້ານ ສອນໄອທີຄອມພິວເຕີ້ ຕັ້ງຢູ່: ບ້ານ ໜອງແມງດາ ເມືອງໄຊ ແຂວງອຸດົມໄຊ ໂທ/Whatsapp 29113568, 58086456<br>FaceBook: Soneitcomputer, YouTube: Soneitcomputer</th>
                    </tfoot>
                </table>
            </div>
            <br>
    ===========================================================================================
    <br>
            <div class="row">
            <div class="col-md-12 text-center">
                         <h2>ໃບຮັບເຄື່ອງ ນຳລູກຄ້າ (ສຳລັບພະນັກງານ)</h2>
                    </div>
                    <table width="97%" class="table-fill">
                    <thead class="table-fill">
                        <th width="33%" class="table-fill">ອຸປະກອນ</th>
                        <th width="43%" class="table-fill">ລາຍການສ້ອມແປງ / ຂໍ້ມູນລູກຄ້າ</th>
                        <th width="23%" class="table-fill">ຕິດຕາມ</th>
                    </thead>
                    <tbody class="table-fill">
                        <tr class="table-fill" >
                        @foreach($repaire as $re)
                            <td valign="top" >
                            <div class="b1">
                                <h4>ປະເພດອຸປະກອນ:</h4>
                                <img src="{{ asset('images/repaire/'.$re->images) }}"  height="120" >
                            </div>
                            <div class="b1" >
                                <h4>ລາຍລະອຽດອຸປະກອນ:</h4>
                                {!!$re->detail!!}
                            </div>
                            <div class="b1" >
                               <h4>ອາການເປ່ເພ:</h4>
                               {!!$re->cause_detail!!}
                            </div>
                            @endforeach
                        </td>
                            <td class="b1 table-fill" valign="top" >
                            @if(count($listrepaire)>0)
                                <table width="100%">

                                    @php($alltotal = 0)
                                    @php($total = 0)
                                    @php($num = 1)
                                    @foreach($listrepaire as $list)
                                    <tr >
                                        <td class="tr">{{$num++}}./ {{$list->name }} ({{$list->count }} x {{number_format($list->credit, 0, ',', '.')}})</td>
                                        <td class="tr text-right" width="80" >{{number_format($list->count*$list->credit, 0, ',', '.')}}</td>
                                                                                                    @php($total += $list->count*$list->credit)
                                    </tr>
                                    @endforeach
                                    <tr>
                                        <td class="tr text-right" ><b>ລວມທັງໝົດ:</b></td>
                                        <td class="tr text-right"  width="80" >{{number_format($total, 0, ',', '.')}}</td>
                                    </tr>

                                </table>
                                @endif
                                <div>
                                <b> ໝາຍເຫດ: </b> ລາຄາສ້ອມແປງ ອາດມີການປ່ຽນແປງ ຫຼັງຈາກກວດເຊັກອຸປະກອນຕົວຈິງ, ເມື່ອສ້ອມແປງສຳເລັດແລ້ວ ທີມງານຈະແຈ້ງໃຫ້ລູກຄ້າ ເພື່ອເຂົ້າມາຮັບເຄື່ອງ ແລະຊຳລ່ະຄ່າບໍລິການ ພາຍໃນ 2 ອາທິດ.
                                </div>
                                <div class="mt-2">
                                @foreach($repaire as $re)
                                    <b>ລູກຄ້າ:</b> {{$re->customer_name}}<br>
                                    <b>ທີ່ຢູ່:</b> {{$re->customer_address}} <br>
                                    <b>ເບີໂທ:</b> {{$re->customer_tel}} <br>
                                @endforeach
                                </div>
                            </td>
                            <td class="b1" valign="top" class="table-fill">
                            <div class="text-right">
                                    ເລກທີ່: {{$reid}} <br>
                                     ວັນທີ່: {{$date}}<br>
                                     ເວລາ: {{$time}}
                                </div>
                           <hr>
                            <div class="code">

                            {!! QrCode::size(130)->generate(Request::root().'/api/customer_view/'.$reid) !!}
                            <svg id="barcode" co="{{$reid}}"></svg>
                            </div>


                                <div class="text-botton">
                                   <b> ພະນັກງານຮັບເຄື່ອງ: </b> <br>
                                   {{$re->sex}} {{$re->name}} {{$re->last_name}}<br>
                                   (ເບີໂທ: {{$re->tel}})
                                </div>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <th colspan="3" class="text-center">ຮ້ານ ສອນໄອທີຄອມພິວເຕີ້ ຕັ້ງຢູ່: ບ້ານ ໜອງແມງດາ ເມືອງໄຊ ແຂວງອຸດົມໄຊ ໂທ/Whatsapp 020 29113568, 58086456<br>FaceBook: Soneitcomputer, YouTube: Soneitcomputer</th>
                    </tfoot>
                </table>
            </div>


        </div>
    </div>
    <script>
        //JsBarcode("#barcode", "Hi world!",width: 4, height: 40,);
        var code = $("#barcode").attr('co');
        JsBarcode("#barcode", code,{ width: 1, height: 40});
          window.print();
          setTimeout('window.close()', 6210);

    </script>
</body>

</html>