<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <link href="{{ asset('argon') }}/vendor/nucleo/css/nucleo.css" rel="stylesheet">
    <link type="text/css" href="{{ asset('argon') }}/css/font_lao.css" rel="stylesheet">
    <script src="{{ asset('js') }}/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('js') }}/JsBarcode.all.min.js"></script>
    <link href="{{ asset('argon') }}/vendor/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet">
    <style>
    .box {
        width: 300px;
    }

    div {
        vertical-align: top;
    }

    body,
    table,
    tr,
    td {
        font-size:12px;
        background-color: #FFFFFF;
        color: #000000;
    }

    .table2 {

        border: 1px solid #000000;
        border-collapse: collapse;
        width: 100%;
        margin-bottom: 1rem;
        color: #000000;
    }

    .table2 thead,
    .table2 tr,
    .table2 td,
    .table2 th {
        padding: 2px;
        border: 0px;
        border-collapse: collapse;
    }

    .mt-4,
    .my-4 {
        margin-top: 1.5rem !important;
    }

    .p-5 {
        padding: 3rem !important;
    }

    div {
        vertical-align: top;
    }

    .row {
        display: flex;
        margin-right: -15px;
        margin-left: -15px;
        flex-wrap: wrap;
    }

    .text-red {
        color: red;
    }

    .text-left {
        text-align: left !important;
    }

    .text-right {
        text-align: right !important;
    }

    .text-center {
        text-align: center !important;
    }

    table,
    td,
    table {
        white-space: normal;
    }
.head{
    font-size: 18px;
}
    .pt-4,
    .py-4 {
        padding-top: 1rem !important;
    }

    .col-md-12 {
        max-width: 100%;
        flex: 0 0 100%;
    }
    .nameBill{
        padding-top: 10px;
        padding-bottom: 10px;
    }
    .customer{
        font-size:14px;
        text-align: left;
    }
    .table{
        padding: 2px;
        width: 100%;
    }
    .table tr td{
        border-bottom: 1px dashed;
    }
    </style>
</head>

<body >

    <div class="">
        <div class="box">
            <div class="text-center"><img src="{{asset('images/soneitcomputer_logo_back.jpg')}}" width="230"><br>
           <span class="head"><b>ຮ້ານ: ສອນໄອທີຄອມພິວເຕີ້</b></span> <br>
           <div style="position: relative; height: 35px;" >
                <div class="text-left" style="position: absolute; font-size:12px;"><b> ພະນັກງານຂາຍ: </b> <br>{{ Auth::user()->sex }} {{ Auth::user()->name }} {{ Auth::user()->last_name }}</div>
                <div class="text-right" style="position: absolute; font-size:12px; right: 0px;">ວັນທິ່: {{$date}} <br>ເວລາ: {{$time}}</div>
            </div>
           <div class="customer">
           @foreach($Bills as $b)


                        @if($b['customer_id'] =='0' && $b['office_id'] =='0' && $b['customer_name'] =='')
                        <b>ລູກຄ້າ:</b> ບຸກຄົນທົ່ວໄປ.
                        @elseif($b['customer_type'] =='true')
                            <b>ລູກຄ້າ:</b> {{$b->customer_name}} <br>
                            <b>ເບີໂທ:</b> 020 {{$b->customer_tel}} <br>
                            <b>ທີ່ຢູ່:</b> {{$b->customer_address}}
                        @else
                            <b>ລູກຄ້າ:</b> {{$b->customer_name}} <br>
                            <b>ເບີໂທ:</b> {{$b->customer_tel}} <br>
                            <b>ທີ່ຢູ່:</b> {{$b->customer_address}}
                            @endif


                    @endforeach
           </div>
           <div style="position: relative; height: 28px; border: 1px dashed; background-color: #0022;">
                <span style="position: absolute; left:5px">ລາຍການສິນຄ້າ/ບໍລິການ</span> <span style="position: absolute; right:10px">ລວມ(ກີບ)</span>
            <div >

            </div>
            </div>
           <table class="table">
           @php($alltotal = 0)
            @php($total = 0)
           @foreach($BillsList as $bl)
               <tr>
                   <td class="text-left"><b>{{$bl->name}}</b></td>
                   <td width="90" class="text-right">({{$bl->count}} x {{number_format($bl->credit, 0, ',', '.')}})</td>
                   <td width="60" class="text-right">{{ number_format($bl->count*$bl->credit, 0, ',', '.')}}</td>
                   @php($total += $bl->count*$bl->credit)
               </tr>
            @endforeach
           </table>
           @php($alltotal=$total)
            <table style="width:100%">
                <tr>
                    <td>
                    <div style="position: relative; font-size:12px;" class="text-right">
                    @foreach($Bills as $b)
                            @if($b->discut || $b->tax > 0)
                           <b> ລວມທັງໝົດ: {{number_format($alltotal, 0, ',', '.')}} </b> <br>
                            @endif
                            @if($b->discut)
                                ສ່ວນຫຼຸດ: {{number_format($b->discut, 0, ',', '.')}} <br>
                                @php($alltotal -=$b->discut)
                            @endif

                            @if($b->tax > 0)
                                <!-- @php($tax = ($alltotal*(int)$b->tax/100) ) -->
                                ອາກອນມູນຄ່າເພີ່ມ(7%): {{number_format($b->tax, 0, ',', '.')}} 
                                @php($alltotal+=$b->tax)
                            @endif
                    @endforeach
                    </div>
                       <div style="position: relative; height: 28px; padding-top: 10px; ">
                       <strong>
                       <span style="position: absolute; left:5px">ລວມເງິນທີ່ຕ້ອງຊຳລະ:</span> <span style="position: absolute; right:5px">{{number_format($alltotal, 0, ',', '.')}}  ກີບ</span>
                       </strong>


                        <div >
                    </td>
                </tr>
            </table>

            <hr style="border-bottom: 1px dashed;">
            <div style="position: relative; font-size:14px;" >
                ຈຳໜ່າຍ-ສ້ອມແປງ ຄອມພິວເຕີ້, ອຸປະກອນໄອທີ <br> ກ້ອງວົງຈອນປິດ ແລະ ຮັບພັດທະນາໂປຼແກມ, ແອ໊ບມືຖື
              <br>
           <b>ໂທ/Whatsapp: 020 29113568, 58086456<b><br>
           </div>
           <div class="code">
                            <svg id="barcode" co="{{$Bill_num}}"></svg>
                            </div>
            </div>
        </div>
    </div>

    <script>
      $(document).ready(function(){
        var code = $("#barcode").attr('co');
        JsBarcode("#barcode", code,{ width: 1.2, height: 30});
            window.print();
            setTimeout('window.close()', 4210);
        });
    </script>
</body>

</html>