import { createWebHistory, createRouter } from "vue-router";
import axios from "axios";

import Home from "../pages/Home";
import About from "../pages/About";
import Register from "../pages/Register";
import Login from "../pages/Login";
import Dashboard from "../pages/Dashboard";

import Books from "../components/Books";
import AddBook from "../components/AddBook";
import EditBook from "../components/EditBook";

import Users from "../pages/users/Users";
import AddUser from "../pages/users/Add_user";
import EditUser from "../pages/users/Edit_user";

import Customer from "../pages/customer/Customer";
import AddCustomer from "../pages/customer/AddCustomer";
import EditCustomer from "../pages/customer/EditCustomer";

import PreOrder from "../pages/service/PreOrder";
import EditPreOrder from "../pages/service/EditPreOrder.vue";
import CheckPreOrder from "../pages/service/CheckPreOrder.vue";
import AddPreOrder from "../pages/service/AddPreOrder";
import Repaire from "../pages/service/Repaire";
import AddRepaire from "../pages/service/AddRepaire";
import EditRepaire from "../pages/service/EditRepaire";
import ListNoStore from "../pages/service/ListOrderNoStore.vue";

import General from "../pages/setting/General";
import UsersLog from "../pages/setting/UsersLog.vue";
import Transection from "../pages/transection/Transection";

import Bills from "../pages/bills/Bills";
import Quotaation from "../pages/bills/Quotation";
import AddBills from "../pages/bills/AddBills";
import EditBills from "../pages/bills/EditBills";

import AddQuotation from "../pages/bills/AddQuotation";
import EditQuotation from "../pages/bills/EditQuotation";

import Acc from "../pages/acc/Acc";
import AccTnMg from "../pages/acc/AccTnMg";

import AddStore from "../pages/store/AddStore";
import Store from "../pages/store/Store";
import StoreSetting from "../pages/store/StoreSetting"; //
import BrandUnit from "../pages/store/BrandUnit";
import Product from "../pages/store/Product";

import POS from "../pages/pos/Pos.vue";
import CDispaly from "../pages/customer/CustomerDisplay";
import ImportData from "../pages/transection/ImportTRN";
import NotFound from "../pages/NotFound";
import PermissionSetting from "../pages/setting/PermissionsSetting.vue";

import Supplier from "../pages/service/Supplier.vue";

import ReportAccounting from "../pages/report/Accounting.vue";
import ReportSellService from "../pages/report/SellService.vue";
import ReportStore from "../pages/report/Store.vue";
import ReportFinancial from "../pages/report/Financial.vue";
import ReportCustomerLog from "../pages/report/StoreCustomer.vue";

export const routes = [
    {
        name: "home",
        path: "/",
        component: Login,
    },
    {
        name: "about",
        path: "/about",
        component: About,
    },
    {
        name: "register",
        path: "/register",
        component: Register,
    },
    {
        name: "login",
        path: "/login",
        component: Login,
    },
    {
        name: "dashboard",
        path: "/dashboard",
        component: Dashboard,
    },
    {
        name: "books",
        path: "/books",
        component: Books,
    },
    {
        name: "addbook",
        path: "/books/add",
        component: AddBook,
    },
    {
        name: "editbook",
        path: "/books/edit/:id",
        component: EditBook,
    },
    {
        name: "users",
        path: "/users",
        component: Users,
    },
    {
        name: "add-users",
        path: "/users/add",
        component: AddUser,
    },
    {
        name: "editusers",
        path: "/users/edit/:id",
        component: EditUser,
    },
    {
        name: "customer",
        path: "/customer",
        component: Customer,
    },
    {
        name: "addcustomer",
        path: "/customer/add",
        component: AddCustomer,
    },
    {
        name: "editcustomer",
        path: "/customer/edit/:id",
        component: EditCustomer,
    },
    {
        name: "preorder",
        path: "/service/preorder",
        component: PreOrder,
    },
    {
        name: "add-preorder",
        path: "/service/preorder/add",
        component: AddPreOrder,
    },
    {
        name: "edit-preorder",
        path: "/service/preorder/edit/:id",
        component: EditPreOrder, 
    },
    {
        name: "check-preorder",
        path: "/service/preorder/check_order/:id",
        component: CheckPreOrder,
    },
    {
        name: "list-no-store",
        path: "/service/preorder-nostore",
        component: ListNoStore,
    },
    {
        name: "repaire",
        path: "/service/repaire",
        component: Repaire,
    },
    {
        name: "add-repaire",
        path: "/service/repaire/add",
        component: AddRepaire,
    },
    {
        name: "edit-repaire",
        path: "/service/repaire/edit/:id",
        component: EditRepaire,
    },
    {
        name: "setting-general",
        path: "/setting/general",
        component: General,
    },
    {
        name: "transection",
        path: "/transection",
        component: Transection,
    },
    {
        name: "bills",
        path: "/bills",
        component: Bills,
    },
    {
        name: "quotation",
        path: "/quotation",
        component: Quotaation,
    },
    {
        name: "editbills",
        path: "/bills/edit/:id",
        component: EditBills,
    },
    {
        name: "addbills",
        path: "/bills/add",
        component: AddBills,
    },
    {
        name: "addquotation",
        path: "/bills/add_quotation",
        component: AddQuotation,
    },
    {
        name: "editquotation",
        path: "/quotation/edit/:id",
        component: EditQuotation,
    },
    {
        name: "checkauth",
        path: "/users/checkauth",
    },
    {
        name: "allacc",
        path: "/allacc",
        component: Acc,
    },
    {
        name: "acctnmg",
        path: "/acc_tn_mg",
        component: AccTnMg,
    },
    {
        name: "store",
        path: "/store",
        component: Store,
    },
    {
        name: "product",
        path: "/store/product",
        component: Product,
    },
    {
        name: "addstore",
        path: "/store/add",
        component: AddStore,
    },
    {
        name: "setting-session",
        path: "/store/setting_category",
        component: StoreSetting,
    },
    {
        name: "brand_unit",
        path: "/store/brand_unit",
        component: BrandUnit,
    },

    {
        name: "pos",
        path: "/pos",
        component: POS,
    },
    {
        name: "customerdisplay",
        path: "/customerdisplay",
        component: CDispaly,
    },
    {
        name: "importdata",
        path: "/importdata",
        component: ImportData,
    },
    {
        name: "permisttionssetting",
        path: "/setting/permissions",
        component: PermissionSetting,
    },
    {
        name: "users_log",
        path: "/setting/users_log",
        component: UsersLog,
    },
    {
        name: "report-accounting",
        path: "/report/accounting",
        component: ReportAccounting,
    },
    {
        name: "report-sell-service",
        path: "/report/sell-service",
        component: ReportSellService,
    },
    {
        name: "report-financial",
        path: "/report/financial",
        component: ReportFinancial,
    },
    {
        name: "report-store",
        path: "/report/store",
        component: ReportStore,
    },
    {
        name: "report-customer-log",
        path: "/report/customer_log",
        component: ReportCustomerLog,
    },
    {
        name: "supplier",
        path: "/supplier",
        component: Supplier,
    },
    {
        path: "/:catchAll(.*)",
        component: NotFound,
    },
    {
        name: "nopage",
        path: "/404",
        component: NotFound,
    },
];

//console.log(window.Laravel.isLoggedin)

const router = createRouter({
    history: createWebHistory(),
    routes: routes,
    scrollBehavior() {
        window.scrollTo(0, 0);
    },
});

router.beforeEach((to, from, next) => {
    //   console.log(to)
    //console.log(window.Laravel.isLoggedin)

    if (!window.Laravel.isLoggedin) {
        // window.location.href = "/";
    }
    next();
});

export default router;
