import { createApp } from 'vue'

require('./bootstrap')
import App from './App.vue'
import axios from 'axios'
import router from './router'
import store from './store/index'
//import './insex.css'

//import { abilitiesPlugin } from '@casl/vue'

//import Select2 from 'vue3-select2-component';
//import VueOffline from 'vue-offline'


import SlideMenu from "./components/SlideMenu.vue"
import VuePagination from './components/Pagination.vue'
import CardAccTL from './components/CardAccTL.vue'
import CardDash from './components/CardDash.vue'
import ProgressReapire from './components/CardProgressRepaire.vue'
import Billist from './components/BilllistComponent.vue'
import UploadImageOne from './components/UploadImage_one.vue'
import UploadImageOneProduct from './components/UploadImage_one_product.vue'
import Report from './components/ReportComponent.vue'
import GetCustomer from './components/GetCustomerComponent.vue'
import Supplier from './components/SupplierComponent.vue'
import TranPrice from './components/TranPriceComponent.vue'
import lastsellpro from './components/LastSellPro.vue'


import Vue3SimpleHtml2pdf from "vue3-simple-html2pdf";


import VueFlatPickr from 'vue-flatpickr-component';
import 'flatpickr/dist/flatpickr.css';
import Cleave from 'vue-cleave-component';

//import VueCurrencyInput from 'vue-currency-input' //vue-currency-input
import VueSweetalert2 from 'vue-sweetalert2'
import 'sweetalert2/dist/sweetalert2.min.css'

import { QuillEditor } from '@vueup/vue-quill'
import '@vueup/vue-quill/dist/vue-quill.snow.css'

import VueChartkick from 'vue-chartkick'
import 'chartkick/chart.js'


//import VueHtml2pdf from 'vue3-html2pdf'
import VueProgressBar from "@aacassandra/vue3-progressbar"
import Notifications from "vue3-vt-notifications"
import Popper from "vue3-popper"
import "./theme_popper.css"

import VueEasyLightbox from "vue-easy-lightbox"

import {
    ContentLoader,
    FacebookLoader,
    CodeLoader,
    BulletListLoader,
    InstagramLoader,
    ListLoader,
  } from 'vue-content-loader'



const options = {
    color: "#bffaf3",
    failedColor: "#874b4b",
    thickness: "5px",
    transition: {
        speed: "0.2s",
        opacity: "0.6s",
        termination: 300,
    },
    autoRevert: true,
    location: "top",
    inverse: false,
}

const app = createApp(App)
app.use(VueEasyLightbox);
app.config.globalProperties.$axios = axios;
app.use(store);
app.use(router);
app.component("Popper", Popper);
app.use(VueProgressBar, options); 
app.component("slide-menu", SlideMenu);
app.component("vuePagination", VuePagination);
app.component("cardacctl", CardAccTL);
app.component("carddash", CardDash);
app.component("progressreapire", ProgressReapire);
app.component("bailllist", Billist);
app.component("uploadimgone", UploadImageOne);
app.component("uploadimgoneproduct", UploadImageOneProduct);
app.component("report", Report);
app.component("getcustomer", GetCustomer);
app.component("supplier", Supplier);
app.component("tranprice", TranPrice);
app.component("content-loader", ContentLoader);
app.component("facebook-loader", FacebookLoader);
app.component("code-loader", CodeLoader);
app.component("bullet-loader", BulletListLoader);
app.component("instagram-loader", InstagramLoader);
app.component("list-loader", ListLoader); 
app.component("lastsellpro", lastsellpro); 
app.use(VueSweetalert2);
app.use(Vue3SimpleHtml2pdf);
//app.component('select2', Select2) 
app.use(VueFlatPickr);

app.use(Cleave);

app.use(VueChartkick)
//app.use(VueOffline)


app.component('QuillEditor', QuillEditor);
app.use(Notifications);
//app.use("vue-html2pdf", VueHtml2pdf);

app.config.globalProperties.$base_url = window.location.host;
app.mount('#app');