<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePreOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pre_order_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('preorder_id');
            $table->string('product_id')->nullable();
            $table->string('amount');
            $table->string('amount_instore')->nullable();
            $table->string('item_name');
            $table->string('item_images')->nullable();
            $table->bigInteger('price_buy')->nullable();
            $table->string('price_sell')->nullable();
            $table->longText('detail')->nullable();
            $table->string('item_tran_status')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pre_order_items');
    }
}
