<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePreOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pre_orders', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('preorder_id');
            $table->string('supplier_id');
            $table->string('billnum_id')->nullable();
            $table->string('customer_id');
            $table->string('customer_name')->nullable();
            $table->string('customer_tel')->nullable();
            $table->string('customer_address')->nullable();
            $table->string('customer_type')->nullable();
            $table->longText('tran_price')->nullable();
            $table->bigInteger('amount')->nullable();
            $table->bigInteger('rate')->nullable();
            $table->string('transport_day')->nullable();
            $table->string('transport_day_com')->nullable();
            $table->longText('transport_status')->nullable();
            $table->longText('detail')->nullable();
            $table->string('user_id')->nullable();
            $table->string('pay_status')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pre_orders');
    }
}
