<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('service_id');
            $table->string('service_name');
            $table->string('service_type')->nullable();
            $table->string('service_barcode')->nullable();
            $table->longText('service_images')->nullable();
            $table->longText('service_detail')->nullable();
            $table->bigInteger('price_buy')->nullable();
            $table->bigInteger('price_sell')->nullable();
            $table->string('link_buy')->nullable();
            $table->longText('images_buy')->nullable();
            $table->longText('detail_buy')->nullable();
            $table->bigInteger('count')->nullable();
            $table->bigInteger('user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('services');
    }
}
