<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBarcodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('barcodes', function (Blueprint $table) {
            $table->bigIncrements('id'); 
            $table->string('option_id')->nullable();
            $table->string('pbc_id');
            $table->string('barcode');
            $table->string('product_id');
            $table->string('price_type');
            $table->bigInteger('price');
            $table->bigInteger('price_pro')->nullable();
            $table->string('unit');
            $table->string('default');
            $table->string('default_pro');
            $table->bigInteger('sell')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('barcodes');
    }
}
