<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stores', function (Blueprint $table) { 
            $table->bigIncrements('id');
            $table->string('store_id');
            $table->string('product_id');
            $table->string('preoder_id')->nullable();
            $table->string('st_trn_id')->nullable();
            $table->string('st_cashtype')->nullable();
            $table->bigInteger('st_import_amount');
            $table->bigInteger('st_price_buy')->nullable();
            $table->longText('st_price_sell')->nullable();
            $table->bigInteger('st_instore_sell')->nullable();
            $table->bigInteger('st_import_pack_amount')->nullable();
            $table->bigInteger('st_user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stores');
    }
}
