<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('product_id');
            $table->string('product_name');
            $table->string('product_brand')->nullable();
            $table->string('product_model')->nullable();
            $table->longText('product_images')->nullable();
            $table->longText('product_detail')->nullable();
            $table->bigInteger('session_id');
            $table->bigInteger('category_id')->nullable();
            $table->bigInteger('sub_category_id')->nullable();
            $table->bigInteger('product_price_buy')->nullable();
            $table->longText('product_price_sell')->nullable();
            $table->longText('product_barcode')->nullable();
            $table->longText('product_date_expiry')->nullable();
            $table->bigInteger('in_store')->nullable();
            $table->bigInteger('in_store_pack')->nullable();
            $table->string('product_unit_type')->nullable();
            $table->string('product_unit')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
