<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccTRNSTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_t_r_n_s', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('trn_id');
            $table->string('bill_list_id')->nullable();
            $table->string('barcode')->nullable();
            $table->string('trn_type');
            $table->string('bill_id')->nullable();
            $table->string('acc_trn_detail');
            $table->string('amount');
            $table->string('count')->nullable();
            $table->string('rate');
            $table->string('sum');
            $table->string('dr');
            $table->string('cr');
            $table->bigInteger('user_id');
            $table->string('work_status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_t_r_n_s');
    }
}
