<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateListRepaireItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('list_repaire_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('renum_id');
            $table->string('product_id')->nullable();
            $table->string('bill_type')->nullable();
            $table->string('bill_list_id')->nullable();
            $table->string('barcode')->nullable();
            $table->string('name')->nullable();
            $table->bigInteger('credit')->nullable();
            $table->bigInteger('count')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('list_repaire_items');
    }
}
