<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotation_lists', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('quonum_id');
            $table->string('product_id')->nullable();
            $table->string('quo_type')->nullable();
            $table->string('bill_list_id')->nullable();
            $table->string('barcode')->nullable();
            $table->bigInteger('credit')->nullable();
            $table->bigInteger('dedit')->nullable();
            $table->bigInteger('count')->nullable();
            $table->string('name')->nullable();
            $table->string('detail')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotation_lists');
    }
}
