<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('quonum_id')->nullable();
            $table->string('billnum_id')->nullable();
            $table->bigInteger('customer_id')->nullable();
            $table->string('customer_name')->nullable();
            $table->string('customer_tel')->nullable();
            $table->string('customer_address')->nullable();
            $table->string('customer_detail')->nullable();
            $table->bigInteger('office_id')->nullable();
            $table->bigInteger('user_id')->nullable();
            $table->string('status')->nullable();
            $table->string('customer_type')->nullable();
            $table->string('signed')->nullable();
            $table->bigInteger('all_count')->nullable();
            $table->bigInteger('all_credit')->nullable();
            $table->bigInteger('tax')->nullable();
            $table->bigInteger('discut')->nullable();
            $table->longText('ListBilldata')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotations');
    }
}
