<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBillsListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bills_lists', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('billnum_id');
            $table->string('bill_list_id')->nullable();
            $table->string('bill_type')->nullable();
            $table->string('product_id')->nullable();
            $table->string('barcode')->nullable();
            $table->bigInteger('credit')->nullable();
            $table->bigInteger('dedit')->nullable();
            $table->bigInteger('count')->nullable();
            $table->string('name')->nullable();
            $table->string('detail')->nullable();
            $table->string('work_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bills_lists');
    }
}
