<?php

use Illuminate\Support\Facades\Auth;
use App\Models\Roles;
use App\Models\Log;

if(!function_exists('user_email')){
    function user_email()
    {
        $user = Auth::user();
        return $user->email;
    }
}

if(!function_exists('check_roles')){
    function check_roles($permission)
    {
        $user_roles =  Auth::user()->permission;
        $user_permissions = Roles::find($user_roles);
        if(in_array($permission,json_decode($user_permissions->permissions))){
            return true;
        } else {
            return false;
        }
    }
}

if(!function_exists('save_logs')){
    function save_logs($logs, $status)
    {
        $user_id =  Auth::user()->id;
        $save_log = new Log([ 'user_id' => $user_id, 'detail' => $logs, 'status' => $status ]);
        $save_log->save();
    }
}