<?php

namespace App\Http\Controllers\STORE;

use App\Http\Controllers\Controller;
use App\Models\STORE\Unit;
use Illuminate\Http\Request;

class UnitController extends Controller
{
    //
    public function index()
    {

        if(check_roles('setting_unitband_access')){


        $all = \Request::get('all');
        if($all=='all'){
            $brand = Unit::orderBy('created_at', 'desc')
            ->get();
            return $brand;
        } else {
            $brand = Unit::orderBy('created_at', 'desc')
            ->paginate(10)
            ->toArray();
            return array_reverse($brand);
        }
        
         } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
        //return response()->json($brand);
    }

    public function add(Request $request)
    {

        if(check_roles('setting_unit_add')){
            // start permissions

        try {
        $unit = new Unit();
            $unit->unit_name = $request->unit_name;
            $unit->unit_one = $request->unit_one;
            $unit->unit_to = $request->unit_to;
            $unit->save();
            $success = true;

            $unit = Unit::orderBy('created_at', 'desc')
            ->paginate(10)
            ->toArray();
           $que = array_reverse($unit);

           // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນຊື່ Unit: '.$request->unit_name,'success');

            $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ເພີ່ມຂໍ້ມູນຊື່ Unit error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que

        ];
        return response()->json($response);

         /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('setting_unit_edit')){
            // start permissions

        try {
            $unit = Unit::find($id);
  
                $unit->update($request->all([
                    $unit->unit_name = $request->unit_name,
                    $unit->unit_one = $request->unit_one,
                    $unit->unit_to = $request->unit_to,
                ]));
            

            $unit = Unit::orderBy('created_at', 'desc')
            ->paginate(10)
            ->toArray();
            $que = array_reverse($unit);

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຂໍ້ມູນຊື່ Unit: '.$request->unit_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ອັບເດດຂໍ້ມູນຊື່ Unit error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function delete($id)
    {

        if(check_roles('setting_unit_remove')){
            // start permissions

        $brand = Unit::find($id);
        $brand_old = Unit::find($id);
        
        $brand->delete();

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ລຶບຂໍ້ມູນຊື່ Unit: '.$brand_old['unit_name'],'success');

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

         /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}
