<?php

namespace App\Http\Controllers\STORE;

use App\Http\Controllers\Controller;
use App\Models\STORE\Store;
use App\Models\STORE\Product;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use App\Models\ACC\AccTRN;
use Illuminate\Http\Request;

class StoreController extends Controller
{
    //
    public function index()
    {
        //$type = \Request::get('type');


        if(check_roles('store_import_access')){
            // start permissions

            $store = Store::leftJoin('users', 'users.id', '=', 'stores.st_user_id')
            ->leftJoin('products', 'products.product_id', '=', 'stores.product_id')
            ->orderBy('stores.created_at', 'desc')
            ->where('stores.st_import_amount','!=','0')
            ->paginate(10,array('stores.*', 'users.user_name','users.sex','users.name','users.last_name','products.product_images','products.product_name','products.product_barcode'))
            ->toArray();
            return array_reverse($store);

            /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function add(Request $request)
    {
        if(check_roles('store_import_add')){
        // start permissions
        try {
            /// update product
            $product = Product::where('product_id',$request->IDPro);
            $product_que = Product::where('product_id',$request->IDPro)->get();
            //return $product_que[0]->product_name;
            $product->update([
               // 'product_name' => $request->product_name,
               // 'product_brand' => $request->product_brand,
               // 'product_model' => $request->product_model,
                'in_store' => (int)$product_que[0]->in_store + (int)$request->ImportInstore,
                'in_store_pack' => (int)$product_que[0]->in_store_pack + ((int)$request->ImportInstore*(int)$product_que[0]->product_unit_type),
                //'product_images' => json_encode($request->product_images),
                'product_detail' => $request->product_detail,
                'product_date_expiry' => $request->date_expiry,

                //'session_id' => $request->session_id,
                //'category_id' => $request->category_id,
                //'sub_category_id' => $request->sub_category_id,
               // 'product_price_buy' => $request->product_price_buy,
                //'product_price_sell' => json_encode($request->product_price_sell)
            ]);

            /// add transection
            $trn_org = AccTRN::orderBy('created_at', 'desc')->take(1)->get();
            $number = $trn_org[0]['trn_id'];
            
            if($number){
                $number1 = str_replace("INC","",$number);
                $number2 = str_replace("EXP","",$number1);
                $number3 = str_replace("CAP","",$number2);
                $number4 = str_replace("CIN","",$number3);
                $number5 = str_replace("EXC","",$number4);
                $number = (int)$number5+1;
                $length = 8;
                $number = substr(str_repeat(0, $length).$number, - $length);
               
            } else {
                $number_c = 1;
                $number = substr(str_repeat(0, $length).$number_c, - $length);
            }
            if($request->acc_type=='income'){ $tnum = 'INC'; }
            elseif($request->acc_type=='expense'){ $tnum = 'EXP'; }
            elseif($request->acc_type=='capital'){ $tnum = 'CAP'; }
            elseif($request->acc_type=='cincome'){ $tnum = 'CIN'; }

                if($request->CashType=='true')
                { $dr = '307'; $cr = '571'; }
                else
                { $dr = '307'; $cr = '551'; }

            $accs = new AccTRN([
                'trn_id' => $tnum.$number,
                'trn_type' => $request->acc_type,
                'acc_trn_detail' => 'ນຳເຂົ້າສິນຄ້າ: '.$request->product_name,
                'amount' => $request->product_price_buy,
                'count' => $request->ImportInstore,
                'sum' => $request->product_price_buy*$request->ImportInstore,
                'rate' => 1,
                'dr' => $dr,
                'cr' => $cr,
                'user_id' => $request->user_id,
                'work_status' => 'success'
            ]);
            $accs->save();


            if($request->CashType == 'true'){ $cashtype = 'true'; } else { $cashtype = 'false'; }
            /// add import
            $st = Store::all()->sortByDesc('id')->take(1)->toArray();
            $store_id = null;
            foreach($st as $re) { $store_id = $re['store_id']; }
            if($store_id!=null){ $store_id = (int)$store_id+1; } else { $store_id = 1; }
            $length = 8;
            $store_id = substr(str_repeat(0, $length).$store_id, - $length);

            $store = new Store();
            $store->store_id = $store_id;
            $store->product_id = $request->IDPro;
            $store->st_import_amount = $request->ImportInstore;
            $store->st_import_pack_amount = (int)$request->ImportInstore*(int)$product_que[0]->product_unit_type;
            $store->st_price_buy = $request->product_price_buy;
            $store->st_price_sell = json_encode($request->product_price_sell);
            $store->st_instore_sell = 0;
            $store->st_trn_id = $tnum.$number;
            $store->st_cashtype = $cashtype;
            $store->st_user_id = $request->user_id;
            $store->save();
            $success = true;

            $store = Store::leftJoin('users', 'users.id', '=', 'stores.st_user_id')
            ->leftJoin('products', 'products.product_id', '=', 'stores.product_id')
            ->orderBy('stores.created_at', 'desc')
            ->where('stores.st_import_amount','!=','0')
            ->paginate(10,array('stores.*', 'users.user_name','users.sex','users.name','users.last_name','products.product_images','products.product_name','products.product_barcode'))
            ->toArray();

            //$store = Store::orderBy('created_at', 'desc')
            //->where('st_import_amount','!=','0')
            //->paginate(10)
           // ->toArray();

           // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ນຳເຂົ້າ ສິນຄ້າໃໝ່, ເລກທີ່ນຳເຂົ້າ: '.$store_id,'success');


            $que = array_reverse($store);
            $message = 'ນຳເຂົ້າສິນຄ້າ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ນຳເຂົ້າ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que

        ];
        return response()->json($response);

        //end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
    public function edit($id)
    {

        if(check_roles('store_import_edit')){
            // start permissions
            $pro = Store::find($id);

                    $store = Store::select('product_id',\DB::raw('SUM(st_import_amount)-SUM(st_instore_sell) as total'))
                     ->groupBy('product_id');
                    $prod = Product::joinSub($store,'stores', function ($join){
                        $join->on('products.product_id','=','stores.product_id');
                    })
                    ->where('products.product_id','=',$pro->product_id)
                    ->select('stores.total','products.*')
                    ->get();

                    $product_barcode = Barcode::where('product_id','=',$pro->product_id)
                   ->select('pbc_id','option_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
                   ->get();

                   $product_option = ProductOption::where('product_id','=',$pro->product_id)
                    ->select('option_id','option_name','option_default')
                    ->get();

                    //$prod = Product::where('product_id',$pro->product_id)->get();


            $response = [
                'data_import' => $pro,
                'data_product' => $prod,
                'product_barcode'=> $product_barcode,
                'product_option'=> $product_option
            ];
            return response()->json($response);

            //end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {

        if(check_roles('store_import_edit')){
            // start permissions

        try {
            if($request->CashType == 'true'){ $cashtype = 'true'; } else { $cashtype = 'false'; }
            $store = Store::find($id);
            $store->update($request->all([
                $store->st_import_amount = $request->ImportInstore,
                $store->st_import_pack_amount = $request->ImportInstore_pack,
                $store->st_price_buy = $request->product_price_buy,
                $store->st_price_sell = json_encode($request->product_price_sell),
                $store->st_cashtype = $cashtype,
            ]));

            if($request->CashType=='true'){
                // ເງິນສົດ
                $dr = '307';
                $cr = '571';
            } else{
                // ເງິນໂອນ
                $dr = '307';
                $cr = '551';
            }

            $acctrn = AccTRN::where('trn_id',$store->st_trn_id);
            $acctrn->update([
                'amount' => $request->product_price_buy,
                'sum' => $request->product_price_buy*$request->ImportInstore,
                'rate' => 1,
                'dr' => $dr,
                'cr' => $cr,
            ]);

            $product = Product::where('product_id',$store->product_id);
            $product->update([
               // 'product_name' => $request->product_name,
               // 'product_brand' => $request->product_brand,
               // 'product_model' => $request->product_model,
                'in_store' => $request->in_store,
                //'in_store' => (int)$product_que[0]->in_store + (int)$request->ImportInstore,
                'in_store_pack' => $request->in_store_pack,
               // 'product_images' => json_encode($request->product_images),
                'product_detail' => $request->product_detail,
                'product_date_expiry' => $request->date_expiry,
               // 'session_id' => $request->session_id,
               // 'category_id' => $request->category_id,
               // 'sub_category_id' => $request->sub_category_id,
               // 'product_price_buy' => $request->product_price_buy,
               // 'product_price_sell' => json_encode($request->product_price_sell)
            ]);


            $store = Store::leftJoin('users', 'users.id', '=', 'stores.st_user_id')
            ->leftJoin('products', 'products.product_id', '=', 'stores.product_id')
            ->orderBy('stores.created_at', 'desc')
            ->where('stores.st_import_amount','!=','0')
            ->paginate(10,array('stores.*', 'users.user_name','users.sex','users.name','users.last_name','products.product_images','products.product_name','products.product_barcode'))
            ->toArray();
            //return array_reverse($store);


           /* $store = Store::orderBy('created_at', 'desc')
            ->where('st_import_amount','!=','0')
            ->paginate(10)
            ->toArray();*/
            $que = array_reverse($store);

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດລາຍການ ນຳເຂົ້າສິນຄ້າ, ເລກທີ່ນຳເຂົ້າ: '.$id,'success');

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກອັບເດດ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ອັບເດດລາຍການ ນຳເຂົ້າສິນຄ້າ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

         //end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }
    public function delete($id)
    {


        if(check_roles('store_import_remove')){
            // start permissions


        $pro = Store::find($id);
        //return $pro;
        $pro->delete(); // $pro->st_import_amount $pro->product_id

        //$acctrn = AccTRN::where('trn_id',$pro->st_trn_id);
        //$acctrn->delete();

        $acctrn = AccTRN::where('trn_id',$pro->st_trn_id);
        $acctrn->update([ 'work_status'=> 'reject' ]);

        /// update product
        $product_que = Product::where('product_id',$pro->product_id)->get();
        $product = Product::where('product_id',$pro->product_id);

        $check_inStore = (int)$product_que[0]->in_store - (int)$pro->st_import_amount;

        if($check_inStore==0){
            $check_inStore_pack = 0;
        } else {
            $check_inStore_pack = (int)$product_que[0]->in_store_pack - ((int)$pro->st_import_amount*(int)$product_que[0]->product_unit_type);
        }



        if($check_inStore<=0){ $check_inStore = 0; }
            $product->update([
                'in_store' => $check_inStore,
                'in_store_pack' => $check_inStore_pack
            ]);

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ລຶບການນຳເຂົ້າສິນຄ້າ, ເລກທີ່ນຳເຂົ້າ: '.$id,'success');

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

         //end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
}
