<?php

namespace App\Http\Controllers\STORE;

use App\Http\Controllers\Controller;
use App\Models\STORE\SessionProduct;
use App\Models\STORE\Unit;
use Illuminate\Http\Request;

class SessionProductController extends Controller
{
    public function index()
    {

            $key = \Request::get('s');
            $sort = \Request::get('sort');
            if($sort==''){ $sort = 'asc'; }
            if($key !='' && $key !=null){
                $acc = SessionProduct::where('s_cat_id','=',null)->where('s_subcat_id','=',null)->where('s_name','LIKE',"%{$key}%")
            ->orderBy('id', $sort)
            ->paginate(10)
            ->toArray();
            }
            else{
                $acc = SessionProduct::where('s_cat_id','=',null)->where('s_subcat_id','=',null)
            ->orderBy('id', $sort)
            ->paginate(10)
            ->toArray();
            }


            $all = SessionProduct::orderBy('id', $sort)->get();
            $unit = Unit::orderBy('id', $sort)->get();
            //$all = '';

            $response = [
                'all_que' => $all,
                'que' => array_reverse($acc),
                'unit' => $unit
            ];
            return response()->json($response);
    }

    public function add(Request $request)
    {
        try {
            //return  $request->sub_id;
            $sort = $request->sort;
            if($sort==''){ $sort = 'asc'; }

            $acccat = new SessionProduct([
                's_name' => $request->session_name,
                's_cat_id' => $request->cat_id,
                's_subcat_id' => $request->subcat_id,
                's_detail' => $request->detail,
            ]);
            $acccat->save();

            $acc = SessionProduct::where('s_cat_id','=',null)->where('s_subcat_id','=',null)
            ->orderBy('id', $sort)
            ->paginate(10)
            ->toArray();

            $all = SessionProduct::orderBy('id', $sort)->get();

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມໝວດໝູ່ ສິນຄ້າໃໝ່: '.$request->session_name,'success');

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';
            $allque = $all;
            $que = array_reverse($acc);

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $allque ='';
            $que = '';
            save_logs('ເພີ່ມໝວດໝູ່ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'all_que' => $allque,
            'que' => $que
        ];
        return response()->json($response);

    }

    public function edit($id)
    {
        $acccat = SessionProduct::find($id);
        return response()->json($acccat);
    }

    public function update($id, Request $request)
    {
        try {
            $sort = $request->sort;
            if($sort==''){ $sort = 'asc'; }
            $acccat = SessionProduct::find($id);
            $acccat->update($request->all());

            $acc = SessionProduct::where('s_cat_id','=',null)->where('s_subcat_id','=',null)
            ->orderBy('id', $sort)
            ->paginate(10)
            ->toArray();

            $all = SessionProduct::orderBy('id', $sort)->get();

            $success = true;
            $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';
            $allque = $all;
            $que = array_reverse($acc);

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດໝວດໝູ່ ສິນຄ້າ: '.$request->s_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $allque ='';
            $que = '';
            save_logs('ອັບເດດໝວດໝູ່ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'all_que' => $allque,
            'que' => $que
        ];
        return response()->json($response);

    }

    public function delete($id)
    {
        try {

            $acccat = SessionProduct::find($id);
            $acccat_old = SessionProduct::find($id);
            $acccat->delete();

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບໝວດໝູ່ ສິນຄ້າ: '.$acccat_old['s_name'],'success');

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            save_logs('ລຶບໝວດໝູ່ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
    }
}
