<?php

namespace App\Http\Controllers\STORE;

use App\Http\Controllers\Controller;
use App\Models\STORE\Product;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use App\Models\STORE\Store;
use App\Models\STORE\SessionProduct;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{
    //
    public function index()
    {
 
        if(check_roles('store_product_access') || check_roles('pos_access')){ 
            // start permissions

       // $type = \Request::get('type');
            $filtter = \Request::get('filtter');
            $p = \Request::get('all');
            if($p=='all'){ $p=100; } else { $p=40; }
            $s = \Request::get('s');

            if($s!='null' && $s!=''){
                $seach = $s;
                ///----------------------
                $product_id = '';
                $db_barcode = Barcode::where('barcode','=',$seach)->select('product_id')->get();
                if($db_barcode!='[]'){
                    $product_id = $db_barcode[0]->product_id;
                } 
                ///---------------------
                if($filtter!='null'){
                    $f = explode("|",$filtter);
                   if($f[0]){
                        if($f[1]){
                            if($f[2]){

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.session_id','=',$f[0])->where('products.category_id','=',$f[1])->where('products.sub_category_id','=',$f[2])->where('products.product_name','LIKE',"%{$seach}%")->orWhere('products.product_id','LIKE',"%{$seach}%")->orWhere('products.product_model','LIKE',"%{$seach}%")->orWhere('products.product_detail','LIKE',"%{$seach}%")
                               // ->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                return array_reverse($proa);
                            }
                            else
                            {

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.session_id','=',$f[0])->where('products.category_id','=',$f[1])->where('products.product_name','LIKE',"%{$seach}%")->orWhere('products.product_id','LIKE',"%{$seach}%")->orWhere('products.product_model','LIKE',"%{$seach}%")->orWhere('products.product_detail','LIKE',"%{$seach}%")
                               // ->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                return array_reverse($proa);

                            }
                        }
                        else
                        {

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.session_id','=',$f[0])->where('products.product_name','LIKE',"%{$seach}%")->orWhere('products.product_id','LIKE',"%{$seach}%")->orWhere('products.product_model','LIKE',"%{$seach}%")->orWhere('products.product_detail','LIKE',"%{$seach}%")
                               // ->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                return array_reverse($proa);

                        }

                   } else {

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.product_name','LIKE',"%{$seach}%")->orWhere('products.product_id','LIKE',"%{$seach}%")->orWhere('products.product_model','LIKE',"%{$seach}%")->orWhere('products.product_detail','LIKE',"%{$seach}%")
                               // ->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                return array_reverse($proa);

                   }
                }
                else
                {

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.product_name','LIKE',"%{$seach}%")->orWhere('products.product_id','LIKE',"%{$seach}%")->orWhere('products.product_model','LIKE',"%{$seach}%")->orWhere('products.product_detail','LIKE',"%{$seach}%")
                                //->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                //echo $seach;
                                return array_reverse($proa);
                }
            } else {
               // $seach = null;
                if($filtter!='null'){
                    $f = explode("|",$filtter);
                   if($f[0]){
                        if($f[1]){
                            if($f[2]){

                                $proa = Product::orderBy('created_at', 'desc')
                                ->where('products.session_id','=',$f[0])->where('products.category_id','=',$f[1])->where('products.sub_category_id','=',$f[2])
                               // ->orderBy('products.created_at', 'desc')
                                ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                                ->paginate($p)
                                ->toArray();
                                return array_reverse($proa);
                            }
                            else
                            {

                            $proa = Product::orderBy('created_at', 'desc')
                            ->where('products.session_id','=',$f[0])->where('products.category_id','=',$f[1])
                            //->orderBy('products.created_at', 'desc')
                            ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                            ->paginate($p)
                            ->toArray();
                            return array_reverse($proa);

                            }
                        }
                        else
                        {

                        $proa = Product::orderBy('created_at', 'desc')
                        ->where('products.session_id','=',$f[0])
                        //->orderBy('products.created_at', 'desc')
                        ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                        ->paginate($p)
                        ->toArray();
                        return array_reverse($proa);

                        }

                   } else {

                    $proa = Product::orderBy('created_at', 'desc')
                    ->select('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell')
                    ->paginate($p)
                    ->toArray();
                    return array_reverse($proa);

                   }
                }
                else
                {

                    $proa = Product::orderBy('created_at', 'desc')
                    ->select('id','product_id','product_name','product_brand','product_model','product_images','session_id','category_id','sub_category_id','product_price_buy','in_store','product_barcode','product_price_sell','in_store_pack')
                    ->paginate($p)
                    ->toArray();

                    return array_reverse($proa);


                }
            }

             /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }
    public function sbarcode($barcode){

                $db_barcode = Barcode::where('barcode','=',$barcode)
                ->select('pbc_id','option_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
                ->get();

                //
                //return $db_barcode;
                if(count($db_barcode)<1) { 
                    $response = [ 'success' => false, 'message' => 'ບໍ່ພົບສິນຄ້າ ໃນຖານຂໍ້ມູນ!' ];
                    return response()->json($response);
                 }

                $product_id = $db_barcode[0]->product_id;
                $product_option = ProductOption::where('product_id','=',$product_id)
                ->select('option_id','option_name','option_default')
                ->get();

                $product_prices = Barcode::where('product_id','=',$product_id)
                ->select('pbc_id','option_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
                ->get();
                
                //return $db_barcode;

                $product = Product::where('product_id','=',$product_id)
                ->select('products.*')
                ->get();

                $response = [
                    'success' => true,
                    'product' => $product, 
                    'product_options' => $product_option, 
                    'product_prices' => $product_prices, 
                ];
            
                return response()->json($response);

    }

    public function sproduct($product_id){

         $barcode_p = '';
         $barcode_m = '';
        $db_barcode = Barcode::where('product_id',$product_id)->get();
        foreach($db_barcode as $bar){
            
            if($bar['default']=='true'){
                $barcode_m = $bar['barcode'];
            }
            if($bar['default']=='true' && $bar['default_pro']=='true'){
                $barcode_p = $bar['barcode'];
            }
        }
          
           if($barcode_p!=''){ $barcode = $barcode_p; } else { $barcode = $barcode_m;}
        //  }
       

        $product_option = ProductOption::where('product_id','=',$product_id)
        ->select('option_id','option_name','option_default')
        ->get();

        $product_prices = Barcode::where('product_id','=',$product_id)
        ->select('pbc_id','option_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
        ->get();
        
        //return $db_barcode;

        $product = Product::where('product_id','=',$product_id)
        ->select('products.*')
        ->get();

        $response = [
            'success' => true,
            'barcode' => $barcode, 
            'product' => $product, 
            'product_options' => $product_option, 
            'product_prices' => $product_prices, 
        ];
    
        return response()->json($response);

}
    public function getimport()
    {
        if(check_roles('store_product_access')){
            // start permissions

        $filtter = \Request::get('filtter');
        $s = \Request::get('s');
        if($s!='null' && $s!=''){
            $seach = $s;

            ///----------------------
            $product_id = '';
            $db_barcode = Barcode::where('barcode','=',$seach)->select('product_id')->get();
            if($db_barcode!='[]'){
                $product_id = $db_barcode[0]->product_id;
            } 
            
            ///---------------------

            if($filtter!='null'){
                $f = explode("|",$filtter);
               if($f[0]){
                    if($f[1]){
                        if($f[2]){
                            if($product_id){
                                $pro = Product::where('products.session_id','=',$f[0])
                                ->where('products.category_id','=',$f[1])
                                ->where('products.sub_category_id','=',$f[2])
                                ->where('products.product_name','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$seach}%")
                                ->orWhere('products.product_model','LIKE',"%{$seach}%")
                                ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$product_id}%")
                                ->orderBy('created_at', 'desc')
                                ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                                ->toArray();
                                return array_reverse($pro);
                            }else{
                                $pro = Product::where('products.session_id','=',$f[0])
                                ->where('products.category_id','=',$f[1])
                                ->where('products.sub_category_id','=',$f[2])
                                ->where('products.product_name','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$seach}%")
                                ->orWhere('products.product_model','LIKE',"%{$seach}%")
                                ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                                //->orWhere('products.product_id','LIKE',"%{$product_id}%")
                                ->orderBy('created_at', 'desc')
                                ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                                ->toArray();
                                return array_reverse($pro);
                            }
                        }
                        else
                        {
                            if($product_id){
                                $pro = Product::where('products.session_id','=',$f[0])
                                ->where('products.category_id','=',$f[1])
                                ->where('products.product_name','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$seach}%")
                                ->orWhere('products.product_model','LIKE',"%{$seach}%")
                                ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$product_id}%")
                                ->orderBy('created_at', 'desc')
                                ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                                ->toArray();
                                return array_reverse($pro);
                            }else{
                                $pro = Product::where('products.session_id','=',$f[0])
                                ->where('products.category_id','=',$f[1])
                                ->where('products.product_name','LIKE',"%{$seach}%")
                                ->orWhere('products.product_id','LIKE',"%{$seach}%")
                                ->orWhere('products.product_model','LIKE',"%{$seach}%")
                                ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                                //->orWhere('products.product_id','LIKE',"%{$product_id}%")
                                ->orderBy('created_at', 'desc')
                                ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                                ->toArray();
                                return array_reverse($pro);
                            }
                        }
                    }
                    else
                    {
                        if($product_id){
                            $pro = Product::where('products.session_id','=',$f[0])
                            ->where('products.product_name','LIKE',"%{$seach}%")
                            ->orWhere('products.product_id','LIKE',"%{$seach}%")
                            ->orWhere('products.product_model','LIKE',"%{$seach}%")
                            ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                            ->orWhere('products.product_id','LIKE',"%{$product_id}%")
                            ->orderBy('created_at', 'desc')
                            ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                            ->toArray();
                            return array_reverse($pro);
                        }else{
                            $pro = Product::where('products.session_id','=',$f[0])
                            ->where('products.product_name','LIKE',"%{$seach}%")
                            ->orWhere('products.product_id','LIKE',"%{$seach}%")
                            ->orWhere('products.product_model','LIKE',"%{$seach}%")
                            ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                            //->orWhere('products.product_id','LIKE',"%{$product_id}%")
                            ->orderBy('created_at', 'desc')
                            ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                            ->toArray();
                            return array_reverse($pro);
                        }
                    }

               } else {

                if($product_id){
                    $pro = Product::where('products.product_name','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$seach}%")
                    ->orWhere('products.product_model','LIKE',"%{$seach}%")
                    ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$product_id}%")
                    ->orderBy('created_at', 'desc')
                    ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                    ->toArray();
                    return array_reverse($pro);
                }else{
                    $pro = Product::where('products.product_name','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$seach}%")
                    ->orWhere('products.product_model','LIKE',"%{$seach}%")
                    ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                    ->orderBy('created_at', 'desc')
                    ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                    ->toArray();
                    return array_reverse($pro);
                }
                    
               }
            }
            else
            {
                //return $seach;
                if($product_id){
                    $pro = Product::where('product_name','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$seach}%")
                    ->orWhere('products.product_model','LIKE',"%{$seach}%")
                    ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$product_id}%")
                    ->orderBy('created_at', 'desc')
                    ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                    ->toArray();
                    return array_reverse($pro);
                }else{
                    $pro = Product::where('product_name','LIKE',"%{$seach}%")
                    ->orWhere('products.product_id','LIKE',"%{$seach}%")
                    ->orWhere('products.product_model','LIKE',"%{$seach}%")
                    ->orWhere('products.product_detail','LIKE',"%{$seach}%")
                    //->orWhere('products.product_id','LIKE',"%{$product_id}%")
                    ->orderBy('created_at', 'desc')
                    ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                    ->toArray();
                    return array_reverse($pro);
                }
            }
        } else {
           // $seach = null;
            if($filtter!='null'){
                $f = explode("|",$filtter);
               if($f[0]){
                    if($f[1]){
                        if($f[2]){
                            $pro = Product::where('products.session_id','=',$f[0])
                            ->where('products.category_id','=',$f[1])
                            ->where('products.sub_category_id','=',$f[2])
                            ->orderBy('created_at', 'desc')
                            ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                            ->toArray();
                            return array_reverse($pro);
                        }
                        else
                        {
                        $pro = Product::where('products.session_id','=',$f[0])
                        ->where('products.category_id','=',$f[1])
                        ->orderBy('created_at', 'desc')
                        ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                        ->toArray();
                        return array_reverse($pro);
                        }
                    }
                    else
                    {
                    $pro = Product::where('products.session_id','=',$f[0])
                    ->orderBy('created_at', 'desc')
                    ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store'))
                    ->toArray();
                    return array_reverse($pro);
                    }

               } else {
                $pro = Product::orderBy('created_at', 'desc')
                ->paginate(10,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.product_barcode','products.in_store','in_store_pack'))
                ->toArray();
                return array_reverse($pro);
               }
            }
            else
            {

               $pro = Product::orderBy('created_at', 'desc')
                ->select('id','product_id','product_name','product_brand','product_model','product_images','session_id','category_id','sub_category_id','product_price_buy','product_barcode','in_store','in_store_pack')
                ->paginate(10)
                ->toArray();
                return array_reverse($pro);
            }
        }


         /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function add(Request $request)
    {


        if(check_roles('store_product_add')){
            // start permissions


        $repaire = Product::all()->sortByDesc('id')->take(1)->toArray();

        $product_id = null;
        foreach($repaire as $re)
        {
            $product_id = $re['product_id'];
        }

        if($product_id!=null){
            $product_id = (int)$product_id+1;
        } else {
            $product_id = 1;
        }

        $length = 8;
        $product_id = substr(str_repeat(0, $length).$product_id, - $length);

        try {
        $product = new Product();
            $product->product_id = $product_id;
            $product->product_name = $request->product_name;
            $product->product_brand = $request->product_brand;
            $product->product_model = $request->product_model;
            $product->product_images = json_encode($request->product_images);
            $product->product_detail = $request->product_detail;
            $product->session_id = $request->session_id;
            $product->category_id = $request->category_id;
            $product->sub_category_id = $request->sub_category_id;
            $product->product_price_buy = $request->product_price_buy;
            $product->product_date_expiry = $request->product_date_expiry;
            $product->product_unit_type = $request->product_unit_type;
            $product->product_unit = $request->product_unit;
            //$product->product_barcode = $request->product_barcode;
            //$product->product_price_sell = json_encode($request->product_price_sell);
            $product->save();
            $success = true;
            //$success = false;

            $st = Store::all()->sortByDesc('id')->take(1)->toArray();
            $store_id = null;
            foreach($st as $re) { $store_id = $re['store_id']; }
            if($store_id!=null){ $store_id = (int)$store_id+1; } else { $store_id = 1; }
            $length = 8;
            $store_id = substr(str_repeat(0, $length).$store_id, - $length);

            $store = new Store();
            $store->store_id = $store_id;
            $store->product_id = $product_id;
            $store->st_import_amount = 0;
            $store->st_price_buy = $request->product_price_buy;
            $store->st_price_sell = json_encode($request->product_price_sell);
            $store->st_instore_sell = 0;
            $store->st_user_id = $request->user_id;
            $store->save();

            // save barcode 
            foreach($request->product_price_sell as $ps){
                $barcode = new Barcode();
                $barcode->option_id = $ps['option_id'];
                $barcode->pbc_id = $ps['pbc_id'];
                $barcode->barcode = $ps['barcode'];
                $barcode->product_id = $product_id;
                $barcode->price_type = $ps['price_type'];
                $barcode->price = $ps['price'];
                $barcode->price_pro = $ps['price_pro'];
                $barcode->unit = $ps['unit'];
                $barcode->default = $ps['default'];
                $barcode->default_pro = $ps['default_pro'];
                $barcode->sell = $ps['sell'];
                $barcode->save();
            }

            /// save product option

            foreach($request->product_option as $ps){
                $barcode = new ProductOption();
                $barcode->option_id = $ps['option_id'];
                $barcode->product_id = $product_id;
                $barcode->option_name = $ps['option_name'];
                $barcode->option_default = $ps['option_default'];
                $barcode->save();
            }

            /// update price and option to product db

            $product = Product::where('product_id',$product_id);
            $product->update([
                'product_price_sell' => array('product_prices'=>$request->product_price_sell,'product_options'=>$request->product_option)
            ]);



           // $barcode = new Barcode();
           // $barcode
           // $store->save();

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນ ສິນຄ້າໃໝ່: '.$request->product_name,'success');

            $pro = Product::orderBy('created_at', 'desc')
            ->paginate(20,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell'))
            ->toArray();
           $que = array_reverse($pro);
           //$que = '';

            $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດແລ້ວ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ເພີ່ມຂໍ້ມູນ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que

        ];
        return response()->json($response);

         /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function edit($id)
    {

        if(check_roles('store_product_edit')){

                    $product = Product::where('product_id','=',$id)->get();
                    if($product[0]['product_unit']){
                        $product = Product::where('product_id','=',$id)
                        ->join('units','products.product_unit','=','units.id')
                        ->select('products.*','units.unit_name')
                        ->get();
                    }
            

                   $session_id = $product[0]['session_id'];
                   $category_id = $product[0]['category_id'];
                   $sub_category_id = $product[0]['sub_category_id'];
                   
                   $product_sesion = [];
                   $session_name = '';
                   $category_name = '';
                   $sub_category_name = '';
                    //echo $category_id;
                   if($session_id){
                       $session_name = SessionProduct::where('id',$session_id)->get()[0]['s_name'];                       
                   }
                   if($category_id){
                        $category_name = SessionProduct::where('id',$category_id)->get()[0]['s_name'];

                    }
                    if($sub_category_id){
                        $sub_category_name = SessionProduct::where('id',$sub_category_id)->get()[0]['s_name'];

                    }

                    array_push($product_sesion, (object)[ 
                        'session_name' => $session_name,
                        'category_name' => $category_name,
                        'sub_category_name' => $sub_category_name,
                    ]);


                   $product_barcode = Barcode::where('product_id','=',$id)
                   ->select('pbc_id','option_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
                   ->get();

                   $product_option = ProductOption::where('product_id','=',$id)
                   ->select('option_id','option_name','option_default')
                   ->get();
                   
                   $response = [
                    'product_session' => $product_sesion,
                    'product_data' => $product,
                    'product_barcode' => $product_barcode,
                    'product_option' => $product_option,
                ];
                return response()->json($response);
                    /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
    public function update($id, Request $request)
    {
        if(check_roles('store_product_edit')){
            // start permissions
        try {


            $product = Product::where('product_id',$id);
            $product->update([
                'product_name' => $request->product_name,
                'product_brand' => $request->product_brand,
                'product_model' => $request->product_model,
                'product_images' => json_encode($request->product_images),
                'product_detail' => $request->product_detail,
                'session_id' => $request->session_id,
                'category_id' => $request->category_id,
                'sub_category_id' => $request->sub_category_id,
                'product_price_buy' => $request->product_price_buy,
                'product_unit_type' => $request->product_unit_type,
                'product_unit' => $request->product_unit,
                //'product_barcode' => $request->product_barcode,
                //'product_price_sell' => json_encode($request->product_price_sell)
            ]);

            $pro = Product::orderBy('created_at', 'desc')
            ->paginate(20,array('products.id','products.product_id','products.product_name','products.product_brand','products.product_model','products.product_images','products.session_id','products.category_id','products.sub_category_id','products.product_price_buy','products.in_store','products.product_barcode','products.product_price_sell'))
            ->toArray();

            /// ອັບເດດ Barcode

            Barcode::where('product_id',$id)->delete();

            // save barcode 
            foreach($request->product_price_sell as $ps){
                $barcode = new Barcode();
                $barcode->option_id = $ps['option_id'];
                $barcode->pbc_id = $ps['pbc_id'];
                $barcode->barcode = $ps['barcode'];
                $barcode->product_id = $id;
                $barcode->price_type = $ps['price_type'];
                $barcode->price = $ps['price'];
                $barcode->price_pro = $ps['price_pro'];
                $barcode->unit = $ps['unit'];
                $barcode->default = $ps['default'];
                $barcode->default_pro = $ps['default_pro'];
                $barcode->sell = $ps['sell'];
                $barcode->save();
            }

            ProductOption::where('product_id',$id)->delete();
            /// save product option

            foreach($request->product_option as $ps){
                $barcode = new ProductOption();
                $barcode->option_id = $ps['option_id'];
                $barcode->product_id = $id;
                $barcode->option_name = $ps['option_name'];
                $barcode->option_default = $ps['option_default'];
                $barcode->save();
            }

            $product = Product::where('product_id',$id);
            $product->update([
                'product_price_sell' => array('product_prices'=>$request->product_price_sell,'product_options'=>$request->product_option)
            ]);

         


           $que = array_reverse($pro);

           // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
           save_logs('ອັບເດດຂໍ້ມູນ ສິນຄ້າ: '.$request->product_name,'success');

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກອັບເດດ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ອັບເດດຂໍ້ມູນ ສິນຄ້າໃໝ່ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

          /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function delete($id)
    {
        if(check_roles('store_product_remove')){
            // start permissions

        $pro = Product::find($id);
        $pro_old = Product::find($id);

        /// images data
        $images = $pro->product_images;
        $img1 = str_replace("[", "", $images);
        $img2 = str_replace("]", "", $img1);
        $array = explode(",",$img2);

        for ($i=0; $i <count($array) ; $i++) {
            if($array[$i]!=''){
                $njson = json_decode($array[$i], true);
                    if(file_exists('images/product/'.$njson['img'])){
                        unlink('images/product/'.$njson['img']);
                        }
            }
        }

        // del price and option
        Barcode::where('product_id',$pro_old['product_id'])->delete();
        ProductOption::where('product_id',$pro_old['product_id'])->delete();

        $pro->delete();

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ລຶບຂໍ້ມູນ ສິນຄ້າ: '.$pro_old['product_name'],'success');

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

         /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}
