<?php

namespace App\Http\Controllers\STORE;

use App\Http\Controllers\Controller;
use App\Models\STORE\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    //
    public function index()
    {

        if(check_roles('setting_unitband_access')){

            $type = \Request::get('type');
            if($type!='' && $type == 'all'){
                $brand = Brand::all()->toArray();
                return array_reverse($brand);
            } else {
                $brand = Brand::orderBy('created_at', 'desc')
                ->paginate(10)
                ->toArray();
                return array_reverse($brand);
            }

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function add(Request $request)
    {
        if(check_roles('setting_brand_add')){
            // start permissions
        try {
        $brand = new Brand();
            $brand->brand_name = $request->brand_name;
            $brand->brand_image = $request->brand_image;
            $brand->save();
            $success = true;

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນຊື່ Brand: '.$request->brand_name,'success');

            $brand = Brand::orderBy('created_at', 'desc')
            ->paginate(10)
            ->toArray();
           $que = array_reverse($brand);

            $message = 'ຂໍ້ມູນບັນທຶກ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ເພີ່ມຂໍ້ມູນຊື່ Brand error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que

        ];
        return response()->json($response);

        /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function update($id, Request $request)
    {
        if(check_roles('setting_brand_edit')){
            // start permissions

        try {
            $brand = Brand::find($id);
            if($request->brand_image){

                if($request->brand_image != $brand->brand_image){
                    if($brand->brand_image!=''){
                            if(file_exists('images/avatars/'.$brand->brand_image)){
                        unlink('images/avatars/'.$brand->brand_image);
                        }
                    }

                }

                $brand->update($request->all([
                    $brand->brand_name = $request->brand_name,
                    $brand->brand_image = $request->brand_image,
                ]));
            } else {
                $brand->update($request->all([
                    $brand->brand_name = $request->brand_name
                ]));
            }


            $brand = Brand::orderBy('created_at', 'desc')
            ->paginate(10)
            ->toArray();
           $que = array_reverse($brand);

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຊື່ Brand: '.$request->brand_name,'success');

            $success = true;
            $message = 'ອັບເດດຊື່ Brand ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
            save_logs('ອັບເດດຊື່ Brand error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function delete($id)
    {

        if(check_roles('setting_brand_remove')){
            // start permissions

        $brand = Brand::find($id);

        if($brand->brand_image!=''){
            if(file_exists('images/avatars/'.$brand->brand_image)){
                unlink('images/avatars/'.$brand->brand_image);
                }
            }
        
        $brand_old = Brand::find($id);
        $brand->delete();

         // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
         save_logs('ລຶບຂໍ້ມູນຊື່ Brand: '.$brand_old['brand_name'],'success');

        $success = true;
        $message = 'ຂໍ້ມຸນໄດ້ຖຶກລຶບ ສຳເລັດ!';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

        /// end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }
}
