<?php

namespace App\Http\Controllers\PreOrder;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PreOrder\Supplier;

class SupplierController extends Controller
{
    //
    public function index(){

        if(check_roles('supplier_access')){

            try {

                $Supplier_list = Supplier::orderBy('created_at', 'desc')
                ->paginate(10)
                ->toArray();


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                $Supplier_list = '';
            }

            $response = [
                'supplier' => $Supplier_list,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function add(Request $request){
        if(check_roles('supplier_add')){

            try {

                $Supplier = new Supplier();
                $Supplier->sup_name = $request->name;
                $Supplier->sup_tel = $request->tel;
                $Supplier->sup_email = $request->email;
                $Supplier->sup_address = $request->address;
                $Supplier->sup_web = $request->web;
                $Supplier->sup_images = $request->images;
                $Supplier->save();
                $success = true;

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ສ້າງຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ: '.$request->name,'success');

                $Supplier_list = Supplier::orderBy('created_at', 'desc')
                ->paginate(10)
                ->toArray();


                $success = true;
                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                $Supplier_list = '';
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ສ້າງຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ ! error: '.$message,'error');
            }

            $response = [
                'supplier' => $Supplier_list,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function edit($id){
        if(check_roles('supplier_access')){

            try {


               

                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                $Supplier_list = '';
            }

            $response = [
                'supplier' => $Supplier_list,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function update($id, Request $request){
        if(check_roles('supplier_edit')){

            try {


                Supplier::where('id',$id)
                ->update([
                    'sup_name' => $request->name,
                    'sup_tel' => $request->tel,
                    'sup_email'=> $request->email,
                    'sup_web'=> $request->web,
                    'sup_address'=> $request->address,
                    'sup_images'=> $request->images,
                ]);

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ອັບເດດຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ: '.$request->name,'success');

                $Supplier_list = Supplier::orderBy('created_at', 'desc')
                ->paginate(10)
                ->toArray();


                $success = true;
                $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                $Supplier_list = '';
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ອັບເດດຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ error: '.$message,'error');
            }

            $response = [
                'supplier' => $Supplier_list,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function delete($id){
        if(check_roles('supplier_remove')){

            try {

                $sup = Supplier::where('id',$id)->get();

                if($sup[0]['sup_images']!='' && $sup[0]['sup_images']!=null){
                    if(file_exists('images/avatars/'.$sup[0]['sup_images'])){
                        unlink('images/avatars/'.$sup[0]['sup_images']);
                        }
                }
                
                Supplier::find($id)->delete();

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ລຶບຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ: '.$sup[0]['sup_name'],'success');

                $Supplier_list = Supplier::orderBy('created_at', 'desc')
                ->paginate(10)
                ->toArray();
            
                $success = true;
                $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                $Supplier_list = '';
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ລຶບຂໍ້ມູນ ຜູ້ສະໜອງສິນຄ້າ error: '.$message,'error');
            }

            $response = [
                'supplier' => $Supplier_list,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
}
