<?php

namespace App\Http\Controllers\PreOrder;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Models\PreOrder\PreOrder;
use App\Models\PreOrder\PreOrderItem;
use App\Models\ACC\AccTRN;

use App\Models\Bills;
use App\Models\BillsList;
use App\Models\STORE\Store;
use App\Models\STORE\Product;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use App\Models\STORE\Unit;

class PreOrderController extends Controller
{
    //
    public function index(){

        if(check_roles('preorder_access')){

            try {


                $key = \Request::get('s');
                $filter = \Request::get('filter');

                if($key==''){
                    if($filter=='pay'){

                        $preorder = PreOrder::where('pre_orders.work_status','success')->where('pre_orders.status','payed')
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();

                    } elseif($filter=='unpay'){

                        $preorder = PreOrder::where('pre_orders.work_status','success')->where('pre_orders.status','pending')
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();

                    } else {
                            $preorder = PreOrder::where('pre_orders.work_status','success')
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();
                    }
                    
                } else {
                    if($filter=='pay'){
                        $preorder = PreOrder::where('pre_orders.work_status','success')->where('pre_orders.status','payed')->where('pre_orders.preorder_id','LIKE',"%{$key}%")->orWhere('pre_orders.customer_name','LIKE',"%{$key}%")
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();
                    } elseif($filter=='unpay'){
                        $preorder = PreOrder::where('pre_orders.work_status','success')->where('pre_orders.status','pending')->where('pre_orders.preorder_id','LIKE',"%{$key}%")->orWhere('pre_orders.customer_name','LIKE',"%{$key}%")
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();
                    } else {
                        $preorder = PreOrder::where('pre_orders.work_status','success')->where('pre_orders.preorder_id','LIKE',"%{$key}%")->orWhere('pre_orders.customer_name','LIKE',"%{$key}%")
                        ->leftJoin('customers', 'customers.id', '=', 'pre_orders.customer_id')
                        ->leftJoin('customer_offices', 'customer_offices.id', '=', 'pre_orders.customer_id')
                        ->orderBy('created_at', 'desc')
                        ->paginate(10, array('pre_orders.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel', 'customer_offices.office_name','customer_offices.office_tel'))
                        ->toArray();
                    }
                    
                }

                
                //return array_reverse($preorder);


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $preorder = '';
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'AllPreorder' => $preorder,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function add(Request $request){
        if(check_roles('preorder_add')){

            try {

                PreOrder::where('work_status','create')->delete();

                $or = PreOrder::all()->sortByDesc('created_at')->take(1)->toArray();
                $number = 1;
                foreach($or as $orr)
                {
                    $number = $orr['preorder_id'];
                }

                if($number!=''){

                $number = str_replace("PRE","",$number);
                $number = (int)$number+1;
                $length = 5;
                $number = substr(str_repeat(0, $length).$number, - $length);
                }
            
                
                $preorder = new PreOrder();
                $preorder->preorder_id = "PRE".$number;
                $preorder->supplier_id = 0;
                $preorder->customer_id = 0;
                //$preorder->customer_name = $request->customer_name;
                //$preorder->customer_tel = $request->customer_tel;
                //$preorder->customer_address = $request->customer_address;
                //$preorder->customer_type = $request->customer_type;
                //$preorder->tran_price = json_encode($request->tran_price);
                //$preorder->amount = $request->amount;
                //$preorder->rate = '1';
                //$preorder->transport_day = $request->transport_day;
                //$preorder->user_id = $request->user_id;
                //$preorder->play_status = $play_status;
                $preorder->work_status = 'create';

                $preorder->save();
                $preorder_id = $preorder->preorder_id;
                
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ສ້າງໃບຮັບເຄື່ອງ ເລກທີ່: '.$preorder_id,'success');


                $success = true;
                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $preorder_id = '';
                $success = false;
                $message = $ex->getMessage();

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ສ້າງໃບຮັບເຄື່ອງ error: '.$message,'error');
            }

            $response = [
                'preorder_id' => $preorder_id,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function import_to_bill(Request $request){

        if(check_roles('bill_add')){

            try {

               $preorder = PreOrder::where('preorder_id',$request->preorder_id)->get();

               //return $preorder[0]['billnum_id'];

               $check_bill = Bills::where('work_status','success')->where('billnum_id',$preorder[0]['billnum_id']);

               // return $check_bill->count();

               if($check_bill->count()){
                
                $billnum_id = $preorder[0]['billnum_id'];
                $success = true;
                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';
               }else{

               

                            //echo $request->customer_data['Customer_name'];
                        // create bill -----------------------------------

                            Bills::where('work_status','create')->delete();
                            $billg = Bills::all()->sortByDesc('created_at')->take(1)->toArray();
                            $number = 1;
                            foreach($billg as $bill) { $number = $bill['billnum_id']; }
                            if($number!=''){ $number = str_replace("SIT","",$number); $number = (int)$number+1; $length = 5; $number = substr(str_repeat(0, $length).$number, - $length); }

                            $bills = new Bills();
                            $bills->status = 'pending';
                            $bills->signed = 'false';
                            $bills->billnum_id = 'SIT'.$number;
                            $bills->tax = '0';
                            $bills->work_status = 'create';
                            $bills->save();
                            $bill_id = $bills->id;
                            $billnum_id = $bills->billnum_id;
                            $dateCreat = $bills->created_at;

                            //return $dateCreat;

                        // end create bill -------------------------------

                        // gen data import to bill
                        $totalAmount =0;
                        $totalCount =0;
                        $tax_amount =0;
                        $discount =0;
                        $ListBilldata = [];
                        $ListItemBill = [];
                        // echo  $request->preorder_import[0];
                        foreach($request->preorder_import as $item)
                        {
                            //echo $item['name'];

                            

                            if($item['product_id']){

                                $product = Product::where('product_id','=',$item['product_id'])->get();
                                if($product[0]['product_unit']){
                                    $product = Product::where('product_id','=',$item['product_id'])
                                    ->join('units','products.product_unit','=','units.id')
                                    ->select('products.*','units.unit_name')
                                    ->get();
                                }

                                $product_option = ProductOption::where('product_id','=',$item['product_id'])
                                ->select('option_id','option_name','option_default')
                                ->get();
                                
                                $unit_type ='';
                                if($product[0]['product_unit_type']=='1'){
                                    $unit_type ='unit';
                                } else { $unit_type ='pack'; }
                            // dd($product);
                                $data_de = json_decode($product[0]['product_price_sell'],true);
                                //return $data_de['product_prices'];
                                //print_r($product[0]['product_price_sell']);
                                // foreach(json_decode($product[0]['product_price_sell']) as $it){
                                //     print_r($it);
                                // }

                                $list_id = "LB".rand(99,100000000);
                                array_push($ListItemBill, (object)[
                                    "id" => $list_id,
                                    "product_id" => $item['product_id'],
                                    "barcode" => null,
                                    "product_name" => $item['name'],
                                    "product_option" => $product_option,
                                    "product_price" => $data_de['product_prices'],
                                    "bill_type" => "product",
                                    "unit" => $unit_type,
                                    "unit_to" => $product[0]['product_unit_type'],
                                    "count" => $item['amount'],
                                    "price_buy" => $item['price_buy'],
                                    "price" => $item['price_sell'],
                                    "sum" => $item['price_sell']*$item['amount']
                                ]);
                                //dd(json_decode($item['price_sell']));
                            // return $product;
                                $totalAmount += (int)$item['amount']*(int)$item['price_sell'];
                                $totalCount += (int)$item['amount'];

                                /// add to bill list

                                $billslist = new BillsList();
                                $billslist->billnum_id = $billnum_id;
                                $billslist->name = $item['name'];
                                $billslist->detail = null;
                                $billslist->bill_type = 'product';
                                $billslist->product_id = $item['product_id'];
                                $billslist->bill_list_id = $list_id;
                                $billslist->barcode = null;
                                $billslist->count = (int)$item['amount'];
                                $billslist->credit = (int)$item['price_sell'];
                                $billslist->work_status = 'success';
                                $billslist->save();


                            } else {

                                $list_id = "LB".rand(99,100000000);
                                array_push($ListItemBill, (object)[
                                    "id" => $list_id,
                                    "product_id" => null,
                                    "barcode" => null,
                                    "product_name" => $item['name'],
                                    "product_option" => null,
                                    "product_price" => null,
                                    "bill_type" => "service",
                                    "unit" => null,
                                    "unit_to" => null,
                                    "count" => $item['amount'],
                                    "price_buy" => $item['price_buy'],
                                    "price" => $item['price_sell'],
                                    "sum" => $item['price_sell']*$item['amount']
                                ]);

                                $totalAmount += (int)$item['amount']*(int)$item['price_sell'];
                                $totalCount += (int)$item['amount'];

                                /// add to bill list

                                $billslist = new BillsList();
                                $billslist->billnum_id = $billnum_id;
                                $billslist->name = $item['name'];
                                $billslist->detail = null;
                                $billslist->bill_type = 'service';
                                $billslist->product_id = $item['product_id'];
                                $billslist->bill_list_id = $list_id;
                                $billslist->barcode = null;
                                $billslist->count = (int)$item['amount'];
                                $billslist->credit = (int)$item['price_sell'];
                                $billslist->work_status = 'success';
                                $billslist->save();

                            }

                            
                            
                        }

                        array_push($ListBilldata,(object)[
                            "QuoNumId" => "",
                            "BillsId" => $billnum_id,
                            "ListItemBill"=>  $ListItemBill,
                            "discount"=>0,
                        ]);
                            
                

                        //dd($ListBilldata);
                        
                        // add update bill --------------

                            $bill = Bills::where('billnum_id',$billnum_id)
                            ->update([
                                'office_id' => $request->customer_data['Customer_id'],
                                'customer_id' => $request->customer_data['Customer_id'],
                                'customer_name' => $request->customer_data['Customer_name'],
                                'customer_tel' => $request->customer_data['Customer_tel'],
                                'customer_address' => $request->customer_data['Customer_address'],
                                'user_id' => $request->user_id,
                                'signed' => 'true',
                                'customer_type' => $request->customer_data['CustomerSe'],
                                'all_credit' => $totalAmount,
                                'all_count' => $totalCount,
                                'tax' => $tax_amount,
                                'discut' => $discount,
                                'ListBilldata'=> $ListBilldata,
                                'work_status'=> 'success'
                            ]);

                        // end add update bill ----------
                        //   echo $request->preorder_id;
                                    
                                    PreOrder::where('preorder_id',$request->preorder_id)
                                    ->update([
                                        'billnum_id' => $billnum_id
                                    ]);
                        
                        
                            
                            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                            //save_logs('ສ້າງໃບຮັບເຄື່ອງ ເລກທີ່: '.$preorder_id,'success');


                $success = true;
                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

              }

            } catch (\Illuminate\Database\QueryException $ex) {
                $billnum_id = '';
                $success = false;
                $message = $ex->getMessage();

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ສ້າງໃບຮັບເຄື່ອງ error: '.$message,'error');
            }

            $response = [
                'billnum_id'=> $billnum_id,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function edit($id){
        if(check_roles('preorder_access')){

            try {

                $preorder = PreOrder::where('work_status','success')
                ->where('preorder_id',$id)
                ->join('suppliers','suppliers.id','=','pre_orders.supplier_id')
                ->select('pre_orders.*','suppliers.sup_name','suppliers.sup_tel','suppliers.sup_address','suppliers.sup_images','suppliers.sup_email','suppliers.sup_web')
                ->get();
                $preorder_list = PreOrderItem::where('work_status','success')->where('preorder_id',$id)->get();
                $pre_list_data = [];

                foreach($preorder_list as $list){
                        array_push($pre_list_data, (object)[
                            'id' => $list['id'],
                            'product_id' => $list['product_id'],
                            'name' => $list['item_name'],
                            'amount' => $list['amount'],
                            'price_buy' => $list['price_buy'],
                            'price_sell' => $list['price_sell'],
                            'item_tran_status' => $list['item_tran_status'],
                            'detail' => $list['detail'],
                            'images' => $list['item_images'],
                        ]);
                   
                }

                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $preorder = '';
                $pre_list_data = '';
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'preorder_data' => $preorder,
                'pre_list_data' => $pre_list_data,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
    // public function update($id, Request $request){

    // }

    public function update($id, Request $request){
        if(check_roles('preorder_edit')){

            try {

                if($request->PayStatus){
                    $pay_status = 'payed';
                }else{
                    $pay_status = 'pending';
                }

                $qr = PreOrder::where('preorder_id',$id)->take(1)->get();
                $preorder_date = $qr[0]['created_at'];
                $preorder_id = $id;

            if($request->EditForm_pre){ /// ຖ້າຟອມມີການອັບເດດ

                    

                    $preorder = PreOrder::where('preorder_id',$id)
                        ->update([
                            'supplier_id' => $request->supplier_id,
                            'customer_id' => $request->customer_id,
                            'customer_name' => $request->customer_name,
                            'customer_tel' => $request->customer_tel,
                            'customer_address' => $request->customer_address,
                            'customer_type' => $request->customer_type,
                            'tran_price' => json_encode($request->tran_price),
                            'amount' => $request->amount,
                            'rate' => '1',
                            'transport_status' => $request->transport_status,
                            'transport_day' => $request->transport_day,
                            'user_id' => $request->user_id,
                            'pay_status' => $pay_status,
                            'work_status'=> 'success'
                        ]);

                   
                    
                    // get old id form db
                    $old_id_array = array();
                    $item_id = PreOrderItem::where('preorder_id', $preorder_id)->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
        
                    foreach($item_id as $item){
                            array_push($old_id_array,$item['id']);
                    }

                    // get new id from post
                    $new_id_array = array();
                    foreach($request->preoder_item as $item)
                    {
                        array_push($new_id_array,$item['id']);
                    }

                    // del list from db
                    foreach($item_id as $item){
                        
                        if(!in_array($item['id'], $new_id_array)){
                            $preitem = PreOrderItem::find($item['id']);
                            $preitem->delete();
                        }
                    }
                    
                    /// ລຶບລາຍການ ທຸລະກຳ ແລ້ວສ້າງ ທຸລະກຳໃໝ່
                    AccTRN::where('bill_id',$preorder_id)->update([ 'work_status'=> 'reject' ]);
    
                    foreach($request->preoder_item as $li)
                    {

                        if(in_array($li['id'], $old_id_array)){
                            PreOrderItem::where('id',$li['id'])
                            ->update([
                                'product_id' => $li['product_id'],
                                'amount' => $li['amount'],
                                'amount_instore' => $li['amount'],
                                'item_name' => $li['name'],
                                'item_images' => $li['images'],
                                'price_buy' => $li['price_buy'],
                                'price_sell' => $li['price_sell'],
                                'detail' => $li['detail'],
                               // 'item_tran_status'=> 'success',
                                'work_status'=> 'success'
                            ]);
                        }else{
                            $orderlist = new PreOrderItem();
                            $orderlist->preorder_id = $preorder_id;
                            $orderlist->product_id = $li['product_id'];
                            $orderlist->amount = $li['amount'];
                            $orderlist->amount_instore = $li['amount'];
                            $orderlist->item_name = $li['name'];
                            $orderlist->item_images = $li['images'];
                            $orderlist->price_buy = $li['price_buy'];
                            $orderlist->price_sell = $li['price_sell'];
                            $orderlist->detail = $li['detail'];
                            $orderlist->item_tran_status = 'pending';
                            $orderlist->work_status = 'success';
                            $orderlist->save();
                        }
                       
                        // ລົງບັນຊີ -----------------
                        //$pay_status = 'none';
                        if($pay_status == 'pending') // ຖ້າບໍ່ມີການຊຳລະເງິນເທື່ອ ໃຫ້ເຮັດວຽກນີ້ ລົງບັນຊີໜີ້ຕ້ອງສົ່ງ
                        {
                            // if($item['CashType']=='true'){ 
                            //     $dr = '624'; $cr = '571'; 
                            // } elseif($item['CashType']=='false') { 
                            //     $dr = '624'; $cr = '511'; 
                            // } 

                            $dr = '307'; $cr = '401'; 
                            
                            $trn_type ='capital';
                            //$repaire = AccTRN::all()->sortByDesc('id')->take(1)->toArray(); ->orderBy('id','desc')
                            $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                            $number = $trn_org[0]['trn_id'];
                            
                            if($number){
                                $number1 = str_replace("INC","",$number);
                                $number2 = str_replace("EXP","",$number1);
                                $number3 = str_replace("CAP","",$number2);
                                $number4 = str_replace("CIN","",$number3);
                                $number5 = str_replace("EXC","",$number4);
                                $number = (int)$number5+1;
                                $length = 8;
                                $number = substr(str_repeat(0, $length).$number, - $length);
                               
                            } else {
                                $number_c = 1;
                                $number = substr(str_repeat(0, $length).$number_c, - $length);
                            }
                            
                           

                            if($trn_type=='income'){ $tnum = 'INC'; }
                            elseif($trn_type=='expense'){ $tnum = 'EXP'; }
                            elseif($trn_type=='capital'){ $tnum = 'CAP'; }
                            elseif($trn_type=='cincome'){ $tnum = 'CIN'; } ///ປ່ຽນໃຫ້ເປັນລາຍຮັບ
                                
                            $accs = new AccTRN([
                                'trn_id' => $tnum.$number,
                                'bill_list_id' => $li['id'],
                                'barcode' => '',
                                'bill_id' => $preorder_id,
                                'trn_type' => $trn_type,
                                'acc_trn_detail' => 'ສັ່ງຊື້ສິນຄ້າ(ຕິດໜີ້) ເລກທີ່ໃບສັ່ງຊື້: '.$preorder_id.' ລາຍລະອຽດ: '.$li['detail'],
                                'amount' => $li['price_buy'],
                                'count' => $li['amount'],
                                'sum' => (int)$li['price_buy'] * $li['amount'],
                                'rate' => '1',
                                'dr' => $dr,
                                'cr' => $cr,
                                'user_id' => $request->user_id,
                                'work_status'=> 'success',
                                'created_at'=>$preorder_date
                            ]);
                            $accs->save();

                            save_logs('ລົງບັນຊີ ສັ່ງຊື້ສິນຄ້າ (ຕິດໜີ້) '.$preorder_id.' ລາຍລະອຽດ: '.$li['detail'],'success');


                        } 
                        elseif($pay_status == 'payed') // ຖ້າມີການຊຳລະເງິນແລ້ວ ໃຫ້ລົງບັນຊີ ລົງທຶນ
                        {
                            
                                if($request->CashType_pre=='true'){ 
                                    $dr = '307'; $cr = '571'; 
                                } elseif($request->CashType_pre=='false') 
                                    { $dr = '307'; $cr = '551'; }
                                
                                $trn_type ='capital';
                                $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                            $number = $trn_org[0]['trn_id'];
                            
                            if($number){
                                $number1 = str_replace("INC","",$number);
                                $number2 = str_replace("EXP","",$number1);
                                $number3 = str_replace("CAP","",$number2);
                                $number4 = str_replace("CIN","",$number3);
                                $number5 = str_replace("EXC","",$number4);
                                $number = (int)$number5+1;
                                $length = 8;
                                $number = substr(str_repeat(0, $length).$number, - $length);
                               
                            } else {
                                $number_c = 1;
                                $number = substr(str_repeat(0, $length).$number_c, - $length);
                            }
                                if($trn_type=='income'){ $tnum = 'INC'; }
                                elseif($trn_type=='expense'){ $tnum = 'EXP'; }
                                elseif($trn_type=='capital'){ $tnum = 'CAP'; }
                                elseif($trn_type=='cincome'){ $tnum = 'CIN'; } ///ປ່ຽນໃຫ້ເປັນລາຍຮັບ
    
                                $accs = new AccTRN([
                                    'trn_id' => $tnum.$number,
                                    'bill_list_id' => $li['id'],
                                    'barcode' => '',
                                    'bill_id' => $preorder_id,
                                    'trn_type' => $trn_type,
                                    'acc_trn_detail' => 'ສັ່ງຊື້ສິນຄ້າ ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$li['detail'],
                                    'amount' => $li['price_buy'],
                                    'count' => $li['amount'],
                                    'sum' => (int)$li['price_buy'] * $li['amount'],
                                    'rate' => '1',
                                    'dr' => $dr,
                                    'cr' => $cr,
                                    'user_id' => $request->user_id,
                                    'work_status'=> 'success',
                                    'created_at'=>$preorder_date
                                ]);
                                $accs->save();
    
                                save_logs('ລົງບັນຊີ ສັ່ງຊື້ສິນຄ້າ ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$li['detail'],'success');

                        }

                        
                    }


                    // ບັນທຶກບັນຊີ ຂົນສົ່ງ ເຂົ້າໃນລະບົບ -----------------------------
                    foreach($request->tran_price as $item)
                    {
                        if($item['CashType']=='true'){ $dr = '624'; $cr = '571'; } elseif($item['CashType']=='false') { $dr = '624'; $cr = '551'; }
                        $trn_type ='expense';
                        $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                            $number = $trn_org[0]['trn_id'];
                            
                            if($number){
                                $number1 = str_replace("INC","",$number);
                                $number2 = str_replace("EXP","",$number1);
                                $number3 = str_replace("CAP","",$number2);
                                $number4 = str_replace("CIN","",$number3);
                                $number5 = str_replace("EXC","",$number4);
                                $number = (int)$number5+1;
                                $length = 8;
                                $number = substr(str_repeat(0, $length).$number, - $length);
                               
                            } else {
                                $number_c = 1;
                                $number = substr(str_repeat(0, $length).$number_c, - $length);
                            }
                        if($trn_type=='income'){ $tnum = 'INC'; }
                        elseif($trn_type=='expense'){ $tnum = 'EXP'; }
                        elseif($trn_type=='capital'){ $tnum = 'CAP'; }
                        elseif($trn_type=='cincome'){ $tnum = 'CIN'; } ///ປ່ຽນໃຫ້ເປັນລາຍຮັບ

                        $accs = new AccTRN([
                            'trn_id' => $tnum.$number,
                            'bill_list_id' => $item['id'],
                            'barcode' => '',
                            'bill_id' => $preorder_id,
                            'trn_type' => $trn_type,
                            'acc_trn_detail' => 'ຄ່າຂົນສົ່ງ ໃບສັ່ງຊື້ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$item['detail'],
                            'amount' => $item['price'],
                            'count' => 1,
                            'sum' => (int)$item['price'] * 1,
                            'rate' => '1',
                            'dr' => $dr,
                            'cr' => $cr,
                            'user_id' => $request->user_id,
                            'work_status'=> 'success',
                            'created_at'=>$preorder_date
                        ]);
                     $accs->save();

                        save_logs('ລົງບັນຊີລາຍຈ່າຍ: ຄ່າຂົນສົ່ງ ໃບສັ່ງຊື້ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$item['detail'],'success');
                    }

                    // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ອັບເດດລາຍການ ໃບສັ່ງຊື້ ເລກທີ່: '.$preorder_id,'success');


                } 
            else  // ຖ້າຟອມບໍ່ມີການອັບເດດ
                {


                    $preorder = PreOrder::where('preorder_id',$preorder_id);
                    $get_tran_price = json_decode($preorder->get()[0]['tran_price'],true);
                    //$get_tran_price = json_decode("[{'id':'45'}]"); [0]['tran_price']
                   // echo json_decode($get_tran_price[0]['tran_price'],true);
                   // get tran id from db 
                   $tran_id_array = array();
                    foreach($get_tran_price as $item)
                    {
                        array_push($tran_id_array,$item['id']);
                    }

                    // get tran id from post
                    $new_tran_id = array();
                    foreach($request->tran_price as $item)
                    {
                        array_push($new_tran_id,$item['id']);
                    }

                    /// reject acc trn ຣີເຈັກ ລາຍການທີ່ຖຶກຕັດອອກ ໃນລາຍການທຸລະກຳອອກ
                    foreach($get_tran_price as $item)
                    {
                        if(!in_array($item['id'], $new_tran_id)){
                            AccTRN::where('bill_id',$preorder_id)->where('bill_list_id',$item['id'])->update([ 'work_status'=> 'reject' ]);
                            save_logs('reject ທຸລະກຳ: ຄ່າຂົນສົ່ງ ໃບສັ່ງຊື້ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$item['detail'],'success');
                        }
                    }

                   foreach($request->tran_price as $item)
                    {
                        if(in_array($item['id'], $tran_id_array)){
                            AccTRN::where('bill_id',$preorder_id)->where('bill_list_id',$item['id'])
                            ->update([
                                'amount' => $item['price'],
                                'count' => 1,
                                'sum' => $item['price']*1,
                            ]);
                        } else {
                                
                            if($item['CashType']=='true'){ $dr = '624'; $cr = '571'; } elseif($item['CashType']=='false') { $dr = '624'; $cr = '551'; }
                                $trn_type ='expense';
                                $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                                $number = $trn_org[0]['trn_id'];
                                
                                if($number){
                                    $number1 = str_replace("INC","",$number);
                                    $number2 = str_replace("EXP","",$number1);
                                    $number3 = str_replace("CAP","",$number2);
                                    $number4 = str_replace("CIN","",$number3);
                                    $number5 = str_replace("EXC","",$number4);
                                    $number = (int)$number5+1;
                                    $length = 8;
                                    $number = substr(str_repeat(0, $length).$number, - $length);
                                   
                                } else {
                                    $number_c = 1;
                                    $number = substr(str_repeat(0, $length).$number_c, - $length);
                                }
                                if($trn_type=='income'){ $tnum = 'INC'; }
                                elseif($trn_type=='expense'){ $tnum = 'EXP'; }
                                elseif($trn_type=='capital'){ $tnum = 'CAP'; }
                                elseif($trn_type=='cincome'){ $tnum = 'CIN'; } ///ປ່ຽນໃຫ້ເປັນລາຍຮັບ

                                $accs = new AccTRN([
                                    'trn_id' => $tnum.$number,
                                    'bill_list_id' => $item['id'],
                                    'barcode' => '',
                                    'bill_id' => $preorder_id,
                                    'trn_type' => $trn_type,
                                    'acc_trn_detail' => 'ຄ່າຂົນສົ່ງ ໃບສັ່ງຊື້ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$item['detail'],
                                    'amount' => $item['price'],
                                    'count' => 1,
                                    'sum' => (int)$item['price'] * 1,
                                    'rate' => '1',
                                    'dr' => $dr,
                                    'cr' => $cr,
                                    'user_id' => $request->user_id,
                                    'work_status'=> 'success',
                                    'created_at'=>$preorder_date
                                ]);
                            $accs->save();

                                save_logs('ລົງບັນຊີລາຍຈ່າຍ: ຄ່າຂົນສົ່ງ ໃບສັ່ງຊື້ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$item['detail'],'success');
                        }
                    }

                    $preorder->update([
                            'supplier_id' => $request->supplier_id,
                            'customer_id' => $request->customer_id,
                            'customer_name' => $request->customer_name,
                            'customer_tel' => $request->customer_tel,
                            'customer_address' => $request->customer_address,
                            'customer_type' => $request->customer_type,
                            'tran_price' => json_encode($request->tran_price),
                            //'amount' => $request->amount,
                            'rate' => '1',
                            'transport_status' => $request->transport_status,
                            'transport_day' => $request->transport_day,
                            //'user_id' => $request->user_id,
                            'pay_status' => $pay_status,
                            'work_status'=> 'success'
                        ]);
                    
                    
                    $preorder_item = PreOrderItem::where('preorder_id', $id)->get();

                    if($pay_status == 'payed') // ຖ້າມີການຊຳລະເງິນແລ້ວ ໃຫ້ລົງບັນຊີ ລົງທຶນ
                        {
                            foreach($request->preoder_item as $li)
                            {
                            
                                if($request->CashType_pre=='true'){ 
                                    $dr = '401'; $cr = '571'; 
                                } elseif($request->CashType_pre=='false') 
                                    { $dr = '401'; $cr = '551'; }
                                
                                $trn_type ='capital';
                                $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                            $number = $trn_org[0]['trn_id'];
                            
                            if($number){
                                $number1 = str_replace("INC","",$number);
                                $number2 = str_replace("EXP","",$number1);
                                $number3 = str_replace("CAP","",$number2);
                                $number4 = str_replace("CIN","",$number3);
                                $number5 = str_replace("EXC","",$number4);
                                $number = (int)$number5+1;
                                $length = 8;
                                $number = substr(str_repeat(0, $length).$number, - $length);
                               
                            } else {
                                $number_c = 1;
                                $number = substr(str_repeat(0, $length).$number_c, - $length);
                            }
                                if($trn_type=='income'){ $tnum = 'INC'; }
                                elseif($trn_type=='expense'){ $tnum = 'EXP'; }
                                elseif($trn_type=='capital'){ $tnum = 'CAP'; }
                                elseif($trn_type=='cincome'){ $tnum = 'CIN'; } ///ປ່ຽນໃຫ້ເປັນລາຍຮັບ
    
                                $accs = new AccTRN([
                                    'trn_id' => $tnum.$number,
                                    'bill_list_id' => $li['id'],
                                    'barcode' => '',
                                    'bill_id' => $preorder_id,
                                    'trn_type' => $trn_type,
                                    'acc_trn_detail' => 'ຊຳລ່ະໃບຊື້ສິນຄ້າ ເລກທີ່: '.$preorder_id.' ລາຍລະອຽດ: '.$li['detail'],
                                    'amount' => $li['price_buy'],
                                    'count' => $li['amount'],
                                    'sum' => (int)$li['price_buy'] * $li['amount'],
                                    'rate' => '1',
                                    'dr' => $dr,
                                    'cr' => $cr,
                                    'user_id' => $request->user_id,
                                    'work_status'=> 'success',
                                    'created_at'=>$preorder_date
                                ]);
                                $accs->save();
    
                                

                        }
                        $preorder = PreOrder::where('preorder_id',$preorder_id)->get();
                        save_logs('ຊຳລ່ະໃບຊື້ສິນຄ້າ ເລກທີ່: '.$preorder_id.' ມູນຄ່າ: '.number_format($preorder[0]['amount']),'success');
                    }
                }


                

                $success = true;
                $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ອັບເດດໃບຮັບເຄື່ອງ error: '.$message,'error');
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function delete($id){
        if(check_roles('preorder_remove')){

            try {


                    //  ກວດຊອບ ລາຍການໃບບິນ ທີ່ຖຶກລຶບອກ
                   // $checkDelPreorderList = PreOrderItem::where('work_status','success')->where('preorder_id',$id)->get();
                   // foreach($checkDelPreorderList as $b){

                                       //  reject

                                       //$blistup = PreOrderItem::where('work_status','success')->where('preorder_id',$id);
                                       //$blistup->update([ 'work_status'=> 'reject' ]);

                                      // updat trn list

                                      //$blistup = AccTRN::where('work_status','success')->where('bill_id',$id)->where('bill_list_id',$b['bill_list_id']);
                                       //$blistup->update([ 'work_status'=> 'reject' ]);
                                      // log
                                      //save_logs('ຍົກເລີກລາຍການໃນໃບບິນ (reject) ເລກທີ່: '.$id.' ລາຍການ: '.$b['name']);
                        // }
                   // }



                                   $preorder = PreOrder::where('preorder_id',$id);
                                   $preorder->update([ 'work_status'=> 'reject' ]);

                                    $preorder_list = PreOrderItem::where('preorder_id',$id);
                                    $preorder_list->update([ 'work_status'=> 'reject' ]);

                                   // updat trn list

                                    $acctrn = AccTRN::where('bill_id',$id);
                                    $acctrn->update([ 'work_status'=> 'reject' ]);
                                   // log
                                   save_logs('ຍົກເລີກ ໃບສັ່ງຊື້ສິນຄ້າ (reject) ເລກທີ່: '.$id,'success');
                //     }
                // }

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
               // save_logs('ລຶບໃບບິນ ເລກທີ່: '.$id.' ອອກຈາກລະບົບ');
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                //save_logs('ລຶບໃບຮັບເຄື່ອງ ເລກທີ່: '.$id,'success');

                $success = true;
                $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ລຶບໃບຮັບເຄື່ອງ error: '.$message,'error');
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
}
