<?php

namespace App\Http\Controllers\API;

use Session;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;

class UserController extends Controller
{
    /**
     * Register
     */
    public function register(Request $request)
    {
        try {
            $user = new User();
            $user->name = $request->name;
            $user->sex = 'm';
            $user->user_name = 'user_name1';
            $user->user_type = 'admin';
            $user->permission = 'permission';
            $user->status = 'status';
            $user->email = $request->email;
            $user->images = $request->images;
            $user->password = Hash::make($request->password);
            $user->save();

            $success = true;
            $message = 'User register successfully';
        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
    }

    public function index()
    {
        if(check_roles('user_access')){
            /// start permissions

        $key = \Request::get('s');
        $users = User::where('name','LIKE',"%{$key}%")->orWhere('last_name','LIKE',"%{$key}%")->orWhere('email','LIKE',"%{$key}%")->orWhere('tel','LIKE',"%{$key}%")->paginate(10)->toArray();
        return array_reverse($users);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function add(Request $request)
    {
        if(check_roles('user_access')){
            /// start permissions

        try {
        $user = new User();
            $user->name = $request->name;
            $user->last_name = $request->last_name;
            $user->sex = $request->sex;
            $user->user_name = $request->user_name;
            $user->user_type = $request->user_type;
            $user->permission = $request->permission;
            $user->status = $request->status;
            $user->email = $request->email;
            $user->tel = $request->tel;
            $user->images = $request->images;
            $user->password = Hash::make($request->password);
            $user->save();

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຜູ້ໃຊ້ໃໝ່: '.$request->name,'success');

            $success = true;
            $message = 'ຂໍ້ມູນບັນທຶກ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ຂໍ້ມູນ User ບັນທຶກ error: '.$message,'error');
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function edit($id)
    {
        if(check_roles('user_edit')){
            /// start permissions

        $user = User::find($id);
        return response()->json($user);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function update($id, Request $request)
    {

        if(check_roles('user_edit')){
            /// start permissions


        $user = User::find($id);

        try {

            if($request->images != $user->images){
                if($user->images!=''){
                        if(file_exists('images/avatars/'.$user->images)){
                    unlink('images/avatars/'.$user->images);
                    }
                }
            }


        if($request->password == null){
            $user->update([
                'name' => $request->name,
                'last_name' => $request->last_name,
                'sex' => $request->sex,
                'user_name' => $request->user_name,
                'user_type' => $request->user_type,
                'permission' => $request->permission,
                'status' => $request->status,
                'email' => $request->email,
                'tel' => $request->tel,
                'images' => $request->images,
            ]);
        }
        else
        {
         

            $user->update([
                'name' => $request->name,
                'last_name' => $request->last_name,
                'sex' => $request->sex,
                'user_name' => $request->user_name,
                'user_type' => $request->user_type,
                'permission' => $request->permission,
                'status' => $request->status,
                'email' => $request->email,
                'tel' => $request->tel,
                'password' => Hash::make($request->password),
                'images' => $request->images,
            ]);

            
        }



        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດແລ້ວ!';

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ອັບເດດຂໍ້ມູນຜູ້ໃຊ້: '.$request->name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຂໍ້ມູນຜູ້ໃຊ້ error: '.$message,'error');
        }

         $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function delete($id)
    {

        if(check_roles('user_remove')){
            /// start permissions


            $user = User::find($id);
            /// del img

            if($user->image!=''){
            if(file_exists('images/avatars/'.$user->images)){
                unlink('images/avatars/'.$user->images);
                }
            }
            $user_old = User::find($id);
            $user->delete();


            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຂໍ້ມູນຜູ້ໃຊ້: '.$user_old['name'].' ອອກຈາກລະບົບ','success');

            return response()->json('ຂໍ້ມູນໄດ້ຖຶກລຶບ ອອກຈາກລະບົບແລ້ວ!');

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    /**
     * Login
     */
    public function login(Request $request)
    {
        $remember = $request->remember;
        $credentials = ['email' => $request->email, 'password' => $request->password];

        if (Auth::attempt(['email' => $request->email, 'password' => $request->password],$remember)) {
            $success = true;
            $message = 'ເຂົ້າສູ່ລະບົບ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເຂົ້າສູ່ລະບົບສຳເລັດ!','success');

        } else {
            $success = false;
            $message = 'ອີເມວລ໌ ຫຼື ລະຫັດຜ່ານ ຂອງທ່ານບໍ່ຖຶກຕ້ອງ!';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            //save_logs('ເຂົ້າສູ່ລະບົບບໍ່ສຳເລັດ! error: '.$message,'error');
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
    }

    /**
     * Logout
     */
    public function logout()
    {
        try {

            $user = Auth::user();
            User::where('id',$user->id)->update([ 'remember_token' => '' ]);

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອອກຈາກລະບົບສຳເລັດ!','success');

            Session::flush();

            $success = true;
            $message = 'Successfully logged out';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
    }

    public function checkauth()
    {

        if (Auth::check()) {
            // The user is logged in...
            $isLogin = true;
        } else
        {
            $isLogin = false;
        }

        $response = [
            'isLogin' => $isLogin
        ];
        return response()->json($response);
    }
}