<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Log;
use App\Models\User;


class SettingController extends Controller
{
    //

    public function users_log(){

        if(check_roles('users_log_access')){

            try {

               // $key = \Request::get('s');
                $filter = \Request::get('filter');

                        $users_log = Log::leftJoin('users', 'logs.user_id', '=', 'users.id')
                        ->orderBy('logs.created_at', 'desc')
                        ->paginate(10, array('logs.*', 'users.name','users.sex','users.last_name'))
                        ->toArray();


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $preorder = '';
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'users_log' => $users_log,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
}
