<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;

class ServiceController extends Controller
{
    //
    public function index(){

        if(check_roles('service_access')){

            try {


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function add(Request $request){
        

            try {

                $serv = Service::all()->sortByDesc('created_at')->take(1)->toArray();
                $number = 1;
                foreach($serv as $sv)
                {
                    $number = $sv['service_id'];
                }

                if($number!=''){
                    $number = str_replace("SEV","",$number);
                    $number = (int)$number+1;
                    $length = 5;
                    $number = substr(str_repeat(0, $length).$number, - $length);
                }
                $number = 'SEV'.$number;
                $sv = new Service();
                $sv->service_id = $number;
                $sv->service_name = $request->service_name;
                $sv->price_buy = $request->price_buy;
                $sv->price_sell = $request->price_sell;
                $sv->count = $request->count;
                $sv->work_status = 'success';
                $sv->save();
                $success = true;

                $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $number = '';
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'service_id' => $number,
                'message' => $message
            ];
            return response()->json($response);

        if(check_roles('service_add')){

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function edit($id){
        if(check_roles('service_access')){

            try {


                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function update($id, Request $request){
       

            try {

                $bill = Service::where('service_id',$id)
                    ->update([
                        'service_name' => $request->service_name,
                        'price_buy' => $request->price_buy,
                        'price_sell' => $request->price_sell,
                        'count' => $request->count,
                        
                    ]);

                $success = true;
                $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);
        
            if(check_roles('service_update')){

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }

    public function delete(Request $request){
        

            try {

                $sv = Service::where('service_id',$request->service_id);
                $sv->update([ 'work_status'=> 'reject' ]);


                $success = true;
                $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);
            if(check_roles('service_del')){
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }

    }
}
