<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Roles;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class RolesController extends Controller
{
    //
    public function index()
    {

        $roles = Roles::orderBy('sort', 'ASC')
        ->paginate(5)->toArray();
        $all = Roles::orderBy('sort', 'ASC')->get();
       // return array_reverse($roles);

        $response = [
            'all' => $all,
            'que' => $roles,
        ];
        return response()->json($response );
    }

    public function listroles()
    {

        $all = Roles::orderBy('sort', 'ASC')->get();

        $response = [
            'all' => $all,
        ];
        return response()->json($response );
    }

    public function abilities(){
        $user_roles =  Auth::user()->permission;
        $user_permissions = Roles::find($user_roles);
        return response()->json($user_permissions->permissions);
    }

    public function add(Request $request)
    {

        try {

            $roles = new Roles();
            $roles->roles_name = $request->roles_name;
            $roles->sort = Roles::count()+1;
            $roles->save();

            $roles_que = Roles::orderBy('sort', 'ASC')
            ->paginate(5)->toArray();
            $all = Roles::orderBy('sort', 'ASC')->get();

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດແລ້ວ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມປະເພດຜູ້ໃຊ້ໃໝ່: '.$request->roles_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $roles_que = '';
            $all ='';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມປະເພດຜູ້ໃຊ້ໃໝ່ error: '.$message,'error');
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $roles_que,
            'all' => $all
        ];
        return response()->json($response);
    }

    public function sort(Request $request)
    {

        try {

            $roles = Roles::get();
           // return $roles;
           $sort_id = $request->sort_id;
           $type = $request->type;
           $sort_type = $request->sort_type;
            foreach($roles as $l){
                if($sort_type=='asc'){
                    if($type=='down'){
                        if($sort_id==$l['sort']){

                            if($sort_id!=Roles::count()){
                                $next_sort = (int)$sort_id+1;

                                $rol = Roles::where('sort',$next_sort)->get();
                                $next_id = $rol[0]->id;
                                $next_sort = $rol[0]->sort;
                                
                                Roles::where('id',$next_id)->update(['sort' => (int)$next_sort-1 ]);
                                Roles::where('id',$l['id'])->update(['sort' => (int)$l['sort']+1 ]);
                            }
                        }
                    }elseif($type=='up'){
                        if($sort_id==$l['sort']){

                            if($sort_id!=1){

                                $next_sort = (int)$sort_id-1;
                                $rol = Roles::where('sort',$next_sort)->get();
                                $next_id = $rol[0]->id;
                                $next_sort = $rol[0]->sort;
                                Roles::where('id',$next_id)
                                ->update(['sort' => (int)$next_sort+1 ]);
                                Roles::where('id',$l['id'])
                                ->update(['sort' => (int)$l['sort']-1 ]);
                            }
                        }
                    }

                } elseif($sort_type=='desc'){
                    if($type=='down'){
                        if($sort_id==$l['sort']){

                            if($sort_id!=1){ // ຖ້າ Short_id ທີ່ສົ່ງມາບໍ່ເທົ່າກັບ 1 ໃຫ້ເຮັດວຽກ
                                // ກຳນົດ Short_id ໂຕຕໍ່ໄປ
                                $next_sort = (int)$sort_id-1;

                                // ຊອກຫາ Short_id ຂອງ Short_id ໂຕຕໍ່ໄປ
                                $rol = Roles::where('sort',$next_sort)->get();
                                $next_id = $rol[0]->id;
                                $next_sort = $rol[0]->sort;

                                // ທຳການອັບເດດ
                                Roles::where('id',$next_id)->update(['sort' => (int)$next_sort+1 ]);
                                Roles::where('id',$l['id'])->update(['sort' => (int)$l['sort']-1 ]);
                            }
                        }
                    }elseif($type=='up'){
                        if($sort_id==$l['sort']){

                            if($sort_id!=Roles::count()){

                                $next_sort = (int)$sort_id+1;
                                $rol = Roles::where('sort',$next_sort)->get();
                                $next_id = $rol[0]->id;
                                $next_sort = $rol[0]->sort;
                                Roles::where('id',$next_id)
                                ->update(['sort' => (int)$next_sort-1 ]);
                                Roles::where('id',$l['id'])
                                ->update(['sort' => (int)$l['sort']+1 ]);
                            }
                        }
                    }
                }

            }


            $roles_que = Roles::orderBy('sort', 'ASC')
            ->paginate(5)->toArray();
            $all = Roles::orderBy('sort', 'ASC')->get();

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດແລ້ວ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $roles_que = '';
            $all ='';
        }

        // response
        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $roles_que,
            'all' => $all
        ];
        return response()->json($response);
    }

    public function edit($id)
    {
        $user = Roles::find($id);
        return response()->json($user);
    }

    public function update($id, Request $request)
    {


        try {

            $roles = Roles::find($id);
            $roles->update($request->all([
                $roles->roles_name = $request->roles_name,
            ]));


        $roles_que = Roles::orderBy('sort', 'ASC')
        ->paginate(5)->toArray();
        $all = Roles::orderBy('sort', 'ASC')->get();

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກອັບເດດ ສຳເລັດແລ້ວ!';

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ອັບເດດ ຊື່ປະເພດຜູ້ໃຊ້: '.$request->roles_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $roles_que ='';
            $all = '';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດ ຊື່ປະເພດຜູ້ໃຊ້ error: '.$message,'error');
        }

         $response = [
            'success' => $success,
            'message' => $message,
            'que' => $roles_que,
            'all' => $all
        ];
        return response()->json($response);
    }

    public function setpermissions(Request $request){

        try {

            $data = $request->permissions;
            foreach($data as $rol){
                //echo $roles['id'];
                //return $rol['permissions'];
                $id = (int)$rol['id'];
                if($id!=''){

                    Roles::where('id',$id)->update(['permissions' =>  $rol['permissions'] ]);
                }

            }

        $roles_que = Roles::orderBy('sort', 'ASC')
        ->paginate(5)->toArray();
        $all = Roles::orderBy('sort', 'ASC')->get();

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກອັບເດດ ສຳເລັດແລ້ວ!';

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ໄດ້ກຳນົດສິດ ຂອງປະເພດຜູ້ໃຊ້ໃໝ່','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $roles_que ='';
            $all = '';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ໄດ້ກຳນົດສິດ ຂອງປະເພດຜູ້ໃຊ້ໃໝ່ error: '.$message,'error');
        }

         $response = [
            'success' => $success,
            'message' => $message,
            'que' => $roles_que,
            'all' => $all
        ];
        return response()->json($response);
    }

    public function delete($id)
    {
        try {
            $roles = Roles::find($id);
            $sort_id = $roles->sort;

            $roles = Roles::get();
            foreach($roles as $l){

                    if($l['sort']>$sort_id){
                        Roles::where('id',$l['id'])
                        ->update(['sort' => (int)$l['sort']-1 ]);
                    }

            }


            $roles = Roles::find($id);
            $roles->delete();
            $roles_que = Roles::orderBy('sort', 'ASC')
            ->paginate(5)->toArray();
            $all = Roles::orderBy('sort', 'ASC')->get();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';
            //return $roles['roles_name'];
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບປະເພດຜູ້ໃຊ້: '.$roles['roles_name'].' ອອກຈາກລະບົບ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $roles_que ='';
            $all = '';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບປະເພດຜູ້ໃຊ້ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $roles_que,
            'all' => $all
        ];
        return response()->json($response);
    }
}
