<?php

namespace App\Http\Controllers\API;
use App\Models\Repaire;
use App\Models\ListRepaireItem;
use App\Models\STORE\Product;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use App\Models\STORE\Unit;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Http\File;
use Illuminate\Support\Facades\Storage;

class RepaireController extends Controller
{
    //
    public function index()
    {
        if(check_roles('repaire_assess')){
        /// start permissions 
        $key = \Request::get('s');
        if($key==''){
            $repaire = Repaire::where('work_status','success')
            ->leftJoin('customers', 'customers.id', '=', 'repaires.customer_id')
            ->orderBy('created_at', 'desc')
            ->paginate(10, array('repaires.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel'))
            ->toArray();
        return array_reverse($repaire);
        } else {
            $repaire = Repaire::where('work_status','success')->where('repaires.renum_id','LIKE',"%{$key}%")->orWhere('repaires.customer_name','LIKE',"%{$key}%")
            ->leftJoin('customers', 'customers.id', '=', 'repaires.customer_id')
            ->orderBy('created_at', 'desc')
            ->paginate(10, array('repaires.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel'))
            ->toArray();
        return array_reverse($repaire);
        }
        

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function edit($id)
    {
        if(check_roles('repaire_edit')){

        $repaire = Repaire::where('work_status','success')->where('renum_id',$id)->get();
       // return response()->json($repaire);

        $litem = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->get();
           // return response()->json($litem);


        $billslist = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->get();
            $allProduct = Product::get();
            $allProduct_option = ProductOption::get();
            $allProduct_barcode = Barcode::get();

            $db_product = [];
            $db_product_option = [];
            $db_product_price = [];
            $product_unit_to =[];

            foreach($billslist as $bl){
                foreach($allProduct as $pro){
                    if($bl['product_id']==$pro['product_id']){
                        array_push($product_unit_to, (object)[
                            'id' => $bl['bill_list_id'],
                            'product_id' => $bl['product_id'],
                            'unit_to' => $pro['product_unit_type'],
                        ]); 
                    }
                }
            }

            foreach($billslist as $bl){
                foreach($allProduct as $pro){
                if($bl['product_id']==$pro['product_id']){
                    array_push($db_product, (object)[
                        'product_id' => $pro['product_id'],
                        'in_store' => $pro['in_store'],
                        'in_store_pack' => $pro['in_store_pack'],
                        'product_unit_type' => $pro['product_unit_type']
                    ]);
                }
                }
            }

            foreach($billslist as $bl){
                foreach($allProduct_option as $pro){
                if($bl['product_id']==$pro['product_id']){
                    array_push($db_product_option, (object)[
                        'product_id' => $pro['product_id'],
                        'option_id' => $pro['option_id'],
                        'option_name' => $pro['option_name'],
                        'option_default' => $pro['option_default'],
                    ]);
                }
                }
            }

            foreach($billslist as $bl){
                foreach($allProduct_barcode as $pro){
                if($bl['product_id']==$pro['product_id']){
                    array_push($db_product_price, (object)[
                        'product_id' => $pro['product_id'],
                        'option_id' => $pro['option_id'],
                        'pbc_id' => $pro['pbc_id'],
                        'barcode' => $pro['barcode'],
                        'price_type' => $pro['price_type'],
                        'price' => $pro['price'],
                        'price_pro' => $pro['price_pro'],
                        'unit' => $pro['unit'],
                        'default' => $pro['default'],
                        'default_pro' => $pro['default_pro'],
                    ]);
                }
                }
            }

            $response = [
                'data_repaire' => $repaire,
                'data_list_repaire' => $litem,
                'product_unit_to' => $product_unit_to,
                'db_product' => $db_product,
                'db_product_option' => $db_product_option,
                'db_product_price' => $db_product_price,
                'success' => true,
                'message' => 'ສຳເລັດ!',
            ];
            return response()->json($response);



        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
    public function add(Request $request)
    {
        if(check_roles('repaire_add')){
        /// start permissions 

        Repaire::where('work_status','create')->delete();

        $repaire = Repaire::all()->sortByDesc('created_at')->take(1)->toArray();
        $number = 1;
        foreach($repaire as $re)
        {
            $number = $re['renum_id'];
        }

        if($number!=''){

            $number = str_replace("SRE","",$number);
            $number = (int)$number+1;
           // $number = 98765;
            $length = 5;
            $number = substr(str_repeat(0, $length).$number, - $length);
        }

        try {
            $repaired = new Repaire();
            $repaired->renum_id = 'SRE'.$number;
            $repaired->work_status = 'create';
            $repaired->save();
            $renum_id = $repaired->renum_id;

            $success = true;
            $message = 'successfully';

             // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
             save_logs('ສ້າງໃບຮັບເຄື່ອງນຳລູກຄ້າ ເລກທີ່: '.$renum_id,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $renum_id = false;
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ສ້າງໃບຮັບເຄື່ອງນຳລູກຄ້າ error: '.$message,'error');
        }

        $response = [
            'renum_id' => $renum_id,
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function update($id, Request $request)
    {
        if(check_roles('repaire_edit')){
        // start permission

                try {


                        $repaire = Repaire::where('renum_id',$id);
                        $repaire2 = Repaire::where('renum_id',$id)->get();
                        foreach($repaire2 as $re)
                         {
                             if($re['images']!=''){
                                if($request->images != $re['images']){
                                    if(file_exists('images/repaire/'.$re['images'])){
                                    unlink('images/repaire/'.$re['images']);
                                    }
                                }
                            }
                         }

                        $repaire->update([
                            'customer_id' => $request->customer_id,
                            'user_id' => $request->user_id,
                            'equiment_type_id' => $request->equiment_type_id,
                            'user_id' => $request->user_id,
                            'detail' => $request->detail,
                            'images' => $request->images,
                            'cause_detail' => $request->cause_detail,
                            'customer_name' => $request->customer_name,
                            //'customer_sex' => $request->customer_sex,
                            'customer_tel' => $request->customer_tel,
                            'customer_address' => $request->customer_address,
                            'customer_type' => $request->customer_type,
                            'other_customer' => $request->other_customer,
                            'all_price' => $request->all_price,
                            'list_status' => $request->list_status,
                            'status_now' => $request->status_now,
                            'work_status' => 'success',
                        ]);

                        foreach($request->ListBilldata[0]['db_product'] as $cinstore){
                            Product::where('product_id',$cinstore['product_id'])->update([ 'in_store' => $cinstore['in_store'], 'in_store_pack' => $cinstore['in_store_pack']]);
                          }
        

                        $rlist = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->get();
                        $billslist = false;
                        $listbills_old = array();
                        $listbills_new = array();
                        if($repaire){
                            foreach($request->list_repaire as $lb){
                                // add new list bill to array
                                array_push($listbills_new,$lb['id']);
                                if(count($rlist)>0){
                                    foreach($rlist as $b){
                                        if($b['renum_id']==$id && $b['renum_id']!='' && $b['bill_list_id']==$lb['id'] && $b['bill_list_id']!=''){
                                                
                                                    $blistup = ListRepaireItem::where('renum_id',$id)->where('bill_list_id',$lb['id']);
                                                    $blistup->update([
                                                        'count' => (int)$lb['count'],
                                                        'credit' => (int)$lb['price'],
                                                        'work_status'=> 'success'
                                                    ]);
                                        
                                                // updat trn list

                                        }
                                        // add old list bill to array
                                        array_push($listbills_old,$b['bill_list_id']);
                                    }

                                    //  ມີການເພີ່ມລາຍການ ໃໝ່ໃນໃບບິນ ໃຫ້ເພີ່ມເຂົ້າ
                                    if(!in_array($lb['id'] , $listbills_old)){

                                        $billslist_upnew = new ListRepaireItem();
                                        $billslist_upnew->renum_id = $id;
                                        $billslist_upnew->name = $lb['product_name'];
                                        // $billslist_upnew->detail = null;
                                        $billslist_upnew->bill_type = $lb['bill_type'];
                                        $billslist_upnew->product_id = $lb['product_id'];
                                        $billslist_upnew->bill_list_id = $lb['id'];
                                        $billslist_upnew->barcode = $lb['barcode'];
                                        $billslist_upnew->count = $lb['count'];
                                        $billslist_upnew->credit = $lb['price'];
                                        $billslist_upnew->work_status = 'success';
                                        $billslist_upnew->save();
                                        //  ບັນທຶກລົງລາຍການ ເຄື່ອນໄຫວບັນຊີ

                                        save_logs('ອັບເດດໃບບິນ ເລກທີ່: '.$id.' ເພີ່ມລາຍການໃໝ່: '.$lb['product_name'],'success');
                                    }



                                }
                                else{

                                $billslist = new ListRepaireItem();
                                        $billslist->renum_id = $id;
                                        $billslist->name = $lb['product_name'];
                                        // $billslist->detail = null;
                                        $billslist->bill_type = $lb['bill_type'];
                                        $billslist->product_id = $lb['product_id'];
                                        $billslist->bill_list_id = $lb['id'];
                                        $billslist->barcode = $lb['barcode'];
                                        $billslist->count = $lb['count'];
                                        $billslist->credit = $lb['price'];
                                        $billslist->work_status = 'success';
                                        $billslist->save();

                                }


                                /// update list item

                                $re_list_up = ListRepaireItem::where('renum_id',$id)->where('work_status','success')->get();
                                foreach($re_list_up as $ql){
                                    if($lb['id']==$ql['bill_list_id']){
                                        ListRepaireItem::where('renum_id',$id)->where('bill_list_id',$ql['bill_list_id'])->where('work_status','success')
                                        ->update([
                                        'name' => $lb['product_name'],
                                        'count' => $lb['count'],
                                        'credit' => $lb['price'],
                                        'work_status'=> 'success'
                                    ]);
                                }
                                }

                             }

                             //  ກວດຊອບ ລາຍການໃບບິນ ທີ່ຖຶກລຶບອກ
                            $checkDellistbill = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->get();
                            foreach($checkDellistbill as $b){
                                if(!in_array($b['bill_list_id'] , $listbills_new)){
                                   //  echo $b['bill_list_id']."-";

                                            // ລາຍການທີ່ຖຶກລຶບ ໃຫ້ສົ່ງຄືນ Store
                                            // ຂໍ້ມູນທີ່ຕ້ອງການ barcode, product_id, count
                                            // barcode ໄປດຶງຂໍ້ມູນຈາກ table barcde ເພື່ອຊອກຫາວ່າສິນຄ້າເປັນ pack ຫຼື unit
                                            // product_id ໄປດຶງຂໍ້ມູນຈາກ table product ເພື່ອຊອກຫາຕົວຄູນ ຂອງປະເພດ pack unit
                                            // ຈາກນັ້ນ ທຳການຄຳນວນ ແລ້ວອັບເດດ table product
                                        if($b['bill_type']=='product'){
                                            $barcode_getunit = Barcode::where('barcode',$b['barcode'])->get();
                                            $getunit = Unit::where('id',$barcode_getunit[0]['unit'])->get();
                                            $product_getunittype = Product::where('product_id',$b['product_id'])->get();


                                           // echo $getunit[0]['unit_to']."-";
                                            //echo $product_getunittype[0]['in_store_pack'];

                                            // if($getunit[0]['unit_to']==1){ $unit = 'unit'; } else { $unit = 'pack'; }
                                            $product_unit_type = $product_getunittype[0]['product_unit_type'];
                                            $count = $b['count'];

                                            if($getunit[0]['unit_to']==1){
                                                // unit
                                                $in_store = (int)$product_getunittype[0]['in_store']+(int)$count;
                                                $in_store_pack = (int)$product_getunittype[0]['in_store_pack']+((int)$count*(int)$product_unit_type);
                                                Product::where('product_id',$b['product_id'])->update([ 'in_store'=> $in_store, 'in_store_pack'=> $in_store_pack ]);

                                            } else {
                                                // pack
                                                $in_store_pack = (int)$product_getunittype[0]['in_store_pack']+(int)$count;
                                                $in_store = floor((int)$in_store_pack/(int)$product_unit_type);
                                                Product::where('product_id',$b['product_id'])->update([ 'in_store'=> $in_store, 'in_store_pack'=> $in_store_pack ]);

                                            }
                                        }

                                            //  reject

                                            $blistup = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->where('bill_list_id',$b['bill_list_id']);
                                            $blistup->update([ 'work_status'=> 'reject' ]);

                                           // updat trn list

                                        //    $blistup = AccTRN::where('work_status','success')->where('bill_id',$id)->where('bill_list_id',$b['bill_list_id']);
                                        //     $blistup->update([ 'work_status'=> 'reject' ]);
                                           // log
                                           save_logs('ຍົກເລີກລາຍການໃນໃບບິນ (reject) ເລກທີ່: '.$id.' ລາຍການ: '.$b['name'],'success');
                             }
                         }

                            }

                        $success = true;
                        $message = 'ການບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

                        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                        save_logs('ອັບເດດ ໃບຮັບເຄື່ອງນຳລູກຄ້າ ເລກທີ່: '.$id,'success');

                    } catch (\Illuminate\Database\QueryException $ex) {
                        $success = false;
                        $message = $ex->getMessage();
                        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                        save_logs('ອັບເດດ ໃບຮັບເຄື່ອງນຳລູກຄ້າ error: '.$message,'error');
                    }

                    $response = [
                        'success' => $success,
                        'message' => $message,
                    ];
                   return response()->json($response);


                    // end permissions
                } else {
                    $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
                    return response()->json($response);
                }

       // return response()->json('successfully updated');
    }
    public function delete($id)
    {
        if(check_roles('repaire_remove')){
        // start permission

        // $repaire = Repaire::where('renum_id',$id);
        // $repaire2 = Repaire::where('renum_id',$id)->get();
        //                 foreach($repaire2 as $re)
        //                  {
        //                     if($re['images']!=''){
        //                             if(file_exists('images/repaire/'.$re['images'])){
        //                             unlink('images/repaire/'.$re['images']);
        //                             }
        //                         }
        //                  }
        // $repaire->delete();
        // ListRepaireItem::where('renum_id',$id)->delete();

        $checkDellistbill = ListRepaireItem::where('work_status','success')->where('renum_id',$id)->where('barcode','!=','')->get();
        foreach($checkDellistbill as $b){

            $barcode_getunit = Barcode::where('barcode',$b['barcode'])->get();
            $getunit = Unit::where('id',$barcode_getunit[0]['unit'])->get();
            $product_getunittype = Product::where('product_id',$b['product_id'])->get();


            $product_unit_type = $product_getunittype[0]['product_unit_type'];
            $count = $b['count'];

            if($getunit[0]['unit_to']==1){
                // unit
                $in_store = (int)$product_getunittype[0]['in_store']+(int)$count;
                $in_store_pack = (int)$product_getunittype[0]['in_store_pack']+((int)$count*(int)$product_unit_type);
                Product::where('product_id',$b['product_id'])->update([ 'in_store'=> $in_store, 'in_store_pack'=> $in_store_pack ]);

            } else {
                // pack
                $in_store_pack = (int)$product_getunittype[0]['in_store_pack']+(int)$count;
                $in_store = floor((int)$in_store_pack/(int)$product_unit_type);
                Product::where('product_id',$b['product_id'])->update([ 'in_store'=> $in_store, 'in_store_pack'=> $in_store_pack ]);

            }
        }


        Repaire::where('renum_id',$id)->update([ 'work_status'=> 'reject' ]);
        ListRepaireItem::where('renum_id',$id)->update([ 'work_status'=> 'reject' ]);

        $success = true;
        $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບອອກແລ້ວ!';

        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ລຶບໃບຮັບເຄື່ອງນຳລູກຄ້າ ເລກທີ່: '.$id.' ອອກຈາກລະບົບ','success');

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function deleteImage($id)
    {

        if(check_roles('repaire_remove')){
            // start permission

        $image = \Request::post('image');
       // return $image;

        $repaire = Repaire::where('renum_id',$id);
        $repaire2 = Repaire::where('renum_id',$id)->get();
                        foreach($repaire2 as $re)
                         {
                            if($re['images']==''){
                                $img='none';
                                if($image){ $img=$image; }
                             } else { $img=$re['images']; }

                             if(file_exists('images/repaire/'.$img)){
                                unlink('images/repaire/'.$img);
                            }
                         }
        $success = true;
        $message = 'Delete successfully';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function rece($id)
    {
       
        $repaire = Repaire::where('renum_id',$id)
        ->leftJoin('users','users.id','=','repaires.user_id')
        ->select('repaires.*','users.name','users.last_name','users.sex','users.tel')
        ->get();
        $listrepaire = ListRepaireItem::where('renum_id',$id)->get();

        $date;
            foreach($repaire as $d){
                $date = $d->created_at;
            }

            $date = explode(' ',$date);
            $new_date =  explode('-',$date[0]);
            $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];

        return view('bill/rece')->with('repaire',$repaire)->with('listrepaire',$listrepaire)->with('reid',$id)->with('date', $tr_date )->with('time', $date[1] );
    }

    public function customer_view($id){
        $repaire = Repaire::where('renum_id',$id)
        ->leftJoin('users','users.id','=','repaires.user_id')
        ->select('repaires.*','users.name','users.last_name','users.sex','users.tel')
        ->get();
        $listrepaire = ListRepaireItem::where('renum_id',$id)->get();

        $date;
            foreach($repaire as $d){
                $date = $d->created_at;
            }

            $date = explode(' ',$date);
            $new_date =  explode('-',$date[0]);
            $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];

        return view('bill/customer_repaire')->with('repaire',$repaire)->with('listrepaire',$listrepaire)->with('reid',$id)->with('date', $tr_date )->with('time', $date[1]);
    }
}
