<?php

namespace App\Http\Controllers\API;
use App\Models\Quotation;
use App\Models\QuotationList;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class QuotationListController extends Controller
{
    //
    public function index()
    {
        if(check_roles('bill_access')){

        $bid = \Request::get('quonum_id');
        $quolist = QuotationList::where('quonum_id',$bid)->get();
        //return array_reverse($billslist);
        return response()->json($quolist);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function add(Request $request)
    {

        if(check_roles('bill_add')){
            // start permissions

        try {


            $quolist = QuotationList::where('quonum_id',$request->quonum_id)->get();
           
            if(count($quolist)>0){

                $insert = true;

                foreach($quolist as $b){
                    if($b['product_id']!=null && $b['product_id']!=''){
                    if($b['product_id'] == $request->product_id){
                        $quotiup = QuotationList::where('quonum_id',$request->quonum_id)->where('product_id',$request->product_id);
                        $quotiup->update([
                            'count' => (int)$b['count']+(int)$request->count,
                        ]);
                        $success = true;
                        $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                        $insert = false;
                        break;
                       }
                    }
                }

                if($insert){
                    if($request->name!='' && $request->credit!=''){
                        $billslist = new QuotationList();
                        $billslist->quonum_id = $request->quonum_id;
                        $billslist->name = $request->name;
                        $billslist->detail = $request->detail;
                        $billslist->quo_type = $request->quo_type;
                        $billslist->product_id = $request->product_id;
                        $billslist->count = $request->count;
                        $billslist->credit = $request->credit;
                        $billslist->save();
                        $success = true;
                        $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                        }
                        else {
                            $success = false;
                        $message = 'ບໍ່ອານຸຍາດໃຫ້ບັນທຶກ!';
                        }
                }

            }
            else {

                if($request->name!='' && $request->credit!=''){
                $quolist = new QuotationList();
                $quolist->quonum_id = $request->quonum_id;
                $quolist->name = $request->name;
                $quolist->detail = $request->detail;
                $quolist->quo_type = $request->quo_type;
                $quolist->product_id = $request->product_id;
                $quolist->count = $request->count;
                $quolist->credit = $request->credit;
                $quolist->save();
                $success = true;
                $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                }
                else {
                    $success = false;
                $message = 'ບໍ່ອານຸຍາດໃຫ້ບັນທຶກ!';
                }
            } 

   
            $quolist = QuotationList::where('quonum_id',$request->quonum_id)->get();
            $que = $quolist;
        
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '[]';
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        /*
        try {
        $quolist = new QuotationList();
            $quolist->quonum_id = $request->quonum_id;
            $quolist->name = $request->name;
            $quolist->detail = $request->detail;
            $quolist->count = $request->count;
            $quolist->credit = $request->credit;
            $quolist->save();
            $success = true;
            $message = 'add bills list successfully';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        */

        //end permissions

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {

        if(check_roles('bill_edit')){
            // start permissions 


        try {
            $billslist = QuotationList::find($id);
            $billslist->update($request->all([
                $billslist->name = $request->name,
                $billslist->detail = $request->detail,
                $billslist->count = $request->count,
                $billslist->credit = $request->credit,
                $billslist->quo_type = $request->quo_type
            ]));


            $quolist = QuotationList::where('quonum_id',$request->quonum_id)->get();
            $que = $quolist;

            $success = true;
            $message = 'ອັບເດດຂໍ້ມູນ ສຳເລັດ!';
            //$que = $que;
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '[]';
        }

        

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function delete($id)
    {

        if(check_roles('bill_remove')){
            /// start permissions

        //ListRepaireItem::where('billnum_id',$id)->delete();
        //BillsList::where('billnum_id',$id)->delete();
        
        $litem = QuotationList::find($id);
        $litem->delete();

        $success = true;
        $message = 'Delete successfully';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

         // end permissions 
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
        
    }
}
