<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\STORE\Product;
use Illuminate\Http\Request;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use PDF;

class PrintController extends Controller
{
    //
    public function printlabel($id){
      //  return view('bill/rece')->with('repaire',$repaire)


      $db_barcode = Barcode::where('barcode','=',$id)
      ->select('pbc_id','option_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
      ->get();

      $product_id = $db_barcode[0]->product_id;
      $option_id = $db_barcode[0]->option_id;

      $proa = Product::where('product_id','=',$product_id)
      ->select('products.*')
      ->get();

      $option = ProductOption::where('product_id','=',$product_id)
      ->select('option_id','option_name')
      ->get();
      $option_name = '';
      foreach($option as $op){
        if($op['option_id']!=''){
          if($op['option_id']==$option_id ){
            $option_name = $op['option_name'];
          }
        }
      }


      if(count($proa)<1){
        return view('print/nodata');
      }
      else {

       
        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
        save_logs('ພິມສະຕິກເກີ້ລາຄາສິນຄ້າ: '.$proa[0]->product_name,'success');

        return view('print/print')->with('result',$proa)->with('db_barcode',$db_barcode)->with('option',$option)->with('option_name',$option_name);
      }


    }

    public function printlistpro(Request $request){
         
          $fillter = \Request::get('filtter');
          if($fillter!='null'){
          $ses_id = explode('|',$fillter)[0];
          $cat_id = explode('|',$fillter)[1];
          $cat_sub_id = explode('|',$fillter)[2];

            if($cat_sub_id){
              $product = Product::where('session_id',$ses_id)->where('category_id',$cat_id)->where('sub_category_id',$cat_sub_id)->orderBy('created_at', 'desc')->get();
            } else if($cat_id){
              $product = Product::where('session_id',$ses_id)->where('category_id',$cat_id)->orderBy('created_at', 'desc')->get();
            } else if($ses_id){
              $product = Product::where('session_id',$ses_id)->orderBy('created_at', 'desc')->get();
            } else {
              $product = Product::orderBy('created_at', 'desc')->get();
              
            }

          } else {
            $product = Product::orderBy('created_at', 'desc')->get();
          }
          
          $response = [
            'data_list_product' => $product
        ];
        return response()->json($response);

         // dd($product);
          
   
          // $data = [
          //     'title' => 'ລາຄາໝຶກອັບເດດລ່າສຸດ',
          //     'date' => date('m/d/Y'),
          //     'product' => $product
          // ];
          //return view('myPDF', $data);
       // $pdf = PDF::loadView('myPDF', $data);
        //dd($pdf);
        //return $pdf->download('mypdf_page.pdf', 'UTF-8');

        // $path = public_path().'/pdf';
        // $pdf = PDF::loadView('myPDF', $data);
        // $pdf->save($path.'/my_pdf_name.pdf', 'UTF-8');
        // return response()->download($path.'/my_pdf_name.pdf');
    }
}
