<?php

namespace App\Http\Controllers\API;
use App\Models\ListRepaireItem;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ListRepaireItemController extends Controller
{
    //
    public function index()
    {
        if(check_roles('repaire_assess')){


            $bid = \Request::get('renum_id');
            $litem = ListRepaireItem::where('work_status','success')->where('renum_id',$bid)->get();
            return response()->json($litem);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function add(Request $request)
    {
        if(check_roles('repaire_add')){
        // start permissions

        try {
        $litem = new ListRepaireItem();
            $litem->renum_id = $request->renum_id;
            $litem->name = $request->name;
            $litem->count = $request->count;
            $litem->credit = $request->credit;
            $litem->product_id = $request->product_id;
            $litem->bill_type = $request->bill_type;
            $litem->work_status = 'success';
            $litem->save();
            $success = true;
            $message = 'add successfully';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        /// end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {

        if(check_roles('repaire_edit')){
        // start permissions 
        try {
            $litem = ListRepaireItem::find($id);
            $litem->update($request->all([
                $litem->name = $request->name,
                $litem->count = $request->count,
                $litem->credit = $request->credit,
                $litem->product_id = $request->product_id,
                $litem->bill_type = $request->bill_type,
                $litem->work_status = 'success',
            ]));

            $success = true;
            $message = 'successfully';
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions 
    } else {
        $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
        return response()->json($response);
    }

    }

    public function delete($id)
    {
        if(check_roles('repaire_remove')){
        // start permissions 
        //ListRepaireItem::where('billnum_id',$id)->delete();
        //BillsList::where('billnum_id',$id)->delete();
        
      //  $litem = ListRepaireItem::find($id);
      //  $litem->delete();
        ListRepaireItem::where('id',$id)->update([ 'work_status'=> 'reject' ]);

        $success = true;
        $message = 'Delete successfully';

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

        // end permission 
    } else {
        $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
        return response()->json($response);
    }
    }
}
