<?php

namespace App\Http\Controllers\API;

use Session;
use App\Models\Bills;
use App\Models\BillsList;
use App\Models\Quotation;
use App\Models\QuotationList;
use App\Models\BillSetting;
use App\Models\CustomerOffice;
use App\Models\Repaire;
use App\Models\ListRepaireItem;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use PDF;

class GenPDFController extends Controller
{
    public function index()
    {
        $bill = Bills::all();
        return view('GenPDF/GenPDF')->with('bills',$bill);
    }

    public function create()
    {
        $bill = Bills::all();
        view()->share('bills',$bill);
        $pdf = PDF::loadView('GenPDF/GenPDF',$bill);
        $fileName = 'aaaa.' . 'pdf' ;
        $pdf->save('file/' . $fileName);
        return $pdf->download('pdf_file.pdf');

        
    }

    public function printbill($id)
    {

       $officeall = CustomerOffice::all();

       $billlist = BillsList::where('billnum_id',$id)->where('work_status','success')->get();
       $billsetting = BillSetting::all();

       $bills = Bills::where('bills.billnum_id',$id)->where('work_status','success')
            ->leftJoin('customers', 'customers.id', '=', 'bills.customer_id')
            ->select('customers.name','customers.sex','customers.address','customers.last_name','customers.tel','bills.customer_id','bills.office_id','bills.customer_id','bills.customer_type','bills.customer_detail','bills.customer_name','bills.customer_tel','bills.customer_address','bills.signed','bills.tax','bills.discut','bills.created_at',)
            ->get();
            $date;
            foreach($bills as $d){
                $date = $d->created_at;
            }
            
            $date = explode(' ',$date);
            $new_date =  explode('-',$date[0]);
            $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];
            
            if(check_roles('dashboard_access')){
                $test = 'ok';
            } else {
                $test = 'no';
            }

            


        return view('bill/printbill')->with('Bill_num',$id)->with('BillsList', $billlist)->with('Bills', $bills )->with('OfficeAll', $officeall )->with('date', $tr_date )->with('time', $date[1] )->with('billsetting', $billsetting )->with('test', $test );
    } 

    public function printbillmini($id)
    {

       $officeall = CustomerOffice::all();

       $billlist = BillsList::where('billnum_id',$id)->where('work_status','success')->get();
       $billsetting = BillSetting::all();

       $bills = Bills::where('bills.billnum_id',$id)->where('work_status','success')
            ->leftJoin('customers', 'customers.id', '=', 'bills.customer_id')
            ->select('customers.name','customers.sex','customers.address','customers.last_name','customers.tel','bills.customer_id','bills.office_id','bills.customer_id','bills.customer_type','bills.customer_detail','bills.customer_name','bills.customer_tel','bills.customer_address','bills.signed','bills.tax','bills.discut','bills.created_at',)
            ->get();
            $date;
            foreach($bills as $d){
                $date = $d->created_at;
            }

            $date = explode(' ',$date);
            $new_date =  explode('-',$date[0]);
            $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];


        return view('bill/printbill80')->with('Bill_num',$id)->with('BillsList', $billlist)->with('Bills', $bills )->with('OfficeAll', $officeall )->with('date', $tr_date )->with('time', $date[1] )->with('billsetting', $billsetting );
    }

    public function printquotation($id)
    {

       $officeall = CustomerOffice::all();

       $billlist = QuotationList::where('quonum_id',$id)->where('work_status','success')->get();
       $billsetting = BillSetting::all();
       $bills = Quotation::where('quotations.quonum_id',$id)
            ->leftJoin('customers', 'customers.id', '=', 'quotations.customer_id')
            ->select('customers.name','customers.sex','customers.address','customers.last_name','customers.tel','quotations.customer_id','quotations.office_id','quotations.customer_id','quotations.customer_type','quotations.customer_detail','quotations.customer_name','quotations.customer_tel','quotations.customer_address','quotations.signed','quotations.tax','quotations.discut','quotations.created_at',)
            ->get();
            $date;
            foreach($bills as $d){
                $date = $d->created_at;
            }

            $date = explode(' ',$date);
            $new_date =  explode('-',$date[0]);
            $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];


        return view('bill/printquotation')->with('Bill_num',$id)->with('BillsList', $billlist)->with('Bills', $bills )->with('OfficeAll', $officeall )->with('date', $tr_date )->with('time', $date[1] )->with('billsetting', $billsetting );
    }

    // public function rece($id)
    // {
       
    //     $repaire = Repaire::where('renum_id',$id)
    //     ->leftJoin('users','users.id','=','repaires.user_id')
    //     ->select('repaires.*','users.name','users.last_name','users.sex','users.tel')
    //     ->get();
    //     $listrepaire = ListRepaireItem::where('renum_id',$id)->get();

    //     $date;
    //         foreach($repaire as $d){
    //             $date = $d->created_at;
    //         }

    //         $date = explode(' ',$date);
    //         $new_date =  explode('-',$date[0]);
    //         $tr_date = $new_date[2].'/'.$new_date[1].'/'.$new_date[0];

    //     return view('bill/rece')->with('repaire',$repaire)->with('listrepaire',$listrepaire)->with('reid',$id)->with('date', $tr_date )->with('time', $date[1] );
    // }
}