<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Bills;
use App\Models\BillsList;
use App\Models\Repaire;
use App\Models\STORE\Store;
use App\Models\ACC\AccTRN;
use App\Models\ACC\Acc;
use App\Models\ACC\AccCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    //
    

    public function carddash(){
        
        function getvalue_last_month($this_month,$last_month){
            if($this_month!=0 && $last_month!=0){
                if($this_month==0 && $last_month!=0){
                    return -100;
                }elseif($this_month!=0 && $last_month==0){
                    return 100;
                }else{
                    return ceil(($this_month*100)/$last_month)-100;
                 
                }
            } else {
                return 0;
            }
        }

      
        //return Auth::user()->user_type;
        //return Auth::user()->id;

        if(Auth::user()->user_type=='admin'){
            $last_month = date('m', strtotime("-1 month"));
            /// ຍອດບໍລິການ 
            //whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()] )
            $AllService = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->sum('count');
            //$service_this_lastmonth = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', Carbon::now()->subMonth()->endOfMonth())->sum('count');

            $service_this_lastmonth = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->sum('count');
            $service_this_month = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->sum('count');
            //$service_this_month = 0;
            //echo $service_this_month;
            //$last_m;
            //if($service_this_month==0 && $service_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($service_this_month*100)/$service_this_lastmonth); }
            $last_month_sr = getvalue_last_month($service_this_month,$service_this_lastmonth);
            //$last_month_sr = ceil(($service_this_month*100)/$service_this_lastmonth)-100;
            //echo $last_month_sr;
            /// ລາຍຮັບ
            $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
            $re = array();
            foreach($acc as $acc_id){
                    array_push($re,$acc_id['acc_id']);
            }

            $NeeRevenue = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('dr','=','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('cr','=','411')->sum('sum'); // ໜີ້ຕ້ອງຮັບ
            //$Neerevenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->where('dr','=','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->where('cr','=','411')->sum('sum');
            $Neerevenue_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->where('dr','=','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->where('cr','=','411')->sum('sum');
            $Neerevenue_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->where('dr','=','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', date('m'))->where('cr','=','411')->sum('sum');

            $AllRevenue = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('cr',$re)->sum('sum')-$NeeRevenue;
            //$revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->whereIn('cr',$re)->sum('sum')-$Neerevenue_this_lastmonth;
            $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereIn('cr',$re)->sum('sum')-$Neerevenue_this_lastmonth;
            $revenue_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('cr',$re)->sum('sum')-$Neerevenue_this_month;
            
           
            //$last_m;
            //if($revenue_this_month==0 && $revenue_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($revenue_this_month*100)/$revenue_this_lastmonth); }
            //echo Carbon::now()->subMonth()->startOfMonth().'==='.Carbon::now()->subMonth()->endOfMonth().'***'.Carbon::now()->month;
            $last_month_re = getvalue_last_month($revenue_this_month,$revenue_this_lastmonth);

            /// ລາຍຈ່າຍ
            $acc = Acc::where('acc_cat_id', '=', '6')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
            $ex = array();
            foreach($acc as $acc_id){
                    array_push($ex,$acc_id['acc_id']);
            }

            $AllExpenses = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('dr',$ex)->sum('sum');
            $expenses_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereIn('dr',$ex)->sum('sum');
            $expenses_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('dr',$ex)->sum('sum');
            
            //$last_m;
            //if($expenses_this_month==0 && $expenses_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($expenses_this_month*100)/$expenses_this_lastmonth); }
            $last_month_ex = getvalue_last_month($expenses_this_month,$expenses_this_lastmonth);

        // echo $expenses_this_month;
            /// ວຽກທີ່ຄ້າງ
            $repa = array('a7','a8','a9');
            $AllRepaire = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereNotIn('status_now',$repa)->count();
            $repaire_this_lastmonth = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereNotIn('status_now',$repa)->count();
            $repaire_this_month = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereNotIn('status_now',$repa)->count();
            if($repaire_this_lastmonth<=0){ $repaire_this_lastmonth = 1;}

            //$last_m;
            //if($repaire_this_month==0 && $repaire_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($repaire_this_month*100)/$repaire_this_lastmonth); }
            $last_month_repa = getvalue_last_month($repaire_this_month,$repaire_this_lastmonth);

            //return $AllRepaire;


            $response = [
                'total_service' => $AllService,
                'service_this_month' => $service_this_month,
                'last_month_sr' => $last_month_sr,
                'allrevenue' => $AllRevenue,
                'revenue_this_month' => $revenue_this_month,
                'last_month_re' => $last_month_re,
                'allexpenses' => $AllExpenses,
                'expenses_thismonth' => $expenses_this_month,
                'last_month_ex' => $last_month_ex,
                'allrepaire' => $AllRepaire,
                'repaire_thismonth' => $repaire_this_month,
                'last_month_repa' => $last_month_repa
                //'last_month_repa' => -34

            ];
        } else {
            $last_month = date('m', strtotime("-1 month"));
            $user_id = Auth::user()->id;
            /// ຍອດບໍລິການ 
            //whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()] )
            $AllService = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->sum('count');
            //$service_this_lastmonth = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', Carbon::now()->subMonth()->endOfMonth())->sum('count');

            $service_this_lastmonth = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->sum('count');
            $service_this_month = BillsList::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->sum('count');
            //$service_this_month = 0;
            //echo $service_this_month;
            //return $service_this_month;
            //$last_month_sr = ceil(($service_this_month*100)/$service_this_lastmonth)-100;
            
            $last_month_sr = getvalue_last_month($service_this_month,$service_this_lastmonth);
            //echo $last_month_sr;
            /// ລາຍຮັບ
            $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
            $re = array();
            foreach($acc as $acc_id){
                    array_push($re,$acc_id['acc_id']);
            }

            $NeeRevenue = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('dr','=','411')->where('user_id',$user_id)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('cr','=','411')->where('user_id',$user_id)->sum('sum'); // ໜີ້ຕ້ອງຮັບ
            $Neerevenue_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->where('dr','=','411')->where('user_id',$user_id)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereBetween('created_at', [Carbon::now()->subMonth()->startOfMonth(), Carbon::now()->subMonth()->endOfMonth()])->where('cr','=','411')->where('user_id',$user_id)->sum('sum');
            $Neerevenue_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->where('dr','=','411')->where('user_id',$user_id)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', date('m'))->where('cr','=','411')->where('user_id',$user_id)->sum('sum');

            $AllRevenue = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('cr',$re)->where('user_id',$user_id)->sum('sum')-$NeeRevenue;
            $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereIn('cr',$re)->where('user_id',$user_id)->sum('sum')-$Neerevenue_this_lastmonth;
            $revenue_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('cr',$re)->where('user_id',$user_id)->sum('sum')-$Neerevenue_this_month;

            //$last_m;
            //if($revenue_this_month==0 || $revenue_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($revenue_this_month*100)/$revenue_this_lastmonth); }
            $last_month_re = getvalue_last_month($revenue_this_month,$revenue_this_lastmonth);

            /// ລາຍຈ່າຍ
            $acc = Acc::where('acc_cat_id', '=', '6')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
            $ex = array();
            foreach($acc as $acc_id){
                    array_push($ex,$acc_id['acc_id']);
            }

            $AllExpenses = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('dr',$ex)->where('user_id',$user_id)->sum('sum');
            $expenses_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereIn('dr',$ex)->where('user_id',$user_id)->sum('sum');
            $expenses_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('dr',$ex)->where('user_id',$user_id)->sum('sum');
            
            //$last_m;
            //if($expenses_this_month==0 || $expenses_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($expenses_this_month*100)/$expenses_this_lastmonth); }
            $last_month_ex = getvalue_last_month($expenses_this_month,$expenses_this_lastmonth);

        // echo $expenses_this_month;
            /// ວຽກທີ່ຄ້າງ
            $repa = array('a7','a8','a9');
            $AllRepaire = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereNotIn('status_now',$repa)->where('user_id',$user_id)->count();
            $repaire_this_lastmonth = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month-1)->whereNotIn('status_now',$repa)->where('user_id',$user_id)->count();
            $repaire_this_month = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereNotIn('status_now',$repa)->where('user_id',$user_id)->count();
            if($repaire_this_lastmonth<=0){ $repaire_this_lastmonth = 1;}

            //$last_m;
            //if($repaire_this_month==0 || $repaire_this_lastmonth==0){ $last_m = 0; } else { $last_m = ceil(($repaire_this_month*100)/$repaire_this_lastmonth); }
            $last_month_repa = getvalue_last_month($repaire_this_month,$repaire_this_lastmonth);

            //return $AllRepaire;


            $response = [
                'total_service' => $AllService,
                'service_this_month' => $service_this_month,
                'last_month_sr' => $last_month_sr,
                'allrevenue' => $AllRevenue,
                'revenue_this_month' => $revenue_this_month,
                'last_month_re' => $last_month_re,
                'allexpenses' => $AllExpenses,
                'expenses_thismonth' => $expenses_this_month,
                'last_month_ex' => $last_month_ex,
                'allrepaire' => $AllRepaire,
                'repaire_thismonth' => $repaire_this_month,
                'last_month_repa' => $last_month_repa
                //'last_month_repa' => -34

            ];
        }

        return response()->json($response);
    }

    public function get_service_bar(){

        $m1 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->count();
        $m2 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->count();
        $m3 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->count();
        $m4 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->count();
        $m5 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->count();
        $m6 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->count();
        $m7 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->count();
        $m8 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->count();
        $m9 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->count();
        $m10 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->count();
        $m11 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->count();
        $m12 = Repaire::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->count();

        $bar = array('ມັງກອນ' => $m1, 'ກຸມພາ' => $m2, 'ມີນາ' => $m3, 'ເມສາ' => $m4, 'ພຶດສະພາ' => $m5, 'ມິຖຸນາ' => $m6, 'ກໍລະກົດ' => $m7, 'ສິງຫາ' => $m8, 'ກັນຍາ' => $m9, 'ຕຸລາ' => $m10, 'ພະຈິກ' => $m11, 'ທັນວາ' => $m12);

        $response = [
            'data_bar' => $bar
        ];
        return response()->json($response);

    }

    public function get_revenue_expanses(){

        $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
        $re = array();
        foreach($acc as $acc_id){
                array_push($re,$acc_id['acc_id']);
        }

        $m1 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->whereIn('cr',$re)->sum('sum');
        $m2 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->whereIn('cr',$re)->sum('sum');
        $m3 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->whereIn('cr',$re)->sum('sum');
        $m4 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->whereIn('cr',$re)->sum('sum');
        $m5 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->whereIn('cr',$re)->sum('sum');
        $m6 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->whereIn('cr',$re)->sum('sum');
        $m7 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->whereIn('cr',$re)->sum('sum');
        $m8 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->whereIn('cr',$re)->sum('sum');
        $m9 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->whereIn('cr',$re)->sum('sum');
        $m10 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->whereIn('cr',$re)->sum('sum');
        $m11 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->whereIn('cr',$re)->sum('sum');
        $m12 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->whereIn('cr',$re)->sum('sum');

        // ໜີ້ຕ້ອງຮັບ ເພີ່ມຂື້ນເບື້ອງໜີ້ ໜີ້ຕ້ອງຮັບທັງໝົດ = ໜີ້ຕ້ອງຮັບ(ໜີ້) - ໜີ້ຕ້ອງຮັຍ(ມີ)
        $nh1 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->where('cr','=','411')->sum('sum');
        $nh2 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->where('cr','=','411')->sum('sum');
        $nh3 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->where('cr','=','411')->sum('sum');
        $nh4 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->where('dr','=','411')->sum('sum');
        $nh5 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->where('cr','=','411')->sum('sum');
        $nh6 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->where('cr','=','411')->sum('sum');
        $nh7 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->where('cr','=','411')->sum('sum');
        $nh8 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->where('cr','=','411')->sum('sum');
        $nh9 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->where('cr','=','411')->sum('sum');
        $nh10 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->where('cr','=','411')->sum('sum');
        $nh11 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->where('cr','=','411')->sum('sum');
        $nh12 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->where('dr','=','411')->sum('sum')-AccTRN::whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->where('cr','=','411')->sum('sum');




        //return $nh10;
       // $reve = array('ມັງກອນ' => $m1, 'ກຸມພາ' => $m2, 'ມີນາ' => $m3, 'ເມສາ' => $m4, 'ພຶດສະພາ' => $m5, 'ມິຖຸນາ' => $m6, 'ກໍລະກົດ' => $m7, 'ສິງຫາ' => $m8, 'ກັນຍາ' => number_format($m9, 0, ',', '.'), 'ຕຸລາ' => number_format($m10, 0, ',', '.'), 'ພະຈິກ' => $m11, 'ທັນວາ' => $m12);
        $reve = array('ມັງກອນ' => round(($m1-$nh1)/1000000,2), 'ກຸມພາ' => round(($m2-$nh2)/1000000,2), 'ມີນາ' => round(($m3-$nh3)/1000000,2), 'ເມສາ' => round(($m4-$nh4)/1000000,2), 'ພຶດສະພາ' => round(($m5-$nh5)/1000000,2), 'ມິຖຸນາ' => round(($m6-$nh6)/1000000,2), 'ກໍລະກົດ' => round(($m7-$nh7)/1000000,2), 'ສິງຫາ' => round(($m8-$nh8)/1000000,2), 'ກັນຍາ' => round(($m9-$nh9)/1000000,2), 'ຕຸລາ' => round(($m10-$nh10)/1000000,2), 'ພະຈິກ' => round(($m11-$nh11)/1000000,2), 'ທັນວາ' => round(($m12-$nh12)/1000000,2));
       // $reve = array("name"=>"ລາຍຮັບ","data"=>$dataline1);


       $acc = Acc::where('acc_cat_id', '=', '6')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
        $re = array();
        foreach($acc as $acc_id){
                array_push($re,$acc_id['acc_id']);
        }

        $mex1 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->whereIn('dr',$re)->sum('sum');
        $mex2 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->whereIn('dr',$re)->sum('sum');
        $mex3 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->whereIn('dr',$re)->sum('sum');
        $mex4 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->whereIn('dr',$re)->sum('sum');
        $mex5 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->whereIn('dr',$re)->sum('sum');
        $mex6 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->whereIn('dr',$re)->sum('sum');
        $mex7 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->whereIn('dr',$re)->sum('sum');
        $mex8 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->whereIn('dr',$re)->sum('sum');
        $mex9 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->whereIn('dr',$re)->sum('sum');
        $mex10 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->whereIn('dr',$re)->sum('sum');
        $mex11 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->whereIn('dr',$re)->sum('sum');
        $mex12 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->whereIn('dr',$re)->sum('sum');

        $acc = Acc::where('acc_cat_id', '=', '3')->get(); /// ເລືອກບັນຊີ ໜີ້ສິນໝູນວຽນ
        $ne = array();
        foreach($acc as $acc_id){
                //if($acc_id['acc_id']!='411'){
                    array_push($re,$acc_id['acc_id']);
                //}

        }

        $nee1 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->whereIn('cr',$ne)->sum('sum');
        $nee2 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 2)->whereIn('cr',$ne)->sum('sum');
        $nee3 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 3)->whereIn('cr',$ne)->sum('sum');
        $nee4 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 4)->whereIn('cr',$ne)->sum('sum');
        $nee5 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 5)->whereIn('cr',$ne)->sum('sum');
        $nee6 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 6)->whereIn('cr',$ne)->sum('sum');
        $nee7 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 7)->whereIn('cr',$ne)->sum('sum');
        $nee8 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 8)->whereIn('cr',$ne)->sum('sum');
        $nee9 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 9)->whereIn('cr',$ne)->sum('sum');
        $nee10 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 10)->whereIn('cr',$ne)->sum('sum');
        $nee11 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 11)->whereIn('cr',$ne)->sum('sum');
        $nee12 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 12)->whereIn('cr',$ne)->sum('sum');

        
      //  return round(($mex11-$nee11-$nh11)/1000000,2);
       // ລາຍຮັບ  = ລາຍຮັບ - ໜີ້ສິນໝູນວຽນ
        //return $m11;
       // $reve = array('ມັງກອນ' => $m1, 'ກຸມພາ' => $m2, 'ມີນາ' => $m3, 'ເມສາ' => $m4, 'ພຶດສະພາ' => $m5, 'ມິຖຸນາ' => $m6, 'ກໍລະກົດ' => $m7, 'ສິງຫາ' => $m8, 'ກັນຍາ' => number_format($m9, 0, ',', '.'), 'ຕຸລາ' => number_format($m10, 0, ',', '.'), 'ພະຈິກ' => $m11, 'ທັນວາ' => $m12);
       // $exp = array('ມັງກອນ' => round(($mex1-$nee1-$nh1)/1000000,2), 'ກຸມພາ' => round(($mex2-$nee2-$nh2)/1000000,2), 'ມີນາ' => round(($mex3-$nee3-$nh3)/1000000,2), 'ເມສາ' => round(($mex4-$nee4-$nh4)/1000000,2), 'ພຶດສະພາ' => round(($mex5-$nee5-$nh5)/1000000,2), 'ມິຖຸນາ' => round(($mex6-$nee6-$nh6)/1000000,2), 'ກໍລະກົດ' => round(($mex7-$nee7-$nh7)/1000000,2), 'ສິງຫາ' => round(($mex8-$nee8-$nh8)/1000000,2), 'ກັນຍາ' => round(($mex9-$nee9-$nh9)/1000000,2), 'ຕຸລາ' => round(($mex10-$nee10-$nh10)/1000000,2), 'ພະຈິກ' => round(($mex11-$nee11-$nh11)/1000000,2), 'ທັນວາ' => round(($mex12-$nee12-$nh12)/1000000,2));
        $exp = array('ມັງກອນ' => round(($mex1)/1000000,2), 'ກຸມພາ' => round(($mex2)/1000000,2), 'ມີນາ' => round(($mex3)/1000000,2), 'ເມສາ' => round(($mex4)/1000000,2), 'ພຶດສະພາ' => round(($mex5)/1000000,2), 'ມິຖຸນາ' => round(($mex6)/1000000,2), 'ກໍລະກົດ' => round(($mex7)/1000000,2), 'ສິງຫາ' => round(($mex8)/1000000,2), 'ກັນຍາ' => round(($mex9)/1000000,2), 'ຕຸລາ' => round(($mex10)/1000000,2), 'ພະຈິກ' => round(($mex11)/1000000,2), 'ທັນວາ' => round(($mex12)/1000000,2));
       // $reve = array("name"=>"ລາຍຮັບ","data"=>$dataline1);

       /// ກຳໄລ = ລາຍຮັບ - ລາຍຈ່າຍ - ໜີ້ຕ້ອງຮັບ
       $kam = array('ມັງກອນ' => round(($m1-$mex1-$nh1)/1000000,2), 'ກຸມພາ' => round(($m2-$mex2-$nh2)/1000000,2), 'ມີນາ' => round(($m3-$mex3-$nh3)/1000000,2), 'ເມສາ' => round(($m4-$mex4-$nh4)/1000000,2), 'ພຶດສະພາ' => round(($m5-$mex5-$nh5)/1000000,2), 'ມິຖຸນາ' => round(($m6-$mex6-$nh6)/1000000,2), 'ກໍລະກົດ' => round(($m7-$mex7-$nh7)/1000000,2), 'ສິງຫາ' => round(($m8-$mex8-$nh8)/1000000,2), 'ກັນຍາ' => round(($m9-$mex9-$nh9)/1000000,2), 'ຕຸລາ' => round(($m10-$mex10-$nh10)/1000000,2), 'ພະຈິກ' => round(($m11-$mex11-$nh11)/1000000,2), 'ທັນວາ' => round(($m12-$mex12-$nh12)/1000000,2));

        $response = [
            'reve' => $reve,
            'exp' => $exp,
            'kam' => $kam
        ];
        return response()->json($response);

    }

    public function get_revenue_expanses2(){
                
                $y = date("Y");
       
                $acc = AccTRN::where('work_status','=','success')->whereYear('created_at', '=', $y)->orderBy('created_at', 'asc')->get();
           
                /// ລາຍຮັບ
                $acc_income = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                $re = array();
                foreach($acc_income as $acc_id){
                        array_push($re,$acc_id['acc_id']);
                }
                
                /// ລາຍຈ່າຍ
                $acc_expense = Acc::where('acc_cat_id', '=', '6')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                $ex = array();
                foreach($acc_expense as $acc_id){
                        array_push($ex,$acc_id['acc_id']);
                }

                $response = [
                    're'=> $re,
                    'ex'=> $ex,
                    'acc' => $acc,
                ];
                return response()->json($response);
    }

    public function get_repaire_notsucc(){

        $key = \Request::get('s');
        $repa = array('a7','a8','a9');
       // $repaire = Repaire::whereYear('repaires.created_at', '=', date('Y'))->whereNotIn('repaires.status_now',$repa)->where('repaires.renum_id','LIKE',"%{$key}%")->orWhere('repaires.customer_name','LIKE',"%{$key}%")
        $repaire = Repaire::where('work_status','success')->whereYear('repaires.created_at', '=', date('Y'))->whereNotIn('repaires.status_now',$repa)
            ->leftJoin('customers', 'customers.id', '=', 'repaires.customer_id')
            ->orderBy('created_at', 'desc')
            ->paginate(10, array('repaires.*', 'customers.name','customers.last_name','customers.sex','customers.address','customers.tel'))
            ->toArray();
        return array_reverse($repaire);
    }
    public function dash_cap(Request $request){
   
        //$m1 = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', 1)->whereIn('cr',$re)->sum('sum');
        
        $month = $request->month;
       // return $month;


        $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

        $cap_all_sell = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
        $cap_year_sell = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('cr',$actype)->sum('sum');
        $cap_month_sell = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', $month)->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('cr',$actype)->sum('sum');
        //$cap_month_sell = '';
        // $cap_year = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('cr','=','401')->sum('sum');
        // $cap_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->where('cr','=','401')->sum('sum');

        $cap_year = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('dr','=','307')->sum('sum'); 

        
        $cap_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', $month)->where('dr','=','307')->sum('sum');
        //$cap_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->where('dr','=','307')->get();
        //$cap_month = '';
                $acc3 = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດເງິນສົດ ຫລື ທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //return $actype;
                    // ຊັບສິນໝຸນວຽນອື່ນໆ
        //$assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
        $assetsother_year = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('cr',$actype)->sum('sum');
        $assetsother_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', $month)->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('cr',$actype)->sum('sum');
        

        /// monney
        $asset_monney = AccTRN::where('work_status','success')->where('dr','571')->sum('sum')-AccTRN::where('work_status','success')->where('cr','571')->sum('sum');
        $asset_monney_acc_kip = AccTRN::where('work_status','success')->where('dr','551')->sum('sum')-AccTRN::where('work_status','success')->where('cr','551')->sum('sum');

        // $acc_sell = array('607');
        // $mee_sell_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('cr',$acc_sell)->sum('sum');
        // $sell_this_month = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->whereIn('dr',$acc_sell)->sum('sum')-$mee_sell_this_month;
        // $cap_m = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', Carbon::now()->month)->where('cr','=','401')->sum('sum');

        // $mee_sell_y = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('cr',$acc_sell)->sum('sum');
        // $sell_y = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->whereIn('dr',$acc_sell)->sum('sum')-$mee_sell_y;
        // $cap_y = AccTRN::where('work_status','success')->whereYear('created_at', '=', date('Y'))->where('cr','=','401')->sum('sum');

        $response = [
            'cap_month' => $cap_month,
            'cap_year' => $cap_year,
            'sell_month' => $cap_month_sell,
            'sell_year' => $cap_year_sell,
            'asset_year' => $assetsother_year,
            'asset_month' => $assetsother_month,
            'asset_monney' => $asset_monney,
            'asset_monney_acc_kip' => $asset_monney_acc_kip


        ];
        return response()->json($response);
    }
}
