<?php

namespace App\Http\Controllers\API;

use Session;
use App\Models\CustomerOffice;
use App\Models\Customer;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CustomerOfficeController extends Controller
{
    public function index()
    {
        if(check_roles('customer_access')){

            $page = \Request::get('page');
            $key = \Request::get('s');

            if(!$page){
                $customeroffice = CustomerOffice::all()->sortByDesc("id")->toArray();
            }
            else
            {
                $customeroffice = CustomerOffice::where('office_name','LIKE',"%{$key}%")->paginate(14)->toArray();
            }

            return array_reverse($customeroffice);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function add(Request $request)
    {

        if(check_roles('customer_add')){
            // start permission

        try {
        $customeroffice = new Customeroffice();
            $customeroffice->office_name = $request->office_name;
            $customeroffice->office_tel = $request->office_tel;
            $customeroffice->office_address = $request->office_address;
            $customeroffice->save();
            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ ສຳນັກງານ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

         // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function edit($id)
    {
        if(check_roles('customer_edit')){
            //start permission
            $customeroffice = CustomerOffice::find($id);
            return response()->json($customeroffice);
               // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('customer_edit')){
            //start permission

        try{
            $customeroffice = CustomerOffice::find($id);
            $customeroffice->update($request->all([
                $customeroffice->office_name = $request->office_name,
                $customeroffice->office_tel = $request->office_tel,
                $customeroffice->office_address = $request->office_address
            ]));

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັຍເດດຂໍ້ມູນລູກຄ້າ ສຳນັກງານ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັຍເດດຂໍ້ມູນລູກຄ້າ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
          //  return response()->json('The CustomerOffice successfully updated');

            // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function delete($id)
    {
        if(check_roles('customer_remove')){
            //start permission


        // ກວດຊອບຫາກມີການໃຊ້ id ໃນ Customer ຈະບໍ່ໃຫ້ລຶບ
        $checkOff = Customer::where('office', '=', $id)->count();

        if(!$checkOff){
            $customeroffice = CustomerOffice::find($id);
            $customeroffice->delete();
            $success = true;
            $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຂໍ້ມູນລູກຄ້າ ສຳນັກງານ','success');
        }
        else {
            $success = false;
            $message = 'ຂໍ້ມູນບໍ່ສາມາດລຶບໄດ້!';
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ຂໍ້ມູນບໍ່ສາມາດລຶບໄດ້ error: '.$message,'error');
        }

        //return response()->json('The CustomerOffice successfully deleted');

        $response = [
            'success' => $success,
            'message' => $message,
        ];

        return response()->json($response);

         // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
}
