<?php

namespace App\Http\Controllers\API;
use Session;
use App\Models\Customer;
use App\Models\CustomerList;
use App\Models\CustomerOffice;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;



class CustomerController extends Controller
{
    //
    public function index()
    {
        if(check_roles('customer_access')){
        // start permissions
            $key = \Request::get('s');
            $customers = Customer::where('customers.name','LIKE',"%{$key}%")->orWhere('customers.last_name','LIKE',"%{$key}%")->orWhere('customers.email','LIKE',"%{$key}%")->orWhere('customers.tel','LIKE',"%{$key}%")
            ->leftJoin('customer_offices', 'customer_offices.id', '=', 'customers.office')
            ->paginate(10, array('customers.*', 'customer_offices.office_name'))
            ->toArray();
            return array_reverse($customers);

            //end permissions 
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function GetAllCustomer(){

        if(check_roles('customer_access') || check_roles('preorder_access')){

            $customer = Customer::orderBy('created_at', 'asc')
            ->select('id','name','last_name','sex','images','address','tel','email')
            ->get();

            $office = CustomerOffice::orderBy('created_at', 'asc')
            ->select('id','office_name','office_tel','office_address')
            ->get();

            $response = [
                'success' => true,
                'AllCustomer' => $customer, 
                'AllOffice' => $office, 
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function addall(Request $request)
    {
        if(check_roles('customer_add')){

            $customerType = $request->customerType;

                if($customerType == 'true'){

                    try {

                        $customer = new Customer();
                        $customer->name = $request->name;
                        $customer->last_name = $request->last_name;
                        $customer->sex = $request->sex;
                        $customer->images = $request->images;
                        $customer->address = $request->address;
                        $customer->tel = $request->tel;
                        $customer->save();
                        $insert_id = $customer->id;
            
                        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                        save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ ບຸກຄົນໃໝ່','success');
        
                        $customer_update = Customer::orderBy('created_at', 'asc')
                        ->select('id','name','last_name','sex','images','address','tel','email')
                        ->get();
        
                        $success = true;
                        $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';
                    } catch (\Illuminate\Database\QueryException $ex) {
                        $customer ='';
                        $insert_id = '';
                        $success = false;
                        $message = $ex->getMessage();
                        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                        save_logs('ບັນທຶກຂໍ້ມູນ error: '.$message,'error');
                    }
        
                    
            
                    $response = [
                        'new_id'=> $insert_id,
                        'AllCustomer'=> $customer_update,
                        'success' => $success,
                        'message' => $message,
                    ];
                    return response()->json($response);

                } elseif($customerType=='false'){

                    try {

                        $customeroffice = new Customeroffice();
                        $customeroffice->office_name = $request->office_name;
                        $customeroffice->office_tel = $request->office_tel;
                        $customeroffice->office_address = $request->office_address;
                        $customeroffice->save();
                        $insert_id = $customeroffice->id;
                        $success = true;
            
                        // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                        save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ ບຸກຄົນໃໝ່','success');
        
                        $office_update = CustomerOffice::orderBy('created_at', 'asc')
                        ->select('id','office_name','office_tel','office_address')
                        ->get();
        
                        $success = true;
                        $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';
                    } catch (\Illuminate\Database\QueryException $ex) {
                        $office_update ='';
                        $insert_id = '';
                        $success = false;
                        $message = $ex->getMessage();
                    }
        
                    
            
                    $response = [
                        'new_id'=> $insert_id,
                        'AllOffice'=> $office_update,
                        'success' => $success,
                        'message' => $message,
                    ];
                    return response()->json($response);
                }
            
           
    
  
            } else {
                $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
                return response()->json($response);
            }

    }

    public function ListToBill()
    {
        if(check_roles('customer_access')){

                $users = DB::table('customers')->select('id', 'sex','name','last_name','address','tel')->get();
                return $users;

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function add(Request $request)
    {

        if(check_roles('customer_add')){
        // start permission

        
        try {
        $customer = new Customer();
            $customer->name = $request->name;
            $customer->last_name = $request->last_name;
            $customer->sex = $request->sex;
            $customer->images = $request->images;
            $customer->office = $request->office;
            $customer->address = $request->address;
            $customer->email = $request->email;
            $customer->tel = $request->tel;
            $customer->save();

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ ບຸກຄົນໃໝ່','success');

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';
        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຂໍ້ມູນລູກຄ້າ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function edit($id)
    {
        if(check_roles('customer_edit')){

            $customer = Customer::find($id);
            return response()->json($customer);
        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('customer_edit')){
        //start permission
        try {

            $customer = Customer::find($id);
            $customer->update($request->all([
                $customer->name = $request->name,
                $customer->last_name = $request->last_name,
                $customer->sex = $request->sex,
                $customer->images = $request->images,
                $customer->office = $request->office,
                $customer->address = $request->address,
                $customer->email = $request->email,
                $customer->tel = $request->tel
            ]));
            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຂໍ້ມູນ ລູກຄ້າບຸກຄົນ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຂໍ້ມູນ error: '.$message,'error');
        }

            $response = [
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);
            
        //return response()->json('The User successfully updated');

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function delete($id)
    {
        if(check_roles('customer_remove')){
            //start permission
        try {

            $customer = Customer::find($id);
            $customer->delete();

            return response()->json('The User successfully deleted');

                $success = true;
                $message = 'ລຶບຂໍ້ມູນ ສຳເລັດ!';

                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ລຶບຂໍ້ມູນລູກຄ້າ ບຸກຄົນ','success');

            } catch (\Illuminate\Database\QueryException $ex) {
                $success = false;
                $message = $ex->getMessage();
                // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
                save_logs('ລຶບຂໍ້ມູນລູກຄ້າ error: '.$message,'error');
            }

        // end permission
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
}
