<?php

namespace App\Http\Controllers\API;
use App\Models\Bills;
use App\Models\BillsList;
use App\Models\STORE\Product;
use App\Models\STORE\Barcode;
use App\Models\STORE\ProductOption;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BillsListController extends Controller
{
    //
    public function index()
    {
        if(check_roles('bill_access')){

            $bid = \Request::get('billnum_id');
            $billslist = BillsList::where('work_status','success')->where('billnum_id',$bid)->get();
            
            // $db_product = Product::where('billnum_id',$bid)
            // ->select('product_id','in_store','in_store_pack','product_unit_type')
            // ->get();

            // $product_price = Barcode::where('billnum_id',$bid)
            // ->select('option_id','pbc_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
            // ->get();

            // $product_option = ProductOption::where('billnum_id',$bid)
            // ->select('option_id','pbc_id','product_id','barcode','price_type','price','price_pro','unit','default','default_pro','sell')
            // ->get();
            //return array_reverse($billslist);


            return response()->json($billslist);
            

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function add(Request $request)
    {
        if(check_roles('bill_add')){
        // start permissions

        try {

            $blist = BillsList::where('work_status','success')->where('billnum_id',$request->billnum_id)->get();
            //return $blist;
            if(count($blist)>0){
                $insert = true;

                foreach($blist as $b){
                    if($b['product_id']!=null && $b['product_id']!=''){
                        if($b['product_id']==$request->product_id){
                            if($b['product_id']!=''){
                            $blistup = BillsList::where('billnum_id',$request->billnum_id)->where('product_id',$request->product_id);
                            $blistup->update([
                                'count' => (int)$b['count']+(int)$request->count,
                            ]);
                            $success = true;
                            $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                            $insert = false;
                            break;
                            }
                        }
                    }

                }

                if($insert){
                    if($request->name!='' && $request->credit!=''){
                        $billslist = new BillsList();
                        $billslist->billnum_id = $request->billnum_id;
                        $billslist->name = $request->name;
                        $billslist->detail = $request->detail;
                        $billslist->bill_type = $request->bill_type;
                        $billslist->product_id = $request->product_id;
                        $billslist->count = $request->count;
                        $billslist->credit = $request->credit;
                        $billslist->save();
                        $success = true;
                        $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                        }
                        else {
                            $success = false;
                        $message = 'ບໍ່ອານຸຍາດໃຫ້ບັນທຶກ!';
                        }
                }


            }
            else {
                if($request->name!='' && $request->credit!=''){
                $billslist = new BillsList();
                $billslist->billnum_id = $request->billnum_id;
                $billslist->name = $request->name;
                $billslist->detail = $request->detail;
                $billslist->bill_type = $request->bill_type;
                $billslist->product_id = $request->product_id;
                $billslist->count = $request->count;
                $billslist->credit = $request->credit;
                $billslist->save();
                $success = true;
                $message = 'ເພີ່ມລາຍການ ສຳເລັດ!';
                }
                else {
                    $success = false;
                $message = 'ບໍ່ອານຸຍາດໃຫ້ບັນທຶກ!';
                }
            }


            $billslist = BillsList::where('billnum_id',$request->billnum_id)->get();
            $que = $billslist;

        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '[]';
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        //end permissions

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('bill_edit')){
        // start permissions
        try {

            $billslist = BillsList::find($id);
            $billslist->update($request->all([
                $billslist->name = $request->name,
                $billslist->detail = $request->detail,
                $billslist->count = $request->count,
                $billslist->credit = $request->credit,
                $billslist->product_id = $request->product_id,
                $billslist->bill_type = $request->bill_type
            ]));

            $quolist = BillsList::where('billnum_id',$request->billnum_id)->get();
            $que = $quolist;

            $success = true;
            $message = 'successfully';
          //  $que =
        } catch (\Illuminate\Database\QueryException $ex) {

            $success = false;
            $message = $ex->getMessage();
            $que = '';
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function delete($id)
    {
        if(check_roles('bill_remove')){
            /// start permissions
            //ListRepaireItem::where('billnum_id',$id)->delete();
            //BillsList::where('billnum_id',$id)->delete();

            $litem = BillsList::find($id);
            $litem->delete();

            $success = true;
            $message = 'Delete successfully';

            $response = [
                'success' => $success,
                'message' => $message,
            ];

            return response()->json($response);
            // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}