<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ACC\AccTRN;
use App\Models\ACC\Acc;
use App\Models\ACC\AccCategory;
use App\Models\STORE\Store;
use App\Models\STORE\Product;
use App\Models\STORE\SessionProduct;
use App\Models\STORE\Unit;
use App\Models\Bills;
use App\Models\BillsList;
use Carbon\Carbon;
use App\Exports\ProductsExport;
use Maatwebsite\Excel\Facades\Excel;

class ReportController extends Controller
{
    //
    public function ReportAcc(Request $request){

        if(check_roles('report_access')){

            try {
                $datere = $request->datere;
                $date = $request->dmy;
                $m = explode('-',$date)[1];
                $y = explode('-',$date)[0];
                if($datere == 'd'){
                    $acc = AccTRN::where('work_status','=','success')->whereDate('created_at', '=', $date)->orderBy('created_at', 'asc')->get();
                } elseif($datere == 'm'){
                   // echo $m;
                    $acc = AccTRN::where('work_status','=','success')->whereYear('created_at', '=', $y)->whereMonth('created_at', '=', $m)->orderBy('created_at', 'asc')->get();
                } elseif($datere == 'm1-3'){
                    $mm = '3';
                    // echo date('Y-m-01');

                    $date_start = date('Y-m-01', strtotime($y.'-1')).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-3')).' 23:59:59';
                    //echo $date_start."-".$date_end;
                    //$acc = AccTRN::where('work_status','=','success')->whereYear('created_at', '=', $y)->whereMonth('created_at', '<=', $mm)->get();
                    //$dateS = Carbon::now()->startOfMonth()->subMonth(11);
                    //$dateE = Carbon::now()->startOfMonth(); 
                   // echo $date_end;
                    $acc = AccTRN::where('work_status','=','success')->whereBetween('created_at',[$date_start,$date_end])->orderBy('created_at', 'asc')->get();
                } elseif($datere == 'm1-6'){
                    //$mm = '6';
                    $date_start = date('Y-m-01', strtotime($y.'-1')).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-6')).' 23:59:59';
                    $acc = AccTRN::where('work_status','=','success')->whereBetween('created_at',[$date_start,$date_end])->orderBy('created_at', 'asc')->get();
                } elseif($datere == 'm1-9'){
                    //$mm = '9';
                    $date_start = date('Y-m-01', strtotime($y.'-1')).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-9')).' 23:59:59';
                    $acc = AccTRN::where('work_status','=','success')->whereBetween('created_at',[$date_start,$date_end])->orderBy('created_at', 'asc')->get();
                } elseif($datere == 'y'){
                    $acc = AccTRN::where('work_status','=','success')->whereYear('created_at', '=', $y)->orderBy('created_at', 'asc')->get();
                }

                /// ລາຍຮັບ
                $acc_income = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                $re = array();
                foreach($acc_income as $acc_id){
                        array_push($re,$acc_id['acc_id']);
                }
                
                /// ລາຍຈ່າຍ
                $acc_expense = Acc::where('acc_cat_id', '=', '6')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                $ex = array();
                foreach($acc_expense as $acc_id){
                        array_push($ex,$acc_id['acc_id']);
                }

                $success = true;
                $message = 'ສຳເລັດ!';

            } catch (\Illuminate\Database\QueryException $ex) {
                $acc ='';
                $re ='';
                $ex ='';
                $success = false;
                $message = $ex->getMessage();
            }

            $response = [
                're'=> $re,
                'ex'=> $ex,
                'acc' => $acc,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
             return response()->json($response);
         }
    }

    public function ReportFinancial(Request $request)
    {
        if(check_roles('report_access')){


        try {

            $reportcode = $request->reportcode;
            $datere = $request->datere;

            $date = $request->dmy;
            $m = explode('-',$date)[1];
            $y = explode('-',$date)[0];

            //echo $reportcode.'|'.$date.'|'.$dmy;

            /*
            $cap_pro ຕົ້ນທຶນຊື້
            $cap_ser ຕົ້ນທຶນບໍລິການ
            $revenue ລາຍຮັບໃນທຸລະກິດ
            $income_all ລາຍຮັບອື່ນໆ
            $expense_all ລາຍຈ່າຍອື່ນໆ
            $incom_acc ລາຍຮັບການເງິນ
            $expense_manager ລາຍຈ່າຍບໍລິຫານ
            $tax_pay ອາກອນຕ້ອງຈ່າຍ 
            $tax_wait ອາກອນເຍືອນຈ່າຍ
            $sang_income ລາຍຮັບສັງລວມອື່ນໆ
            $other_income ລາຍຮັບອື່ນໆ
            */

            switch ($datere) {
                case 'm':
                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // Carbon::createFromFormat('m/d/Y', '11/02/2020')->subMonthsNoOverflow()

                    $date_start = date('Y-m-01', strtotime($y.'-'.$m)).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-'.$m)).' 23:59:59';

                    $last_month_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfMonth();
                    $last_month_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfMonth();

                    $last_year_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfYear();
                    $last_year_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfYear();


                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');

                    
                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->where('cr','411')->sum('sum');

                    //echo $nee_this_month;

                    // ຄິດໄລ່ ລາຍຮັບ  ->where('trn_type','income')
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$re)->sum('sum')-$nee_this_month;


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }


                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');



                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ເດືອນ';
                    $report_date_start = $date_start;
                    $report_date_end = $date_end;
                    
                break;

                    
                case 'm1-3':

                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                            
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //print_r($actype);

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-1-1';
                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(3);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last ])->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month ])->whereIn('cr',$actype)->sum('sum');


                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->where('cr','411')->sum('sum');
                  
                    // ຄິດໄລ່ ລາຍຮັບ
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$re)->sum('sum')-$nee_this_month;


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }


                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ງວດ 1';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm4-6':
                    
                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                            
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //print_r($actype);

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-4-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last ])->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month ])->whereIn('cr',$actype)->sum('sum');


                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->where('cr','411')->sum('sum');
                  
                  
                    // ຄິດໄລ່ ລາຍຮັບ
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$re)->sum('sum')-$nee_this_month;



                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    

                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ງວດ 2';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm7-9':
                    

                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                            
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //print_r($actype);

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-7-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last ])->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month ])->whereIn('cr',$actype)->sum('sum');

                  
                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->where('cr','411')->sum('sum');
                  

                    // ຄິດໄລ່ ລາຍຮັບ
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$re)->sum('sum')-$nee_this_month;



                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    

                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ງວດ 3';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm10-12':


                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                            
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //print_r($actype);

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-10-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last ])->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month ])->whereIn('cr',$actype)->sum('sum');

                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->where('cr','411')->sum('sum');
                  
                  
                    // ຄິດໄລ່ ລາຍຮັບ
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$re)->sum('sum')-$nee_this_month;



                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    

                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ງວດ 4';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'y':


                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                            
                    }

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '15')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //print_r($actype);

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-1-1';

                    $start_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->endOfMonth()->addMonths(11);

                    // 3 ເດືອນຕົ້ນປີ
                    //$start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    //$end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_month.' - '.$end_month;
                   // echo date($y);
                    // ຄິດໄລ່ຕົ້ນທຶນ
                    $cap_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $cap_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $cap_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');

                    //ໜີ້ຕ້ອງຮັບ
                    $nee_all = AccTRN::where('work_status','success')->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->where('cr','411')->sum('sum');
                    $nee_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->where('cr','411')->sum('sum');
                    $nee_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->Where('dr','411')->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->where('cr','411')->sum('sum');
                  
                  
                    // ຄິດໄລ່ ລາຍຮັບ
                    $revenue_all = AccTRN::where('work_status','success')->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$re)->sum('sum')-$nee_all;
                    $revenue_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$re)->sum('sum')-$nee_this_lastmonth;
                    $revenue_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$re)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$re)->sum('sum')-$nee_this_month;



                    $acc2 = Acc::where('acc_cat_sub_id', '=', '16')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    

                    // ລາຍຈ່າຍ ບໍລິຫານ
                    $manager_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $manager_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '24')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ທາງການເງິນ
                    $financial_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $financial_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '18')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    //print_r($actype);

                    // ລາຍຈ່າຍ ອາກອນຄ່າທຳນຽມ
                    $fee_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $fee_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    


                    $acc2 = Acc::where('acc_cat_sub_id', '=', '17')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ໃຫ້ພະນັກງານ
                    $staff_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $staff_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '19')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອື່ນໆ
                    $other_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $other_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '22')->get(); /// ເລືອກບັນຊີພະເພດລາຍຈ່າຍ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ລາຍຈ່າຍ ອາກອນຕ້ອງຈ່າຍ
                    $tax_expense_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_lastmonth = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $tax_expense_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    
                    $report_date_type = 'ປີ';
                    $report_date_start = $start_month;
                    $report_date_end = $end_month;

                break;

            }



        

            $success = true;
            $message = 'ສຳເລັດ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $cap_all='';
            $cap_this_lastmonth='';
            $cap_this_month='';
            $revenue_all='';
            $revenue_this_lastmonth='';
            $revenue_this_month='';
            $manager_expense_all='';
            $manager_expense_this_lastmonth='';
            $manager_expense_this_month='';
            $financial_expense_all='';
            $financial_expense_this_lastmonth='';
            $financial_expense_this_month='';
            $fee_expense_all='';
            $fee_expense_this_lastmonth='';
            $fee_expense_this_month='';
            $staff_expense_all='';
            $staff_expense_this_lastmonth='';
            $staff_expense_this_month='';
            $other_expense_all='';
            $other_expense_this_lastmonth='';
            $other_expense_this_month='';
            $tax_expense_all='';
            $tax_expense_this_lastmonth='';
            $tax_expense_this_month='';
            $report_date_type = '';
            $report_date_start = '';
            $report_date_end = '';
            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'cap_all' => $cap_all,
            'cap_this_lastmonth' => $cap_this_lastmonth,
            'cap_this_month' => $cap_this_month,
            'revenue_all' => $revenue_all,
            'revenue_this_lastmonth' => $revenue_this_lastmonth,
            'revenue_this_month' => $revenue_this_month,
            'manager_expense_all' => $manager_expense_all,
            'manager_expense_this_lastmonth'=> $manager_expense_this_lastmonth,
            'manager_expense_this_month'=> $manager_expense_this_month,
            'financial_expense_all' => $financial_expense_all,
            'financial_expense_this_lastmonth' => $financial_expense_this_lastmonth,
            'financial_expense_this_month' => $financial_expense_this_month,
            'fee_expense_all' => $fee_expense_all,
            'fee_expense_this_lastmonth' => $fee_expense_this_lastmonth,
            'fee_expense_this_month' => $fee_expense_this_month,
            'staff_expense_all' => $staff_expense_all,
            'staff_expense_this_lastmonth' => $staff_expense_this_lastmonth,
            'staff_expense_this_month' => $staff_expense_this_month,
            'other_expense_all' => $other_expense_all,
            'other_expense_this_lastmonth' => $other_expense_this_lastmonth,
            'other_expense_this_month' => $other_expense_this_month,
            'tax_expense_all' => $tax_expense_all,
            'tax_expense_this_lastmonth' => $tax_expense_this_lastmonth,
            'tax_expense_this_month' => $tax_expense_this_month,
            'report_date_type' => $report_date_type,
            'report_date_start' => $report_date_start,
            'report_date_end' => $report_date_end,
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    
    }


    /// report subsin

    public function ReportFinancial_subsin(Request $request)
    {
        if(check_roles('report_access')){

        try {

            $reportcode = $request->reportcode;
            $datere = $request->datere;

            $date = $request->dmy;
            $m = explode('-',$date)[1];
            $y = explode('-',$date)[0];

            //echo $reportcode.'|'.$date.'|'.$dmy;

            /*
            $curr ເງິນສົດ ແລະ ສີ່ທຽບເທົ່າເງິນສົດ
            $neehub ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
            $instore ເຄື່ອງໃນສາງ
            $assetother ຊັບສິນໝຸນວຽນອື່ນໆ
            $assetin ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
            $assetout ຊັບສົມບັດບໍ່ມີຕົວຕົນ
            $assetsee ຊັບສິນຊິວະພາບ
            $assetinother ຊັບສິນອື່ນໆ
            */

            switch ($datere) {
                case 'm':
                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                    }

                    

                    // Carbon::createFromFormat('m/d/Y', '11/02/2020')->subMonthsNoOverflow()

                    $date_start = date('Y-m-01', strtotime($y.'-'.$m)).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-'.$m)).' 23:59:59';

                    $last_month_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfMonth();
                    $last_month_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfMonth();

                    $last_year_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfYear();
                    $last_year_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfYear();


                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //return $date_start.' - '.$date_end;
                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    //$neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $neehub_all = Bills::where('work_status','success')->where('status','pending')->sum('all_credit'); 
                    //$neehub_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $neehub_last_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$last_month_start, $last_month_end])->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$date_start, $date_end])->sum('all_credit');
                //     $neehub_this_month_dr = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->get();
                //     $neehub_this_month_cr = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->get();
                    

                //     $response = ['DR' => $neehub_this_month_dr,
                //     'CR' => $neehub_this_month_cr, ];
                        //return response()->json($response);
                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');
                    
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
                    //return $actype;
                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum');
                    


                    $report_date_type = 'ເດືອນ';
                    $report_date_start = $date_start;
                    $report_date_end = $date_end;
                    
                break;

                    
                case 'm1-3':



                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-1-1';
                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(3);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;


                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    //$neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$neehub_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    //$neehub_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');

                    $neehub_all = Bills::where('work_status','success')->where('status','pending')->sum('all_credit');
                    $neehub_last_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month, $end_3month])->sum('all_credit');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                   
                    $report_date_type = 'ງວດ 1';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm4-6':
                    
        

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-4-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    $neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                   // $neehub_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                   // $neehub_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');


                    $neehub_last_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month, $end_3month])->sum('all_credit');
                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    
                    $report_date_type = 'ງວດ 2';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm7-9':
                    


                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-7-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    //$neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$neehub_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    //$neehub_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    
                    $neehub_all = Bills::where('work_status','success')->where('status','pending')->sum('all_credit');
                    $neehub_last_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month, $end_3month])->sum('all_credit');

                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $report_date_type = 'ງວດ 3';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm10-12':


      

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-10-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    //$neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                   // $neehub_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                   // $neehub_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');

                   $neehub_all = Bills::where('work_status','success')->where('status','pending')->sum('all_credit');
                    $neehub_last_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->where('status','pending')->whereBetween('created_at', [$start_3month, $end_3month])->sum('all_credit');
                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum');
                    


                    $report_date_type = 'ງວດ 4';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'y':

                    $date_m1_3 = $y.'-1-1';

                    $start_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->endOfMonth()->addMonths(11);

                

                    $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                    $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $curr_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $curr_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $acc1 = Acc::where('acc_cat_sub_id', '=', '11')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະໜີ້ຕ້ອງຮັບອື່ນໆ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງຮັບໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງຮັບອື່ນໆ
                    //$neehub_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$neehub_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    //$neehub_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');

                    $neehub_all = Bills::where('work_status','success')->where('status','pending')->sum('all_credit');
                    $neehub_last_month = Bills::where('work_status','success')->whereYear('created_at', date($y-1))->sum('all_credit');
                    $neehub_this_month = Bills::where('work_status','success')->whereYear('created_at', date($y))->sum('all_credit');
                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '10')->get(); /// ເລືອກບັນຊີປະເພດເຄື່ອງໃນສາງ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ເຄື່ອງໃນສາງ
                    $instore_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $instore_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $instore_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '13')->get(); /// ເລືອກບັນຊີປະເພດຊັບສິນໝຸນວຽນອື່ນໆ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສິນໝຸນວຽນອື່ນໆ
                    $assetsother_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetsother_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $assetsother_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '6')->get(); /// ເລືອກບັນຊີປະເພດຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ຊັບສົມບັດຄົງທີ່ມີຕົວຕົນ
                    $assetin_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    $assetin_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                    $assetin_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $report_date_type = 'ປີ';
                    $report_date_start = $start_month;
                    $report_date_end = $end_month;

                break;

            }



        

            $success = true;
            $message = 'ສຳເລັດ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $curr_all='';
            $curr_last_month='';
            $curr_this_month='';
            $neehub_all='';
            $neehub_last_month='';
            $neehub_this_month='';
            $instore_all='';
            $instore_last_month='';
            $instore_this_month='';
            $assetsother_all='';
            $assetsother_last_month='';
            $assetsother_this_month='';
            $assetin_all='';
            $assetin_last_month='';
            $assetin_this_month='';
            $assetout_all='';
            $assetout_last_month='';
            $assetout_this_month='';
            $assetsee_all='';
            $assetsee_last_month='';
            $assetsee_this_month='';
            $assetinother_all='';
            $assetinother_last_month='';
            $assetinother_this_month='';
            $report_date_type = '';
            $report_date_start = '';
            $report_date_end = '';
            $success = false;
            $message = $ex->getMessage();
        }

            $assetout_all='';
            $assetout_last_month='';
            $assetout_this_month='';
            $assetsee_all='';
            $assetsee_last_month='';
            $assetsee_this_month='';
            $assetinother_all='';
            $assetinother_last_month='';
            $assetinother_this_month='';

        $response = [
            'curr_all' => $curr_all,
            'curr_last_month' => $curr_last_month,
            'curr_this_month' => $curr_this_month,
            'neehub_all' => $neehub_all,
            'neehub_last_month' => $neehub_last_month,
            'neehub_this_month' => $neehub_this_month,
            'instore_all' => $instore_all,
            'instore_last_month'=> $instore_last_month,
            'instore_this_month'=> $instore_this_month,
            'assetsother_all' => $assetsother_all,
            'assetsother_last_month' => $assetsother_last_month,
            'assetsother_this_month' => $assetsother_this_month,
            'assetin_all' => $assetin_all,
            'assetin_last_month' => $assetin_last_month,
            'assetin_this_month' => $assetin_this_month,
            'assetout_all' => $assetout_all,
            'assetout_last_month' => $assetout_last_month,
            'assetout_this_month' => $assetout_this_month,
            'assetsee_all' => $assetsee_all,
            'assetsee_last_month' => $assetsee_last_month,
            'assetsee_this_month' => $assetsee_this_month,
            'assetinother_all' => $assetinother_all,
            'assetinother_last_month' => $assetinother_last_month,
            'assetinother_this_month' => $assetinother_this_month,
            'report_date_type' => $report_date_type,
            'report_date_start' => $report_date_start,
            'report_date_end' => $report_date_end,
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    
    }


    public function ReportFinancial_neesin(Request $request)
    {
        if(check_roles('report_access')){

        try {

            $reportcode = $request->reportcode;
            $datere = $request->datere;

            $date = $request->dmy;
            $m = explode('-',$date)[1];
            $y = explode('-',$date)[0];

            //echo $reportcode.'|'.$date.'|'.$dmy;

            /*
            $neesebtother       ໜີ້ຕ້ອງສົ່ງ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
            $intsent            ດອກເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
            $taxsent            ໜີ້ຕ້ອງສົ່ງອາກອນ
            $currh              ເງິນແຮ
            $neesinother        ໜີ້ສິນໝຸນວຽນອື່ນໆ
            $loan               ເງິນກູ້ທະນາຄານ
            $curr2              ເງິນແຮ2
            $neesinlong         ໜີ້ສິນໄລຍະຍາວອື່ນໆ
            $standset           ທຶນຈົດທະບຽນ
            $stand              ທຶນເຈົ້າຂອງທຸລະກິດ
            $profityear         ກຳໄລໃນປີ
            */

            switch ($datere) {
                case 'm':
                    $acc = Acc::where('acc_cat_id', '=', '7')->get(); /// ເລືອກບັນຊີພະເພດລາຍຮັບ
                    $re = array();
                    foreach($acc as $acc_id){
                            array_push($re,$acc_id['acc_id']);
                    }

                    

                    // Carbon::createFromFormat('m/d/Y', '11/02/2020')->subMonthsNoOverflow()

                    $date_start = date('Y-m-01', strtotime($y.'-'.$m)).' 00:00:00';
                    $date_end = date('Y-m-t', strtotime($y.'-'.$m)).' 23:59:59';

                    $last_month_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfMonth();
                    $last_month_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfMonth();

                    $last_year_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfYear();
                    $last_year_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfYear();


                    $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    


                    $report_date_type = 'ເດືອນ';
                    $report_date_start = $date_start;
                    $report_date_end = $date_end;
                    
                break;

                    
                case 'm1-3':



                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-1-1';
                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(3);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;


                    
                    $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                   
                    $report_date_type = 'ງວດ 1';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm4-6':
                    
        

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-4-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $report_date_type = 'ງວດ 2';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm7-9':
                    


                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-7-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                   $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $report_date_type = 'ງວດ 3';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'm10-12':


      

                    // 3 ເດືອນກ່ອນ
                    $date_m1_3 = $y.'-10-1';

                    $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                    $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();

                    // 3 ເດືອນຕົ້ນປີ
                    $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                    //echo $end_3month;

                    //echo $start_3month_last.' - '.$end_3month_last;
                    //echo $start_3month.' - '.$end_3month;

                    $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    


                    $report_date_type = 'ງວດ 4';
                    $report_date_start = $start_3month;
                    $report_date_end = $end_3month;

                break;

                case 'y':

                    $date_m1_3 = $y.'-1-1';

                    $start_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                    $end_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->endOfMonth()->addMonths(11);

                

                //     $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                //     $actype = array();
                //     foreach($acc as $acc_id){
                //             array_push($actype,$acc_id['acc_id']);
                //     }

                    // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                //     $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                //     $curr_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                //     $curr_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                    

                    $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                    $actype = array();
                    foreach($acc as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                    $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $neesentother_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $neesentother_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');



                    $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                    $actype = array();
                    foreach($acc1 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                    $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $intsent_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $intsent_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');

                    
                    $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $actype = array();
                    foreach($acc2 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ໜີ້ຕ້ອງສົ່ງອາກອນ
                    $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $taxsent_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $taxsent_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    

                    $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                    $actype = array();
                    foreach($acc3 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }
           
                    // ເງິນກູ້ໄລຍະສັ້ນ
                    $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $loan_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $loan_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນຈົດທະບຽນ
                    $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $standset_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $standset_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    

                    $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                    $actype = array();
                    foreach($acc4 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ທຶນເຈົ້າຂອງທຸລະກິດ
                    $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                    $stand_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                    $stand_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                    
                    $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                    $actype = array();
                    foreach($acc5 as $acc_id){
                            array_push($actype,$acc_id['acc_id']);
                    }

                    // ກຳໄລໃນປີ
                    $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                    //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                    //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                    

                    $report_date_type = 'ປີ';
                    $report_date_start = $start_month;
                    $report_date_end = $end_month;

                break;

            }


            $success = true;
            $message = 'ສຳເລັດ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $neesentother_all='';
            $neesentother_last_month='';
            $neesentother_this_month='';
            $intsent_all='';
            $intsent_last_month='';
            $intsent_this_month='';
            $taxsent_all='';
            $taxsent_last_month='';
            $taxsent_this_month='';
            $currh_all='';
            $currh_last_month='';
            $currh_this_month='';
            $neesinother_all='';
            $neesinother_last_month='';
            $neesinother_this_month='';
            $loan_all='';
            $loan_last_month='';
            $loan_this_month='';
            $currh2_all='';
            $currh2_last_month='';
            $currh2_this_month='';

            $neesinlong_all='';
            $neesinlong_last_month='';
            $neesinlong_this_month='';

            $standset_all='';
            $standset_last_month='';
            $standset_this_month='';

            $stand_all='';
            $stand_last_month='';
            $stand_this_month='';
            $profityear='';

            $report_date_type = '';
            $report_date_start = '';
            $report_date_end = '';
            $success = false;
            $message = $ex->getMessage();
        }


            $currh_all='';
            $currh_last_month='';
            $currh_this_month='';
            $neesinother_all='';
            $neesinother_last_month='';
            $neesinother_this_month='';
            $currh2_all='';
            $currh2_last_month='';
            $currh2_this_month='';
            $neesinlong_all='';
            $neesinlong_last_month='';
            $neesinlong_this_month='';
        

        $response = [
            'neesentother_all' => $neesentother_all,
            'neesentother_last_month' => $neesentother_last_month,
            'neesentother_this_month' => $neesentother_this_month,
            'intsent_all' => $intsent_all,
            'intsent_last_month' => $intsent_last_month,
            'intsent_this_month' => $intsent_this_month,
            'taxsent_all' => $taxsent_all,
            'taxsent_last_month'=> $taxsent_last_month,
            'taxsent_this_month'=> $taxsent_this_month,
            'currh_all' => $currh_all,
            'currh_last_month' => $currh_last_month,
            'currh_this_month' => $currh_this_month,
            'neesinother_all' => $neesinother_all,
            'neesinother_last_month' => $neesinother_last_month,
            'neesinother_this_month' => $neesinother_this_month,
            'loan_all' => $loan_all,
            'loan_last_month' => $loan_last_month,
            'loan_this_month' => $loan_this_month,
            'currh2_all' => $currh2_all,
            'currh2_last_month' => $currh2_last_month,
            'currh2_this_month' => $currh2_this_month,
            'neesinlong_all' => $neesinlong_all,
            'neesinlong_last_month' => $neesinlong_last_month,
            'neesinlong_this_month' => $neesinlong_this_month,
            'standset_all' => $standset_all,
            'standset_last_month' => $standset_last_month,
            'standset_this_month' => $standset_this_month,
            'stand_all' => $stand_all,
            'stand_last_month' => $stand_last_month,
            'stand_this_month' => $stand_this_month,
            'profityear' => $profityear,

            'report_date_type' => $report_date_type,
            'report_date_start' => $report_date_start,
            'report_date_end' => $report_date_end,
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    
    }

    public function ReportStore(Request $request){
        
            try {

                $datere = $request->datere;
                $date = $request->dmy;
                $m = explode('-',$date)[1];
                $y = explode('-',$date)[0];

                $AllProductStore = 'a';
                
                switch ($datere) {
                        case 'm':

                            
                            $date_start = date('Y-m-01', strtotime($y.'-'.$m)).' 00:00:00';
                            $date_end = date('Y-m-t', strtotime($y.'-'.$m)).' 23:59:59';
        
                            $last_month_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfMonth();
                            $last_month_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfMonth();
        
                            $last_year_start = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->startOfYear();
                            $last_year_end = Carbon::createFromFormat('Y-m-d',$date)->subMonthsNoOverflow()->endOfYear();
                                
                        //     $AllProductStore = Store::join('products','stores.product_id','=','products.product_id')
                        //                         ->select('products.*','stores.product_id','stores.st_import_amount')
                        //                          ->groupBy('stores.product_id')
                        //                          ->selectRaw('stores.product_id, sum(stores.st_import_amount) as sum_amount')
                        //                         ->get();
                        //     $StoreProducts = [];
                        //     $AllStore = Store::groupBy('product_id')
                        //                          ->selectRaw('product_id, sum(st_import_amount) as sum_amount')
                        //                          ->orderBy('sum_amount','desc')
                        //                         ->get();
                        //     $AllProduct = Product::get();
                        //     foreach($AllStore as $item_store)
                        //     {
                        //         foreach($AllProduct as $item_pro)
                        //         {
                        //                 if($item_store['product_id']==$item_pro['product_id']){
                        //                         array_push($StoreProducts, (object)[
                        //                                 'product_id' => $item_store['product_id'],
                        //                                 'product_name' => $item_pro['product_name'],
                        //                                 'session_id' => $item_pro['session_id'],
                        //                                 'category_id' => $item_pro['category_id'],
                        //                                 'product_price_buy' => $item_pro['product_price_buy'],
                        //                         ]);
                        //                 }
                        //         }
                        //     }

                        $AllProduct = Product::join('session_products','products.session_id','=','session_products.id')
                                ->join('units','products.product_unit','=','units.id')
                                ->select('products.*','session_products.*','units.*')
                                ->where('products.in_store','>','0')
                                ->orderBy('products.in_store','desc')
                                ->get();

                            $report_date_type = 'ເດືອນ';
                            $report_date_start = $date_start;
                            $report_date_end = $date_end;
                
                            $AllProductStore = $AllProduct;
                        //     $ProductLost
                        //     $Sell_Pro_Ser
                        //     $Import_Pro
                        //     $SellG


                        break;
        
                            
                        case 'm1-3':
        
        
        
                            // 3 ເດືອນກ່ອນ
                            $date_m1_3 = $y.'-1-1';
                            $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(3);
                            $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();
        
                            // 3 ເດືອນຕົ້ນປີ
                            $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                            $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                            //echo $end_3month;
        
        
                            
                            $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                            $actype = array();
                            foreach($acc as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                            $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
        
        
                            $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                            $actype = array();
                            foreach($acc1 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                            $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
                            
                            $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $actype = array();
                            foreach($acc2 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                            $actype = array();
                            foreach($acc3 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
                   
                            // ເງິນກູ້ໄລຍະສັ້ນ
                            $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນຈົດທະບຽນ
                            $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນເຈົ້າຂອງທຸລະກິດ
                            $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
                            $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                            $actype = array();
                            foreach($acc5 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ກຳໄລໃນປີ
                            $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                            //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                            //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                            
        
                           
                            $report_date_type = 'ງວດ 1';
                            $report_date_start = $start_3month;
                            $report_date_end = $end_3month;
        
                        break;
        
                        case 'm4-6':
                            
                
        
                            // 3 ເດືອນກ່ອນ
                            $date_m1_3 = $y.'-4-1';
        
                            $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                            $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();
        
                            // 3 ເດືອນຕົ້ນປີ
                            $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                            $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                            //echo $end_3month;
        
                            //echo $start_3month_last.' - '.$end_3month_last;
                            //echo $start_3month.' - '.$end_3month;
        
                            $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                            $actype = array();
                            foreach($acc as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                            $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
        
        
                            $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                            $actype = array();
                            foreach($acc1 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                            $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
                            
                            $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $actype = array();
                            foreach($acc2 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                            $actype = array();
                            foreach($acc3 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
                   
                            // ເງິນກູ້ໄລຍະສັ້ນ
                            $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນຈົດທະບຽນ
                            $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນເຈົ້າຂອງທຸລະກິດ
                            $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
                            $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                            $actype = array();
                            foreach($acc5 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ກຳໄລໃນປີ
                            $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                            //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                            //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $report_date_type = 'ງວດ 2';
                            $report_date_start = $start_3month;
                            $report_date_end = $end_3month;
        
                        break;
        
                        case 'm7-9':
                            
        
        
                            // 3 ເດືອນກ່ອນ
                            $date_m1_3 = $y.'-7-1';
        
                            $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                            $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();
        
                            // 3 ເດືອນຕົ້ນປີ
                            $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                            $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                            //echo $end_3month;
        
                            //echo $start_3month_last.' - '.$end_3month_last;
                            //echo $start_3month.' - '.$end_3month;
        
                           $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                            $actype = array();
                            foreach($acc as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                            $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
        
        
                            $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                            $actype = array();
                            foreach($acc1 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                            $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
                            
                            $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $actype = array();
                            foreach($acc2 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                            $actype = array();
                            foreach($acc3 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
                   
                            // ເງິນກູ້ໄລຍະສັ້ນ
                            $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນຈົດທະບຽນ
                            $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນເຈົ້າຂອງທຸລະກິດ
                            $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
                            $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                            $actype = array();
                            foreach($acc5 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ກຳໄລໃນປີ
                            $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                            //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                            //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $report_date_type = 'ງວດ 3';
                            $report_date_start = $start_3month;
                            $report_date_end = $end_3month;
        
                        break;
        
                        case 'm10-12':
        
        
              
        
                            // 3 ເດືອນກ່ອນ
                            $date_m1_3 = $y.'-10-1';
        
                            $start_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->startOfMonth()->subMonth(2);
                            $end_3month_last = Carbon::createFromFormat('Y-m-d',$date_m1_3)->subMonthsNoOverflow()->endOfMonth();
        
                            // 3 ເດືອນຕົ້ນປີ
                            $start_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                            $end_3month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->addMonths(2)->endOfMonth();
                            //echo $end_3month;
        
                            //echo $start_3month_last.' - '.$end_3month_last;
                            //echo $start_3month.' - '.$end_3month;
        
                            $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                            $actype = array();
                            foreach($acc as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                            $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $neesentother_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $neesentother_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
        
        
                            $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                            $actype = array();
                            foreach($acc1 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                            $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $intsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $intsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
        
                            
                            $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $actype = array();
                            foreach($acc2 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $taxsent_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $taxsent_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                            $actype = array();
                            foreach($acc3 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
                   
                            // ເງິນກູ້ໄລຍະສັ້ນ
                            $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $loan_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $loan_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນຈົດທະບຽນ
                            $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $standset_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $standset_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນເຈົ້າຂອງທຸລະກິດ
                            $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month_last, $end_3month_last])->whereIn('dr',$actype)->sum('sum');
                            $stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$start_3month, $end_3month])->whereIn('dr',$actype)->sum('sum');
                            
                            $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                            $actype = array();
                            foreach($acc5 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ກຳໄລໃນປີ
                            $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                            //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                            //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                            
        
        
                            $report_date_type = 'ງວດ 4';
                            $report_date_start = $start_3month;
                            $report_date_end = $end_3month;
        
                        break;
        
                        case 'y':
        
                            $date_m1_3 = $y.'-1-1';
                        
                            $start_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->startOfMonth();
                            $end_month = Carbon::createFromFormat('Y-m-d',$date_m1_3)->endOfMonth()->addMonths(11);
        
                        
        
                        //     $acc = Acc::where('acc_cat_sub_id', '=', '14')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                        //     $actype = array();
                        //     foreach($acc as $acc_id){
                        //             array_push($actype,$acc_id['acc_id']);
                        //     }
        
                            // ເງິນສົດ ແລະ ສີ່ງທຽບເທົ່າເງິນສົດ
                        //     $curr_all = AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                        //     $curr_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum');
                        //     $curr_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum');
                            
        
                            $acc = Acc::where('acc_cat_sub_id', '=', '8')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆດ
                            $actype = array();
                            foreach($acc as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງໃນທຸລະກິດ ແລະ ໜີ້ຕ້ອງສົ່ງອື່ນໆ
                            $neesentother_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $neesentother_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $neesentother_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
        
        
        
                            $acc1 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ດອຫເບ້ຍເງິນກູ້ຕ້ອງສົ່ງ
                            $actype = array();
                            foreach($acc1 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ດອກເບ້ຍເງິນກູ້ ຕ້ອງສົ່ງ
                            $intsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $intsent_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $intsent_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
        
                            
                            $acc2 = Acc::where('acc_cat_sub_id', '=', '9')->get(); /// ເລືອກບັນຊີປະເພດ ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $actype = array();
                            foreach($acc2 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ໜີ້ຕ້ອງສົ່ງອາກອນ
                            $taxsent_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $taxsent_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $taxsent_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc3 = Acc::where('acc_cat_sub_id', '=', '7')->get(); /// ເລືອກບັນຊີປະເພດ ເງິນກູ້ໄລຍະສັ້ນ
                            $actype = array();
                            foreach($acc3 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
                   
                            // ເງິນກູ້ໄລຍະສັ້ນ
                            $loan_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $loan_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $loan_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '1')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນຈົດທະບຽນ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນຈົດທະບຽນ
                            $standset_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $standset_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $standset_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                            
        
                            $acc4 = Acc::where('acc_cat_sub_id', '=', '2')->get(); /// ເລືອກບັນຊີປະເພດ ທຶນເຈົ້າຂອງທຸລະກິດ
                            $actype = array();
                            foreach($acc4 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ທຶນເຈົ້າຂອງທຸລະກິດ
                            $stand_all = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereIn('dr',$actype)->sum('sum'); 
                            $stand_last_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y-1))->whereIn('dr',$actype)->sum('sum');
                            $stand_this_month = AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereYear('created_at', date($y))->whereIn('dr',$actype)->sum('sum');
                            
                            $acc5 = Acc::where('acc_cat_sub_id', '=', '3')->get(); /// ເລືອກບັນຊີປະເພດ ກຳໄລໃນປີ
                            $actype = array();
                            foreach($acc5 as $acc_id){
                                    array_push($actype,$acc_id['acc_id']);
                            }
        
                            // ກຳໄລໃນປີ
                            $profityear = AccTRN::where('work_status','success')->whereIn('cr',$actype)->sum('sum'); 
                            //$stand_last_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$last_month_start, $last_month_end])->whereIn('dr',$actype)->sum('sum');
                            //$stand_this_month = AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('cr',$actype)->sum('sum')-AccTRN::where('work_status','success')->whereBetween('created_at', [$date_start, $date_end])->whereIn('dr',$actype)->sum('sum');
                            
        
                            $report_date_type = 'ປີ';
                            $report_date_start = $start_month;
                            $report_date_end = $end_month;


                            $AllProduct = Product::join('session_products','products.session_id','=','session_products.id')
                                ->join('units','products.product_unit','=','units.id')
                                ->select('products.*','session_products.*','units.*')
                                ->where('products.in_store','>','0')
                                ->whereYear('products.created_at', date($y))
                                ->orderBy('products.in_store','desc')
                                ->get();

                            $report_date_type = 'ເດືອນ';
                            $report_date_start = $date_start;
                            $report_date_end = $date_end;
                
                            $AllProductStore = $AllProduct;
        
                        break;
        
                    }



                $success = true;
                $message = 'ສຳເລັດ!';
    
            } catch (\Illuminate\Database\QueryException $ex) {
                $AllProductStore = '';
                $success = false;
                $message = $ex->getMessage();
            }
    
            $response = [
                'AllProductStore' => $AllProductStore,
                // 'ProductLost' => $ProductLost,
                // 'Sell_Pro_Ser' => $Sell_Pro_Ser,
                // 'Import_Pro' => $Import_Pro,
                // 'SellG' => $SellG,
                'success' => $success,
                'message' => $message,
            ];
            return response()->json($response);
    }

    public function ReportStoreExport(){
        // return 'Ok';
        return Excel::download(new ProductsExport, 'product.xlsx');
    }
}
