<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use App\Models\ACC\AccTRN;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AccTRNController extends Controller
{
    //
    public function index()
    {
        if(check_roles('transession_access')){

            //return Auth::user()->user_type;

            if(Auth::user()->user_type=='admin'){
                $acc = AccTRN::leftJoin('users', 'users.id', '=', 'acc_t_r_n_s.user_id')
                ->where('acc_t_r_n_s.work_status','success')
                ->orderBy('created_at', 'desc')
                ->paginate(20,array('acc_t_r_n_s.*', 'users.user_name','users.name','users.last_name','users.sex',))
                ->toArray();
            } else {
                $user_id = Auth::user()->id;
                $acc = AccTRN::leftJoin('users', 'users.id', '=', 'acc_t_r_n_s.user_id')
                ->where('acc_t_r_n_s.user_id',$user_id )
                ->where('acc_t_r_n_s.work_status','success')
                ->orderBy('created_at', 'desc')
                ->paginate(20,array('acc_t_r_n_s.*', 'users.user_name','users.name','users.last_name','users.sex',))
                ->toArray();
            }

            
            return array_reverse($acc);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

      //  }

    }

    public function add(Request $request)
    {
        if(check_roles('transession_add_in') || check_roles('transession_add_ex') || check_roles('transession_add_ap')){
        // start permissions
        try {

            $trn_org = AccTRN::orderBy('id', 'desc')->take(1)->get();
                            $number = $trn_org[0]['trn_id'];
                            
                            if($number){
                                $number1 = str_replace("INC","",$number);
                                $number2 = str_replace("EXP","",$number1);
                                $number3 = str_replace("CAP","",$number2);
                                $number4 = str_replace("CIN","",$number3);
                                $number5 = str_replace("EXC","",$number4);
                                $number = (int)$number5+1;
                                $length = 8;
                                $number = substr(str_repeat(0, $length).$number, - $length);
                               
                            } else {
                                $number_c = 1;
                                $number = substr(str_repeat(0, $length).$number_c, - $length);
                            }
            if($request->acc_type=='income'){ $tnum = 'INC'; }
            elseif($request->acc_type=='expense'){ $tnum = 'EXP'; }
            elseif($request->acc_type=='capital'){ $tnum = 'CAP'; }
            elseif($request->acc_type=='cincome'){ $tnum = 'CIN'; }
            elseif($request->acc_type=='exchange'){ $tnum = 'EXC'; }

            $accs = new AccTRN([
                'trn_id' => $tnum.$number,
                'trn_type' => $request->acc_type,
                'acc_trn_detail' => $request->acc_trn_detail,
                'amount' => $request->amount,
                'count' => 1,
                'sum' => $request->sum,
                'rate' => $request->rate,
                'dr' => $request->dr,
                'cr' => $request->cr,
                'user_id' => $request->user_id,
                'work_status' => 'success'
            ]);
            $accs->save();

            $success = true;
            $message = 'add successfully';

            $acc = AccTRN::orderBy('created_at', 'desc')
            ->paginate(20)
            ->toArray();
            $que = array_reverse($acc);

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $que = '';
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que,
        ];
        return response()->json($response);

        // end permissions
    } else {
        $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
        return response()->json($response);
    }

    }

    public function edit($id)
    {
        $acc = AccTRN::find($id);
        return response()->json($acc);
    }

    public function update($id, Request $request)
    {
        try {

            $acc = AccTRN::find($id);
            $acc->update($request->all());

            $success = true;
            $message = 'update successfully';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

    }

    public function delete($id)
    {
        if(check_roles('transession_remove')){

        try {

            // $acc = AccTRN::find($id);
            // $acc->delete();

            AccTRN::where('id',$id)->update([ 'work_status'=> 'reject' ]);

            $success = true;
            $message = 'delete successfully';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}
