<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use App\Models\ACC\AccTL;
use Illuminate\Http\Request;

class AccTLController extends Controller
{
    public function index()
    {
        if(check_roles('acc_access_phacc')){
            /// start permissions

        $type = \Request::get('type');
        if($type=='all'){
            $acc = AccTL::orderBy('created_at', 'asc')
            ->get();
            return $acc;
        } else {
            $acc = AccTL::where('acc_type','=',$type)
            ->orderBy('created_at', 'asc')
            ->paginate(10)
            ->toArray();
            return array_reverse($acc);
        }

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function add(Request $request)
    {
        if(check_roles('acc_access_phacc_add')){
            /// start permissions

        try {

            $accs = new AccTL([
                'acc_type' => $request->acc_type,
                'acc_detail' => $request->acc_detail,
                'dr' => $request->dr,
                'cr' => $request->cr,
            ]);
            $accs->save();


            $acc = AccTL::where('acc_type','=', $request->acc_type)
            ->orderBy('created_at', 'asc')
            ->paginate(10)
            ->toArray();
            $que = array_reverse($acc);

            $success = true;
            $message = 'add successfully';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $que = '';
        }

        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
    public function edit($id)
    {
        if(check_roles('acc_access_phacc_edit')){
            /// start permissions

        $acc = AccTL::find($id);
        return response()->json($acc);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
    public function update($id, Request $request)
    {
        if(check_roles('acc_access_phacc_edit')){
            /// start permissions

        try {
            $acc = AccTL::find($id);
            $acc->update($request->all());
            $acc = AccTL::where('acc_type','=', $request->acc_type)
            ->orderBy('created_at', 'asc')
            ->paginate(10)
            ->toArray();
            $que = array_reverse($acc);
            $success = true;
            $message = 'ຂໍ້ມູນບັນທຶກ ສຳເລັດແລ້ວ!';
        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            $que = '';
        }
        $response = [
            'success' => $success,
            'message' => $message,
            'que' => $que,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function delete($id)
    {
        if(check_roles('acc_access_phacc_remove')){
            /// start permissions

        try {

            $acc = AccTL::find($id);
            $acc->delete();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}
