<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use App\Models\ACC\AccSubCat;
use Illuminate\Http\Request;

class AccSubCatController extends Controller
{
     
    public function index()
    {
        if(check_roles('acc_access_ph')){
            
        $bid = \Request::get('id');
        $litem = AccSubCat::where('acc_cat_id',$bid)->orderBy('created_at', 'asc')->get();
        return response()->json($litem);

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function add(Request $request)
    {

        if(check_roles('acc_access_ph_add')){
            // start permission 

        try {

            $accs = new AccSubCat([
                'acc_cat_id' => $request->acc_cat_id,
                'acc_cat_sub_name' => $request->acc_cat_sub_name,
            ]);
            $accs->save();

            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຊື່ໝວດບັນຊີຍ່ອຍ: '.$request->acc_cat_sub_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຊື່ໝວດບັນຊີຍ່ອຍ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function edit($id)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        $acc = AccSubCat::find($id);
        return response()->json($acc);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function update($id, Request $request)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        try {

            $acc = AccSubCat::find($id);
            $acc->update($request->all());
            
            $success = true;
            $message = 'ບັນທຶກຂໍ້ມູນ ສຳເລັດ!';

            $acccat_update = AccSubCat::find($id);
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຊື່ໝວດບັນຊີຍ່ອຍ: '.$acccat_update['acc_cat_sub_name'],'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຊື່ໝວດບັນຊີຍ່ອຍ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);
        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function delete($id)
    {
        if(check_roles('acc_access_ph_remove')){
            // start permission 

        try {

            $acc_del = AccSubCat::find($id);
            $acc = AccSubCat::find($id);
            $acc->delete();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຊື່ໝວດບັນຊີຍ່ອຍ: '.$acc_del['acc_cat_sub_name'].' ອອກຈາກລະບົບ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຊື່ໝວດບັນຊີຍ່ອຍ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }
}
