<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use App\Models\ACC\Acc;
use Illuminate\Http\Request;

class AccController extends Controller
{

    public function index()
    {
       // $accs = Acc::all()->toArray();
       // return array_reverse($accs);
       if(check_roles('acc_access_ph')){
        // start permissions 

        $key = \Request::get('s');
        $acct = \Request::get('acct');
        if($acct == 'all'){
            $acc = Acc::where('accs.acc_id','LIKE',"%{$key}%")->orWhere('accs.acc_name','LIKE',"%{$key}%")
            ->leftJoin('acc_categories', 'acc_categories.id', '=', 'accs.acc_cat_id')
            ->leftJoin('acc_sub_cats', 'acc_sub_cats.id', '=', 'accs.acc_cat_sub_id')
            ->orderBy('acc_id', 'asc')
            ->paginate(10, array('accs.*', 'acc_categories.acc_cat_name','acc_sub_cats.acc_cat_sub_name'))
            ->toArray();
            return array_reverse($acc);
        } else {
        
            if($key!=''){
                $acc = Acc::where('accs.acc_cat_id','=',$acct)->orwhere('accs.acc_id','LIKE',"%{$key}%")->orWhere('accs.acc_name','LIKE',"%{$key}%")
            ->leftJoin('acc_categories', 'acc_categories.id', '=', 'accs.acc_cat_id')
            ->leftJoin('acc_sub_cats', 'acc_sub_cats.id', '=', 'accs.acc_cat_sub_id')
            ->orderBy('acc_id', 'asc')
            ->paginate(10, array('accs.*', 'acc_categories.acc_cat_name','acc_sub_cats.acc_cat_sub_name'))
            ->toArray();
            return array_reverse($acc);
            }else{
                $acc = Acc::where('accs.acc_cat_id','=',$acct)
            ->leftJoin('acc_categories', 'acc_categories.id', '=', 'accs.acc_cat_id')
            ->leftJoin('acc_sub_cats', 'acc_sub_cats.id', '=', 'accs.acc_cat_sub_id')
            ->orderBy('acc_id', 'asc')
            ->paginate(10, array('accs.*', 'acc_categories.acc_cat_name','acc_sub_cats.acc_cat_sub_name'))
            ->toArray();
            return array_reverse($acc);
            }
            

        }
       

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function add(Request $request)
    {
        if(check_roles('acc_access_ph_add')){
        // start permission 
        try {

            $accs = new Acc([
                'acc_id' => $request->acc_id,
                'acc_name' => $request->acc_name,
                'acc_cat_id' => $request->acc_cat_id,
                'acc_cat_sub_id' => $request->acc_cat_sub_id,
                'acc_type' => $request->acc_type,
            ]);
            $accs->save();

             // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
             save_logs('ເພີ່ມບັນຊີໃໝ່: '.$request->acc_name.' ເລກບັນຊີ: '.$request->acc_id,'success');

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ບັນທຶກ ສຳເລັດແລ້ວ!';

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ບັນທຶກບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }
    }

    public function edit($id)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        $acc = Acc::find($id);
        return response()->json($acc);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        try {

            $acc = Acc::find($id);
            $acc->update($request->all());
            
            $success = true;
            $message = 'ຂໍ້ມູນອັບເດດ ສຳເລັດ!';

            $acc_up = Acc::find($id);

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດບັນຊີ: '.$acc_up['acc_name'].' ເລກບັນຊີ: '.$acc_up['acc_id'],'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function delete($id)
    {

        if(check_roles('acc_access_ph_remove')){
            // start permission 

        try {
            $acc_old = Acc::find($id);
            $acc = Acc::find($id);
            $acc->delete();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບບັນຊີ: '.$acc_old['acc_name'].' ເລກບັນຊີ: '.$acc_old['acc_id'].' ອອກຈາກລະບົບ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
}
