<?php

namespace App\Http\Controllers\ACC;

use App\Http\Controllers\Controller;
use App\Models\ACC\AccCategory;
use Illuminate\Http\Request;

class AccCategoryController extends Controller
{
    
    public function index()
    {
        if(check_roles('acc_access_ph')){

        $acccat = AccCategory::orderBy('created_at', 'ASC')->get();
        return $acccat;

        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function add(Request $request)
    {
        if(check_roles('acc_access_ph_add')){
            // start permission 

        try {

            $acccat = new AccCategory([
                'acc_cat_name' => $request->acc_cat_name,
            ]);
            $acccat->save();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດ!';

            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຊື່ໝວດບັນຊີ: '.$request->acc_cat_name,'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ເພີ່ມຊື່ໝວດບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }


    }

    public function edit($id)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        $acccat = AccCategory::find($id);
        return response()->json($acccat);

        // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function update($id, Request $request)
    {
        if(check_roles('acc_access_ph_edit')){
            // start permission 

        try {
            
            $acccat = AccCategory::find($id);
            $acccat->update($request->all());
            
            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກບັນທຶກ ສຳເລັດ!';

            $acccat_update = AccCategory::find($id);
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຊື່ໝວດບັນຊີ: '.$acccat_update['acc_cat_name'],'success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ອັບເດດຊື່ໝວດບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }

    public function delete($id)
    {

        if(check_roles('acc_access_ph_remove')){
            // start permission 

        try {
            $acccat_del = AccCategory::find($id);
            $acccat = AccCategory::find($id);
            $acccat->delete();

            $success = true;
            $message = 'ຂໍ້ມູນໄດ້ຖຶກລຶບ ສຳເລັດແລ້ວ!';

            
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຊື່ໝວດບັນຊີ: '.$acccat_del['acc_cat_name'].' ອອກຈາກລະບົບ','success');

        } catch (\Illuminate\Database\QueryException $ex) {
            $success = false;
            $message = $ex->getMessage();
            // ບັນທຶກ ການເຄື່ອນໄຫວ save logs
            save_logs('ລຶບຊື່ໝວດບັນຊີ error: '.$message,'error');
        }

        $response = [
            'success' => $success,
            'message' => $message,
        ];
        return response()->json($response);

         // end permissions
        } else {
            $response = ['message' => 'ທ່ານ ບໍ່ມີສິດເຂົ້າເຖິງຂໍ້ມູນ!', ];
            return response()->json($response);
        }

    }
}
